/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.detail;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.component.ApprovalRecord;
import kd.ssc.hstc.business.service.TaskStatechangeService;

public class TaskApproveHrPauserecordFormPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaskApproveHrPauserecordFormPlugin.class);
    private static final String COMMON_URL = "/images/pc/emotion/default_person_82_82.png";

    public void initialize() {
        ControlTypes.register(ApprovalRecord.class);
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long taskid = Long.parseLong(formShowParameter.getCustomParam("taskid").toString());
        boolean isHist = Boolean.parseBoolean(formShowParameter.getCustomParam("isHist").toString());
        List<Map<String, Object>> approvalRecordItems = this.getApproveRecordItems(taskid, isHist);
        ((ApprovalRecord)this.getControl("pauserecordap")).setData(approvalRecordItems);
    }

    private List<Map<String, Object>> getApproveRecordItems(long taskid, boolean isHist) {
        ArrayList<Map<String, Object>> approvalRecordItems = new ArrayList<Map<String, Object>>(10);
        DynamicObjectCollection pauseRecordDataColl = TaskStatechangeService.getInstance().queryCollPauserecord(Long.valueOf(taskid), !isHist);
        if (!CollectionUtils.isEmpty((Collection)pauseRecordDataColl)) {
            SimpleDateFormat longformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (DynamicObject pauseRecordDy : pauseRecordDataColl) {
                HashMap<String, Object> item = new HashMap<String, Object>(16);
                item.put("group", "approved");
                item.put("groupDecisionType", "approve");
                ArrayList childrenItems = new ArrayList(10);
                HashMap<String, String> childrenItem = new HashMap<String, String>(16);
                childrenItem.put("openId", pauseRecordDy.getString("operatorid.useropenid"));
                long operatorid = pauseRecordDy.getLong("operatorid.id");
                if (operatorid > 0L) {
                    Map userAvatarPath = UserServiceHelper.getUserAvatarPath(Collections.singletonList(operatorid), (boolean)true);
                    if (StringUtils.isNotEmpty((String)((String)userAvatarPath.get(operatorid)))) {
                        childrenItem.put("avatar", (String)userAvatarPath.get(operatorid));
                    } else {
                        childrenItem.put("avatar", COMMON_URL);
                    }
                }
                childrenItem.put("userName", pauseRecordDy.getString("operatorid.name"));
                childrenItem.put("decisionType", "approve");
                String operation = pauseRecordDy.getString("operation");
                String resultName = "";
                if ("3".equals(pauseRecordDy.getString("operation"))) {
                    resultName = String.format(ResManager.loadKDString((String)"%s\uff1a\u6682\u6302", (String)"TaskApproveHrPauserecordFormPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), "");
                } else if ("4".equals(pauseRecordDy.getString("operation"))) {
                    resultName = String.format(ResManager.loadKDString((String)"%s\uff1a\u53d6\u6d88\u6682\u6302", (String)"TaskApproveHrPauserecordFormPlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), "");
                }
                childrenItem.put("resultName", resultName);
                childrenItem.put("time", longformat.format(pauseRecordDy.getDate("changetime")));
                childrenItem.put("message", pauseRecordDy.getString("message"));
                childrenItems.add(childrenItem);
                item.put("children", childrenItems);
                approvalRecordItems.add(item);
            }
        }
        return approvalRecordItems;
    }
}

