/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.detail.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BillAttributeControlUtil {
    private static final Log log = LogFactory.getLog(BillAttributeControlUtil.class);
    private static Set<String> ctrlApTypes = new HashSet<String>(2);

    public static Map<String, Map<String, Object>> getNeedShowButtonAps(long billTpeId, long taskTypeId) {
        HashMap<String, Map<String, Object>> buttonAps = new HashMap<String, Map<String, Object>>(8);
        if (billTpeId <= 0L || taskTypeId <= 0L) {
            return buttonAps;
        }
        long childpkid = BillAttributeControlUtil.queryChildPKId(billTpeId, taskTypeId);
        if (childpkid == 0L) {
            log.error(String.format("BillAttributeControlUtil.queryChildPKId() Exception\uff1abillTpeId=%s, taskTypeId=%s, childpkid=%s", billTpeId, taskTypeId, childpkid));
            return buttonAps;
        }
        String billAttriConfJson = BillAttributeControlUtil.getBillAttriConfigJson(childpkid);
        if (StringUtils.isEmpty((String)billAttriConfJson)) {
            log.info(String.format("\u672a\u914d\u7f6e\u5355\u636e\u4fee\u6539\u6743\u9650 billTpeId=%s, taskTypeId=%s, childpkid=%s, billAttriconfJson=%s", billTpeId, taskTypeId, childpkid, billAttriConfJson));
            return buttonAps;
        }
        BillAttributeControlUtil.parseBillAttriConfJson(buttonAps, billAttriConfJson);
        return buttonAps;
    }

    private static long queryChildPKId(long billTpeId, long taskTypeId) {
        long childpkid = 0L;
        QFilter billIdFil = new QFilter("id", "=", (Object)billTpeId);
        QFilter taskTypeIdFil = new QFilter("entryentity.tasktype", "=", (Object)taskTypeId);
        String algoKey = BillAttributeControlUtil.class + "queryChildPKId()";
        try (DataSet taskBillSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_taskbill", (String)"id,entryentity.childpkid childpkid", (QFilter[])new QFilter[]{billIdFil, taskTypeIdFil}, null, (int)1);){
            Iterator it = taskBillSet.iterator();
            if (it.hasNext()) {
                Row row = (Row)it.next();
                childpkid = row.getLong("childpkid");
            }
        }
        return childpkid;
    }

    private static String getBillAttriConfigJson(long childpkid) {
        String billAttriConfJson = null;
        QFilter childIdFil = new QFilter("id", "=", (Object)childpkid);
        String algoKey = BillAttributeControlUtil.class + "getNeedShowButtonAps()";
        try (DataSet childBillSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_taskbill_child", (String)"billattriconfigjson_tag", (QFilter[])new QFilter[]{childIdFil}, null, (int)1);){
            Iterator it = childBillSet.iterator();
            if (it.hasNext()) {
                Row row = (Row)it.next();
                billAttriConfJson = row.getString("billattriconfigjson_tag");
            }
        }
        return billAttriConfJson;
    }

    private static void parseBillAttriConfJson(Map<String, Map<String, Object>> buttonAps, String billAttriConfJson) {
        List selectedValue = SerializationUtils.fromJsonStringToList((String)billAttriConfJson, Map.class);
        for (Map ctrlApInfo : selectedValue) {
            String ctrlApType = (String)ctrlApInfo.get("ctrlaptype");
            boolean hide = (Boolean)ctrlApInfo.get("hide");
            if (hide || !ctrlApTypes.contains(ctrlApType)) continue;
            String ctrlApNum = (String)ctrlApInfo.get("ctrlapnumber");
            if (ctrlApNum.indexOf(46) >= 0) {
                int pointIndex = ctrlApNum.lastIndexOf(46);
                ctrlApNum = ctrlApNum.substring(pointIndex + 1);
            }
            buttonAps.put(ctrlApNum, ctrlApInfo);
        }
    }

    static {
        ctrlApTypes.add("BarItemAp");
        ctrlApTypes.add("MBarItemAp");
    }
}

