/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.workflow.taskcenter.plugin.util.WorkflowTCDataPluginUtil;
import kd.hr.hbp.business.servicehelper.HRAppServiceHelper;
import kd.ssc.hstc.business.service.ArtiCheckPointService;
import kd.ssc.hstc.business.service.SscDutymanageService;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.common.entity.GetNextTaskResult;
import kd.ssc.hstc.formplugin.web.common.TaskApproveHrBaseFormPlugin;
import kd.ssc.hstc.formplugin.web.helper.MutexCacheHelper;
import kd.ssc.hstc.formplugin.web.helper.TaskApproveShowFormHelper;
import kd.ssc.hstc.util.ObjectUtils;

public class TaskApproveFormHelper {
    private static final Log LOGGER = LogFactory.getLog(TaskApproveHrBaseFormPlugin.class);

    public static String getCustomParam(IFormView view, String paramKey) {
        return TaskApproveFormHelper.getCustomParam(view, paramKey, String.class);
    }

    public static <T> T getCustomParam(IFormView view, String paramKey, Class<T> clazz) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object paramValue = formShowParameter.getCustomParam(paramKey);
        if (clazz == String.class) {
            paramValue = ObjectUtils.getStringValOfObject((Object)paramValue);
        } else if (clazz == Long.class) {
            paramValue = ObjectUtils.getLongValOfObject((Object)paramValue);
        } else if (clazz == Boolean.class) {
            paramValue = ObjectUtils.getBooleanValOfObject((Object)paramValue);
        } else if (clazz == Integer.class) {
            paramValue = ObjectUtils.getIntValOfObject((Object)paramValue);
        }
        return (T)paramValue;
    }

    public static boolean isLoading(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String isload = pageCache.get("SSC_FORM_ISLOAD");
        return StringUtils.isBlank((CharSequence)isload) || StringUtils.equals((CharSequence)"true", (CharSequence)isload);
    }

    public static void setLoading(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        pageCache.put("SSC_FORM_ISLOAD", "true");
    }

    public static void setLoadDone(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        pageCache.put("SSC_FORM_ISLOAD", "false");
    }

    public static void setShowBillcontainerPageId(IFormView view, String pageId) {
        IPageCache pageCache = view.getPageCache();
        pageCache.put("pageID", pageId);
        TaskApproveFormHelper.setLoading(view);
    }

    public static String getShowBillcontainerPageId(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        return pageCache.get("pageID");
    }

    public static DynamicObject getSubViewBilldata(IFormView view) {
        IFormView subView = TaskApproveFormHelper.getSubViewByPageCachePgID(view);
        if (subView != null) {
            return subView.getModel().getDataEntity(true);
        }
        return null;
    }

    public static Long getSubViewBilldataId(IFormView view) {
        DynamicObject subViewBilldata = TaskApproveFormHelper.getSubViewBilldata(view);
        return subViewBilldata != null ? subViewBilldata.getLong("id") : 0L;
    }

    public static IFormView getSubViewByPageCachePgID(IFormView view) {
        return view.getViewNoPlugin(TaskApproveFormHelper.getShowBillcontainerPageId(view));
    }

    public static boolean preValidate(IFormView view) {
        boolean loading = TaskApproveFormHelper.isLoading(view);
        if (loading) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u672a\u52a0\u8f7d\u5b8c\u5168\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...", (String)"TaskApproveFormHelper_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long taskId = TaskApproveFormHelper.getCustomParam(view, "taskid", Long.class);
        boolean iscacelState = TaskService.getInstance().isCancelState(taskId);
        if (iscacelState) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u5df2\u88ab\u66f4\u65b0\u4e3a\u201c\u53d6\u6d88\u201d\uff0c\u6b63\u5728\u5c1d\u8bd5\u7684\u64cd\u4f5c\u65e0\u6cd5\u5b8c\u6210", (String)"TaskApproveFormHelper_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static void setMutexCache(IFormView view) {
        String pooltypeMytask = TaskApproveFormHelper.getCustomParam(view, "pooltype-mytask");
        String taskidStr = TaskApproveFormHelper.getCustomParam(view, "taskid");
        if (StringUtils.equals((CharSequence)pooltypeMytask, (CharSequence)"1")) {
            MutexCacheHelper.putMutexCache(String.valueOf(RequestContext.get().getCurrUserId()), taskidStr);
        }
    }

    public static void releaseMutexCache(IFormView view) {
        String pooltypeMytask = TaskApproveFormHelper.getCustomParam(view, "pooltype-mytask");
        String taskidStr = TaskApproveFormHelper.getCustomParam(view, "taskid");
        if (StringUtils.equals((CharSequence)pooltypeMytask, (CharSequence)"1")) {
            MutexCacheHelper.removeMutexCache(taskidStr);
        }
    }

    public static boolean containsMutexCache(IFormView view) {
        String pooltypeMytask = TaskApproveFormHelper.getCustomParam(view, "pooltype-mytask");
        String taskidStr = TaskApproveFormHelper.getCustomParam(view, "taskid");
        if (StringUtils.equals((CharSequence)pooltypeMytask, (CharSequence)"1")) {
            return MutexCacheHelper.containsMutexCache(taskidStr);
        }
        return false;
    }

    public static long getProcessingTaskId(IFormView view) {
        if (TaskApproveFormHelper.isHisTask(view)) {
            return TaskApproveFormHelper.getCustomParam(view, "sourcetaskid", Long.class);
        }
        return TaskApproveFormHelper.getCustomParam(view, "taskid", Long.class);
    }

    public static long getHisTaskId(IFormView view) {
        if (TaskApproveFormHelper.isHisTask(view)) {
            return TaskApproveFormHelper.getCustomParam(view, "taskid", Long.class);
        }
        return 0L;
    }

    public static boolean isHisTask(IFormView view) {
        return TaskApproveFormHelper.getCustomParam(view, "sourcetaskid", Long.class) > 0L;
    }

    public static boolean isProcessingTask(IFormView view) {
        String ifProcessing = TaskApproveFormHelper.getCustomParam(view, "ifProcessing");
        if (ifProcessing != null) {
            return Boolean.parseBoolean(ifProcessing);
        }
        return !TaskApproveFormHelper.isHisTask(view);
    }

    public static void showCirculationPage(IFormView view, CloseCallBack closeCallBack) {
        Long assignId = TaskApproveFormHelper.getCustomParam(view, "assignId", Long.class);
        HashMap<String, Long> customParams = new HashMap<String, Long>(16);
        customParams.put("taskid", assignId);
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("task_taskcirculation");
        para.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u4f20\u9605", (String)"TaskApproveFormHelper_2", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        para.setCustomParams(customParams);
        para.setCloseCallBack(closeCallBack);
        view.showForm(para);
    }

    public static void showCirculateLog(IFormView view) {
        Long assignId = TaskApproveFormHelper.getCustomParam(view, "assignId", Long.class);
        FormShowParameter para = WorkflowTCDataPluginUtil.getCirculateLogParameter((Long)assignId);
        para.setFormId("task_taskcirculationlog");
        view.showForm(para);
    }

    public static boolean isEmbedBill(IFormView view) {
        return TaskApproveFormHelper.getCustomParam(view, "isembed", Boolean.class);
    }

    public static void setAuditRecord(IFormView view) {
        Long taskid = TaskApproveFormHelper.getCustomParam(view, "taskid", Long.class);
        boolean isHist = TaskApproveFormHelper.isHisTask(view);
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setCustomParam("taskid", (Object)taskid.toString());
        parameEdit.setCustomParam("isHist", (Object)isHist);
        parameEdit.setFormId("hstc_tkappauditre");
        parameEdit.getOpenStyle().setTargetKey("approvalrecordtabpage");
        parameEdit.getOpenStyle().setShowType(ShowType.InContainer);
        view.showForm(parameEdit);
    }

    public static void setPauseRecord(IFormView view) {
        Long taskid = TaskApproveFormHelper.getCustomParam(view, "taskid", Long.class);
        boolean isHist = TaskApproveFormHelper.isHisTask(view);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("taskid", (Object)taskid.toString());
        showParameter.setCustomParam("isHist", (Object)isHist);
        showParameter.setFormId("hstc_tkappausere");
        showParameter.getOpenStyle().setTargetKey("pauserecordpanel");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        view.getPageCache().put("hstc_tkappausere_pageid", showParameter.getPageId());
        view.showForm(showParameter);
    }

    public static void saveArtiCheckPointInfo(String key, Long taskid, IDataModel model, Long historyId, boolean isFromTaskList, Long billTypeId, Long tasktypeid) {
        if (model == null) {
            return;
        }
        DynamicObject task = TaskService.getInstance().getTaskById("id,sourcetaskid,billtype,tasktypeid,billlongid", taskid.longValue(), true);
        if (task == null) {
            task = TaskService.getInstance().getTaskById("id,sourcetaskid,billtype,tasktypeid,billlongid", historyId.longValue(), false);
        }
        ArtiCheckPointService.getInstance().saveTaskArtiCheckPoint(model, new DynamicObject[]{task}, isFromTaskList, key);
    }

    public static void getNextTask(IFormView view) {
        long startTime = System.currentTimeMillis();
        Long taskId = TaskApproveFormHelper.getCustomParam(view, "taskid", Long.class);
        DynamicObject curtask = TaskService.getInstance().getTaskById("id,receivetime", taskId.longValue(), TaskApproveFormHelper.isProcessingTask(view));
        if (curtask == null) {
            curtask = ORM.create().newDynamicObject("task_task");
            curtask.set("receivetime", view.getFormShowParameter().getCustomParam("curtask_receivetime"));
            curtask.set("id", view.getFormShowParameter().getCustomParam("curtask_id"));
        }
        GetNextTaskResult res = TaskApproveFormHelper.getNextTaskDetail(view, curtask);
        LOGGER.info("getNextTask res : {}", (Object)res);
        if (!res.isSuccess()) {
            String msg = res.getMsg();
            view.showTipNotification(msg);
            view.showConfirm(msg, MessageBoxOptions.OK);
            view.close();
        }
        String invoker = TaskApproveFormHelper.getCustomParam(view, "invoker");
        String sourcePageId = TaskApproveFormHelper.getCustomParam(view, "sourcePageId");
        TaskApproveShowFormHelper.nextShowFormApprovalTask(view, res.getResTaskId(), invoker, sourcePageId);
        long endTime = System.currentTimeMillis();
        LOGGER.info("SSCServiceHelper taskApproveSubmit\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
    }

    public static GetNextTaskResult getNextTaskDetail(IFormView view, DynamicObject curtask) {
        DynamicObjectCollection allTaskDyColl;
        DynamicObject resTask;
        String selectfields = "id,sscid,billtype.bindbill,billtype.bindbill.id";
        QFilter typeFilter = new QFilter("qualitysamplelibrary", "=", (Object)0);
        Long personid = TaskApproveFormHelper.getCustomParam(view, "personid", Long.class);
        QFilter personFilter = new QFilter("personid", "=", (Object)personid);
        Date reveiveTime = curtask.getDate("receivetime");
        QFilter receiveTimeFilter = new QFilter("receivetime", ">=", (Object)reveiveTime);
        QFilter statusFilter = new QFilter("state", "in", (Object)Lists.newArrayList((Object[])new String[]{TaskStateEnum.TO_BE_AUDIT.getValue(), TaskStateEnum.REUPLOAD_IMAGE.getValue()}));
        Long sscid = TaskApproveFormHelper.getCustomParam(view, "sscid", Long.class);
        QFilter sscFilter = new QFilter("sscid", "=", (Object)sscid);
        String orderby = "receivetime asc, id asc";
        ArrayList processingQFilterList = Lists.newArrayList((Object[])new QFilter[]{receiveTimeFilter, statusFilter, sscFilter, personFilter, typeFilter});
        ArrayList allQFilterList = Lists.newArrayList((Object[])new QFilter[]{statusFilter, sscFilter, personFilter, typeFilter});
        if (TaskApproveFormHelper.isProcessingTask(view)) {
            QFilter notIdFilter = new QFilter("id", "!=", (Object)curtask.getLong("id"));
            processingQFilterList.add(notIdFilter);
            allQFilterList.add(notIdFilter);
            DynamicObjectCollection largeEqualsReceiveTimeTaskDyColl = TaskService.getInstance().queryCollTask(selectfields, processingQFilterList.toArray(new QFilter[0]), orderby);
            if (!CollectionUtils.isEmpty((Collection)largeEqualsReceiveTimeTaskDyColl) && (resTask = TaskApproveFormHelper.getNextResTask(largeEqualsReceiveTimeTaskDyColl)) != null) {
                return GetNextTaskResult.ok((DynamicObject)resTask);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(allTaskDyColl = TaskService.getInstance().queryCollTask(selectfields, allQFilterList.toArray(new QFilter[0]), orderby))) && (resTask = TaskApproveFormHelper.getNextResTask(allTaskDyColl)) != null) {
            return GetNextTaskResult.ok((DynamicObject)resTask);
        }
        return GetNextTaskResult.fail((String)ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u89c4\u5219\u7684\u5f85\u5206\u914d\u4efb\u52a1\uff0c\u4e0d\u80fd\u83b7\u53d6\u4efb\u52a1\u3002", (String)"TaskApproveFormHelper_4", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
    }

    private static DynamicObject getNextResTask(DynamicObjectCollection nextTaskDyColl) {
        Set hrAppIds = HRAppServiceHelper.getAllHRAppIds((boolean)true);
        for (DynamicObject nextTaskDy : nextTaskDyColl) {
            boolean matchFlag;
            long sscid = nextTaskDy.getLong("sscid");
            String bindBillId = nextTaskDy.getString("billtype.bindbill.id");
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)bindBillId, (MetaCategory)MetaCategory.Form);
            String appId = formMeta.getBizappId();
            if (CollectionUtils.isEmpty((Collection)hrAppIds) || !hrAppIds.contains(appId) || !(matchFlag = SscDutymanageService.getInstance().matchSscCenter(Long.valueOf(sscid), (List)Lists.newArrayList((Object[])new String[]{"3"})))) continue;
            return nextTaskDy;
        }
        return null;
    }
}

