/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.helper;

import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.service.TaskbillService;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.common.enums.TaskApprovePageInvokerEnum;
import org.apache.commons.lang3.StringUtils;

public class TaskApproveShowFormHelper {
    public static void nextShowFormApprovalTask(IFormView view, Long taskId, String invoke, String sourcePageId) {
        DynamicObject simpleTaskObj = TaskService.getInstance().queryTaskData(taskId.longValue(), "id,personid.id,qualitysamplelibrary.id,pooltype,state,tasktypeid.qualityjudge", true);
        if (simpleTaskObj == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u4efb\u52a1\u5217\u8868", (String)"TaskApproveShowFormHelper_5", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!TaskStateEnum.TO_BE_TRACKED.getValue().equals(simpleTaskObj.getString("state")) && RequestContext.get().getCurrUserId() != simpleTaskObj.getLong("personid.id")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u5df2\u7ecf\u91cd\u5206\u914d\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"TaskApproveShowFormHelper_6", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParam = new FormShowParameter();
        showParam.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParam.setCloseCallBack(new CloseCallBack("kd.ssc.hstc.formplugin.web.common.TaskQueryListPoolPlugin", "action_billhandling1"));
        showParam.setCustomParam("sourcePageId", (Object)sourcePageId);
        String qualityjudge = simpleTaskObj.getString("tasktypeid.qualityjudge");
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)qualityjudge)) {
            if (StringUtils.equals((CharSequence)"0", (CharSequence)qualityjudge)) {
                showParam.setFormId("hstc_taskapprove_billhr");
                TaskApproveShowFormHelper.showFormToApprove(view, taskId, true, invoke, showParam);
            } else if (!StringUtils.equals((CharSequence)"3", (CharSequence)qualityjudge) && StringUtils.equals((CharSequence)"4", (CharSequence)qualityjudge)) {
                showParam.setFormId("hstc_taskapprove_acthr");
                TaskApproveShowFormHelper.showFormToApprove(view, taskId, true, invoke, showParam);
            }
        }
    }

    public static void showFormToApprove(IFormView formView, String formId, Long taskId, boolean processTask, CloseCallBack callBack, String invoker) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId(formId);
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParam.getOpenStyle().setTargetKey("_submaintab_");
        showParam.setCloseCallBack(callBack);
        String pageId = formView.getPageId();
        showParam.setCustomParam("sourcePageId", (Object)pageId);
        showParam.setPageId(String.join((CharSequence)"_", pageId, formId, String.valueOf(taskId)));
        TaskApproveShowFormHelper.showFormToApprove(formView, taskId, processTask, invoker, showParam);
    }

    private static void showFormToApprove(IFormView formView, Long taskId, boolean processTask, String invoker, FormShowParameter showParam) {
        DynamicObject task = TaskApproveShowFormHelper.getTaskDynObj(taskId, processTask);
        if (!TaskApproveShowFormHelper.validateTaskData(formView, task)) {
            return;
        }
        TaskApproveShowFormHelper.setCustomParam(showParam, task, processTask, invoker);
        formView.showForm(showParam);
    }

    private static void setCustomParam(FormShowParameter showParam, DynamicObject task, boolean processTask, String invoker) {
        TaskApproveShowFormHelper.setCommonParams(showParam, task);
        TaskApproveShowFormHelper.setHRCommonParams(showParam, task, processTask);
        if (processTask) {
            showParam.setCustomParam("approveop", (Object)task.getString("approveop"));
            showParam.setCustomParam("pendingopinion", (Object)task.getString("pendingopinion"));
            showParam.setCustomParam("pendingopinions", task.get("pendingopinions"));
            showParam.setCustomParam("rescanopinion", (Object)task.getString("rescanopinion"));
            showParam.setCustomParam("unpassreasondata", (Object)task.getString("unpassreasondata"));
        }
        if (TaskApprovePageInvokerEnum.MY_TASK_LIST.getValue().equals(invoker)) {
            String poolType = task.getString("pooltype");
            showParam.setCustomParam("pooltype-mytask", (Object)poolType);
        } else if (TaskApprovePageInvokerEnum.TASK_ADMIN_LIST.getValue().equals(invoker)) {
            showParam.setCustomParam("from", (Object)"admin");
        }
        showParam.setCustomParam("invoker", (Object)invoker);
    }

    private static void setHRCommonParams(FormShowParameter showParam, DynamicObject task, boolean processTask) {
        showParam.setCustomParam("ifProcessing", (Object)processTask);
    }

    public static void setCustomParam(FormShowParameter showParam, Long taskId, boolean processTask, String invoker) {
        DynamicObject task = TaskApproveShowFormHelper.getTaskDynObj(taskId, processTask);
        TaskApproveShowFormHelper.setCustomParam(showParam, task, processTask, invoker);
    }

    public static void showFormToQualityCheck(IFormView formView, Long taskId, boolean isHisTask, CloseCallBack callBack, String invoker, boolean isTracked) {
        DynamicObject task = TaskApproveShowFormHelper.getTaskDynObj(taskId, !isHisTask);
        if (!TaskApproveShowFormHelper.validateTaskData(formView, task)) {
            return;
        }
        FormShowParameter showParam = new FormShowParameter();
        String state = task.getString("state");
        String formId = "";
        TaskStateEnum taskState = TaskStateEnum.getTaskState((String)state);
        if (taskState == null) {
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"TaskApprevalShowFormHelper_3", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), "taskState is null"));
            return;
        }
        switch (taskState) {
            case TO_BE_DIS: 
            case TO_BE_MANUAL_DIS: 
            case DIS_EXCEPTION: 
            case CHECKING: 
            case PAUSE_CHECKING: 
            case RECYCLE: {
                formId = "task_quality_docheck";
                break;
            }
            case RECTIFYING: 
            case PAUSE_RECTIFYING: {
                formId = "task_quality_dorectify";
                break;
            }
            case REVIEW: 
            case PAUSE_REVIEW: {
                formId = "task_quality_doreview";
                break;
            }
            case QUA_CHECK_COMPLETED: {
                formId = "task_quality_doreview";
                showParam.setCaption(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u5904\u7406\u5df2\u5b8c\u6210", (String)"TaskApprevalShowFormHelper_4", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
                showParam.setStatus(OperationStatus.VIEW);
                break;
            }
            default: {
                formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"TaskApprevalShowFormHelper_3", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), "taskState = " + taskState.getName()));
                return;
            }
        }
        showParam.setFormId(formId);
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParam.getOpenStyle().setTargetKey("_submaintab_");
        showParam.setCloseCallBack(callBack);
        TaskApproveShowFormHelper.setCommonParams(showParam, task);
        showParam.setCustomParam("reformperson", (Object)task.getString("reformperson.id"));
        showParam.setCustomParam("sampraryLibId", (Object)task.getString("qualitysamplelibrary.id"));
        if (TaskApprovePageInvokerEnum.MY_TASK_LIST.getValue().equals(invoker) || TaskApprovePageInvokerEnum.SMART_APPROVAL_SIMILAR_BILL.getValue().equals(invoker)) {
            showParam.setCustomParam("pooltype-mytask", (Object)task.getString("pooltype"));
            showParam.setCustomParam("ismytask", (Object)"mytask");
            if (isTracked) {
                showParam.setStatus(OperationStatus.VIEW);
            }
        } else if (TaskApprovePageInvokerEnum.QUALITY_CHECK_MANAGE_LIST.getValue().equals(invoker) || TaskApprovePageInvokerEnum.QUALITY_CHECK_PROGRESS_DETAIL_RPT.getValue().equals(invoker)) {
            showParam.setCustomParam("ismanagepage", (Object)"ismanagepage");
            showParam.setStatus(OperationStatus.VIEW);
        }
        formView.showForm(showParam);
    }

    private static DynamicObject getTaskDynObj(Long taskId, boolean processTask) {
        return TaskService.getInstance().queryTaskDataForShowTaskApprove(taskId, processTask);
    }

    public static boolean validateTaskData(IFormView formView, DynamicObject task) {
        if (task == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", (String)"TaskApprevalShowFormHelper_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (task.getLong("billtype.id") == 0L || task.getLong("tasktypeid.id") == 0L) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u6216\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728", (String)"TaskApprevalShowFormHelper_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return false;
        }
        String billBill = task.getString("billtype.bindbill.number");
        if (StringUtils.isEmpty((CharSequence)billBill)) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u5355\u636e\u5c5e\u6027\uff1a\u6765\u6e90\u5355\u636e\u5f02\u5e38\u3002", (String)"TaskApprevalShowFormHelper_2", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static void setCommonParams(FormShowParameter showParam, DynamicObject task) {
        String bizdataTag = task.getString("bizdata_tag");
        String bizdata = StringUtils.isEmpty((CharSequence)bizdataTag) ? null : bizdataTag;
        showParam.setCustomParam("taskid", (Object)task.getLong("id"));
        showParam.setCustomParam("tasktypeid", (Object)task.getLong("tasktypeid.id"));
        showParam.setCustomParam("billtypeid", (Object)task.getLong("billtype.id"));
        showParam.setCustomParam("billtype", (Object)task.getString("billtype.bindbill.number"));
        showParam.setCustomParam("billid", (Object)task.getString("billid"));
        showParam.setCustomParam("billno", (Object)task.getString("billnumber"));
        showParam.setCustomParam("personid", (Object)task.getString("personid.id"));
        showParam.setCustomParam("bizdata", (Object)bizdata);
        showParam.setCustomParam("apprevalmessage", (Object)task.getString("apprevalmessage"));
        showParam.setCustomParam("innermsg", (Object)task.getString("innermsg"));
        showParam.setCustomParam("state", (Object)task.getString("state"));
        showParam.setCustomParam("pooltype", (Object)task.getString("pooltype"));
        showParam.setCustomParam("billnumber", (Object)task.getString("billtype.bindbill.number"));
        DynamicObject taskBillDy = TaskbillService.getInstance().queryTaskBillChildData(task, "bindform.number");
        String bindFormNumber = taskBillDy == null ? null : taskBillDy.getString("bindform.number");
        showParam.setCustomParam("bindform", (Object)bindFormNumber);
        showParam.setCustomParam("sourcetaskid", (Object)task.getLong("sourcetaskid"));
        showParam.setCustomParam("isembed", (Object)task.getBoolean("billtype.isembed"));
        showParam.setCustomParam("imageNumber", (Object)task.getString("imagenumber"));
        showParam.setCustomParam("decisionitem", (Object)task.getString("decisionitem"));
        showParam.setCustomParam("unpassreasondesc", (Object)task.getString("unpassreasondesc"));
        showParam.setCustomParam("sscid", (Object)task.getLong("sscid.id"));
    }
}

