/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.htm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.ssc.hstc.business.service.SSCPermissionServiceHelper;
import kd.ssc.hstc.business.servicehelper.HRServiceHelper;
import kd.ssc.hstc.formplugin.web.common.TaskCommonService;
import kd.ssc.hstc.formplugin.web.contract.papersign.PaperSignKDString;
import kd.ssc.hstc.formplugin.web.htm.common.QuitCommonListPlugin;
import kd.ssc.hstc.formplugin.web.htm.common.QuitService;

public class QuitCertifyListPlugin
extends QuitCommonListPlugin {
    private static final Log LOG = LogFactory.getLog(QuitCertifyListPlugin.class);

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        boolean updateListFlag = SSCPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)false);
        if (updateListFlag) {
            return;
        }
        this.checkPermission(itemKey, evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (!itemKey.startsWith("act_")) {
            return;
        }
        ListSelectedRowCollection coll = ((ListView)this.getView()).getSelectedRows();
        if (coll == null || coll.isEmpty()) {
            this.getView().showTipNotification(PaperSignKDString.emptyData());
            return;
        }
        Set<Long> idSet = coll.stream().map(dd -> (Long)dd.getPrimaryKeyValue()).collect(Collectors.toSet());
        QuitService.getInstance().openCertify((IFormPlugin)this, this.getView(), idSet);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("openCertify".equals(callBackId)) {
            MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == messageBoxResult) {
                List<Long> activityListIdList = this.getPageByKey(this.getView(), "cache_selectedKeys");
                if (activityListIdList.isEmpty()) {
                    return;
                }
                Map resultMap = (Map)HRServiceHelper.invokeHRHtmService((String)"IShareService", (String)"getShowParameterForCertify", (Object[])new Object[]{"htm_certifymanage", "opencertify", activityListIdList.get(0), null});
                if (resultMap != null && !resultMap.isEmpty()) {
                    FormShowParameter formShowParameter = (FormShowParameter)resultMap.get("formshowparameter");
                    formShowParameter.setCustomParam("showway", (Object)"hstc");
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openCertify"));
                    this.getView().showForm(formShowParameter);
                }
            }
            this.getView().getPageCache().remove("cache_selectedKeys");
            TaskCommonService.getInstance().refreshTaskTreeAndList(this.getView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        LOG.info("htm.QuitCertifyListPlugin.closedCallBack.actionId={}", (Object)actionId);
        if ("openCertify".equals(actionId)) {
            LOG.info("htm.QuitCertifyListPlugin.closedCallBack.refresh");
            TaskCommonService.getInstance().refreshTaskTreeAndList(this.getView());
            return;
        }
    }

    public void checkPermission(String itemKey, BeforeItemClickEvent evt) {
        long userId = RequestContext.get().getCurrUserId();
        boolean superUser = SSCPermissionServiceHelper.isSuperUser();
        if ("act_opencertify".equals(itemKey)) {
            boolean hasPermByPermItemNum = SSCPermissionServiceHelper.hasPermByPermItemNum((long)userId, (String)"40A+670S4LST", (String)"htm_certifymange", (String)"HRQXX0039");
            LOG.info("htm.QuitCertifyListPlugin.beforeItemClick.hasPermByPermIntemNum={}", (Object)hasPermByPermItemNum);
            if (!superUser && !hasPermByPermItemNum) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u79bb\u804c\u7ba1\u7406\u201d\u7684\u201c\u5f00\u5177\u79bb\u804c\u8bc1\u660e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QuitCertifyListPlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    private List<Long> getPageByKey(IFormView view, String cacheKey) {
        String cacheStr = "";
        if (!HRObjectUtils.isEmpty((Object)view)) {
            cacheStr = view.getPageCache().get(cacheKey);
        }
        if (StringUtils.isEmpty((String)cacheStr)) {
            return new ArrayList<Long>();
        }
        List list = (List)SerializationUtils.fromJsonString((String)cacheStr, List.class);
        if (list == null || list.isEmpty()) {
            return new ArrayList<Long>();
        }
        return list;
    }
}

