/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.htm.common;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.ssc.hstc.formplugin.web.common.BizTaskCommonList;
import kd.ssc.hstc.formplugin.web.common.TaskCommonService;
import kd.ssc.hstc.formplugin.web.htm.common.QuitService;
import kd.ssc.hstc.util.ObjectUtils;

public class QuitCommonListPlugin
extends BizTaskCommonList {
    private static final Set<String> FIXED_SET = new HashSet<String>();

    @Override
    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        String billFormId = ((IListView)this.getView()).getBillFormId();
        String orderStr = "tasklevelid.priority desc,receivetime asc";
        event.setOrderBy(StringUtils.isEmpty((CharSequence)QuitService.getInstance().getOrderStr(billFormId)) ? orderStr : QuitService.getInstance().getOrderStr(billFormId));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        columns.forEach(item -> {
            if (FIXED_SET.contains(item.getListFieldKey())) {
                item.setFixed(true);
            }
        });
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        args.setCancel(true);
        IFormView formView = this.getView();
        String showPooltype = (String)formView.getFormShowParameter().getCustomParam("showpooltype");
        long taskId = ObjectUtils.getLongValOfObject((Object)((IListView)formView).getFocusRowPkId());
        boolean ifProcessing = true;
        this.hyperLink(fieldName, taskId, ifProcessing, showPooltype);
    }

    public void hyperLink(String fieldName, Long taskId, Boolean ifProcessing, String showPooltype) {
        if ("completed".equals(showPooltype)) {
            ifProcessing = false;
        }
        if ("htm_quitapplyemp_person_name".equals(fieldName) || "htm_quitapply_person_name".contains(fieldName)) {
            TaskCommonService.getInstance().getApproveDetailPageParameter(this.getView(), taskId, ifProcessing);
        }
        if ("htm_coophandle_person_name".equals(fieldName) || "htm_interviewhandle_person_name".equals(fieldName)) {
            TaskCommonService.getInstance().getDetailPageParameter(this.getView(), taskId, ifProcessing);
        }
    }

    static {
        FIXED_SET.add("htm_coophandle.person.headsculpture");
        FIXED_SET.add("htm_coophandle.person.name");
        FIXED_SET.add("htm_certifymange.person.headsculpture");
        FIXED_SET.add("htm_certifymange.person.name");
        FIXED_SET.add("htm_interviewhandle.person.headsculpture");
        FIXED_SET.add("htm_interviewhandle.person.name");
        FIXED_SET.add("htm_quitapply.person.headsculpture");
        FIXED_SET.add("htm_quitapply.person.name");
        FIXED_SET.add("htm_quitapplyemp.person.headsculpture");
        FIXED_SET.add("htm_quitapplyemp.person.name");
    }
}

