/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.htm.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageCallBackType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.servicehelper.HRServiceHelper;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.formplugin.web.htm.common.QuitOpKDString;

public class QuitService {
    private static final Log LOG = LogFactory.getLog(QuitService.class);

    public static QuitService getInstance() {
        return InstasnceHolder.INSTANCE;
    }

    public void openCertify(IFormPlugin formPlugin, IFormView view, Set<Long> idSet) {
        LOG.info("htm.common.QuitService.openCertify={}", idSet);
        List<Object> taskList = new ArrayList(idSet.size());
        if (view instanceof ListView) {
            String formId = ((ListView)view).getBillFormId();
            taskList = StringUtils.equals((CharSequence)formId, (CharSequence)"hstc_quitcertify_qhl") ? this.getTaskHistory(idSet) : this.getTask(idSet);
        }
        if (taskList.isEmpty()) {
            view.showTipNotification(QuitOpKDString.processForCertify());
            return;
        }
        ArrayList activityListIdList = Lists.newArrayListWithExpectedSize((int)taskList.size());
        HashMap activityListIdRefTaskId = Maps.newHashMapWithExpectedSize((int)taskList.size());
        for (DynamicObject dynamicObject : taskList) {
            String poolType = dynamicObject.getString("pooltype");
            String state = dynamicObject.getString("state");
            LOG.info("htm.common.QuitService.openCertify.poolType={},state={}", (Object)poolType, (Object)state);
            if ("1".equals(poolType) && TaskStateEnum.PAUSE.getValue().equals(state)) {
                view.showTipNotification(QuitOpKDString.processForCertify());
                return;
            }
            if ("2".equals(poolType) && TaskStateEnum.TERMINATED.getValue().equals(state)) {
                view.showTipNotification(QuitOpKDString.terminatedForCertify());
                return;
            }
            activityListIdList.add(dynamicObject.getLong("billlongid"));
            activityListIdRefTaskId.put(dynamicObject.getString("billlongid"), dynamicObject.getLong("id"));
        }
        this.setCachePage(view, "cache_activityreftask", activityListIdRefTaskId);
        this.callPreValidateCertify(view, "hlcm_paper_beginlist", activityListIdList, formPlugin);
    }

    private void callPreValidateCertify(IFormView view, String billFormId, List<Long> activityListIdList, IFormPlugin formPlugin) {
        LOG.debug("QuitCertifyListPlugin.callPreValidateCertify, billFormId={}, size={}", (Object)billFormId, (Object)activityListIdList.size());
        Map<String, Object> preResult = this.callHtm("preValidateCertify", activityListIdList);
        if (preResult != null && !preResult.isEmpty()) {
            LOG.debug("QuitCertifyListPlugin.callPreValidateCertify,size={}", (Object)preResult.size());
            String showType = (String)preResult.get("showtype");
            Object msg = preResult.get("msg");
            this.showTypeResult(showType, view, activityListIdList, formPlugin, msg);
        }
    }

    public void showTypeResult(String showType, IFormView view, List<Long> activityListIdList, IFormPlugin formPlugin, Object msg) {
        switch (showType) {
            case "12": {
                view.showErrorNotification((String)msg);
                break;
            }
            case "13": {
                this.setCachePage(view, "cache_selectedKeys", activityListIdList);
                view.showConfirm((String)msg, MessageBoxOptions.OKCancel, this.getConfirmCallBackListener(formPlugin, "openCertify"));
                break;
            }
            case "14": {
                Map resultMap = (Map)HRServiceHelper.invokeHRHtmService((String)"IShareService", (String)"getShowParameterForCertify", (Object[])new Object[]{"htm_certifymanage", "opencertify", activityListIdList.get(0), null});
                if (resultMap == null || resultMap.isEmpty()) break;
                FormShowParameter formShowParameter = (FormShowParameter)resultMap.get("formshowparameter");
                formShowParameter.setCustomParam("showway", (Object)"hstc");
                formShowParameter.setCloseCallBack(new CloseCallBack(formPlugin, "openCertify"));
                view.showForm(formShowParameter);
                break;
            }
            case "15": {
                view.showMessage((String)msg);
                break;
            }
            case "16": {
                view.showOperationResult((OperationResult)msg);
            }
        }
    }

    public String getOrderStr(String billFormId) {
        switch (billFormId) {
            case "hstc_quitinterview_ql": 
            case "hstc_quitinterview_qhl": {
                return "tasklevelid.priority asc,receivetime asc,htm_interviewhandle.quitapply.contractenddate asc,htm_interviewhandle.quitapply.lastworkdate asc";
            }
            case "hstc_quitcoop_ql": 
            case "hstc_quitcoop_qhl": {
                return "tasklevelid.priority asc,receivetime asc,htm_coophandle.quitapply.contractenddate asc,htm_coophandle.quitapply.lastworkdate asc";
            }
            case "hstc_quitcertify_ql": 
            case "hstc_quitcertify_qhl": {
                return "tasklevelid.priority asc,receivetime asc,htm_certifymange.quitapply.contractenddate asc,htm_certifymange.quitapply.lastworkdate asc";
            }
            case "hstc_quitapplyhelp_ql": 
            case "hstc_quitapplyhelp_qhl": {
                return "tasklevelid.priority asc,receivetime asc,htm_quitapply.contractenddate asc,htm_quitapply.lastworkdate asc";
            }
            case "hstc_quitapplyemp_ql": 
            case "hstc_quitapplyemp_qhl": {
                return "tasklevelid.priority asc,receivetime asc,htm_quitapplyemp.bcontractenddate asc,htm_quitapplyemp.lastworkdate asc";
            }
        }
        return "";
    }

    public List<DynamicObject> getTask(Set<Long> idSet) {
        QFilter id = new QFilter("id", "in", idSet);
        DynamicObject[] dynamicObjects = TaskService.getInstance().queryTask("id,pooltype,state,billlongid,billtype", new QFilter[]{id});
        return Arrays.stream(dynamicObjects).collect(Collectors.toList());
    }

    public List<DynamicObject> getTaskHistory(Set<Long> idSet) {
        QFilter id = new QFilter("id", "in", idSet);
        DynamicObject[] dynamicObjects = TaskService.getInstance().queryTaskHistory("id,pooltype,state,billlongid,billtype", new QFilter[]{id});
        return Arrays.stream(dynamicObjects).collect(Collectors.toList());
    }

    private void setCachePage(IFormView view, String cacheKey, Object activityListIdRefTaskId) {
        String billIdListStr = SerializationUtils.toJsonString((Object)activityListIdRefTaskId);
        view.getPageCache().put(cacheKey, billIdListStr);
    }

    private Map<String, Object> callHtm(String methodName, List<Long> certifyIds) {
        LOG.debug("callHlcm, methodName={}", (Object)methodName);
        return (Map)HRServiceHelper.invokeHRHtmService((String)"IShareService", (String)methodName, (Object[])new Object[]{certifyIds});
    }

    private ConfirmCallBackListener getConfirmCallBackListener(IFormPlugin formPlugin, String operateKey) {
        ConfirmCallBackListener confirmCallBackListener = formPlugin == null ? new ConfirmCallBackListener(operateKey, "kd.ssc.hstc.formplugin.web.HRTaskDetailEdit", MessageCallBackType.Plugin) : new ConfirmCallBackListener(operateKey, formPlugin);
        return confirmCallBackListener;
    }

    private static class InstasnceHolder {
        private static final QuitService INSTANCE = new QuitService();

        private InstasnceHolder() {
        }
    }
}

