/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.onbrd;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.sdk.ssc.hstc.common.TaskHandleService;
import kd.sdk.ssc.hstc.constant.OperationResultType;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.formplugin.web.common.TaskCommonService;
import kd.ssc.hstc.util.ObjectUtils;

public class OnbrdCollaboratingList
extends AbstractListPlugin {
    private static final String ACT_COMMIT = "act_commit";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (ACT_COMMIT.equals(itemKey)) {
            IFormView formView = this.getView();
            List taskIds = ((IListView)formView).getSelectedRows().stream().map(selectedRow -> ObjectUtils.getLongValOfObject((Object)selectedRow.getPrimaryKeyValue())).collect(Collectors.toList());
            boolean validateResult = TaskService.getInstance().opValidateTaskIsHandlingState(formView, taskIds);
            if (!validateResult) {
                TaskCommonService.getInstance().refreshTaskTreeAndList(formView);
                return;
            }
            DynamicObject[] taskInfos = TaskService.getInstance().queryTask(String.join((CharSequence)",", "billlongid", "state"), new QFilter[]{new QFilter("id", "in", taskIds)});
            Object[] billLongIds = Arrays.stream(taskInfos).map(dy -> dy.getLong("billlongid")).toArray();
            OperateOption option = OperateOption.create();
            option.setVariableValue("currbizappid", "hstc");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"donothing_commit", (String)"hom_activehandle", (Object[])billLongIds, (OperateOption)option);
            if (operationResult.isSuccess()) {
                HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
                paramsMap.put("isFromList", true);
                paramsMap.put("operationResultType", OperationResultType.PROCESSED.getValue());
                TaskHandleService.getInstance().doSomethingsAfterHandled(formView, taskIds, paramsMap);
                formView.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"HomTaskDetailEdit_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            } else {
                formView.showOperationResult(operationResult);
            }
            TaskCommonService.getInstance().refreshTaskTreeAndList(formView);
        }
    }
}

