/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.salary.bizdata;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.hstc.business.servicehelper.SWCServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BizdataBillList
extends AbstractListPlugin {
    public static final String KEY_BILL_TYPE = "hpdi_bizdatabill.billtype";
    public static final String KEY_COUNTDOWN = "countdown";
    public static final String STR_ONE = "1";
    public static final String ID = "id";
    private static final String PAGE_CACHE_KEY = "countDownMap";
    public static final String KEY_BIZITEM_GROUP = "hpdi_bizdatabill.bizitemgroup.number";
    public static final String KEY_CALPERIOD = "hpdi_bizdatabill.calperiod.number";
    public static final String NUMBER = "hpdi_bizdatabill.number";

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        super.beforePackageData(dataEvent);
        this.getView().getFormShowParameter().setCustomParam(PAGE_CACHE_KEY, null);
        List<Map<String, Object>> params = this.getParamsOfQueryPayNodeTimes(dataEvent);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)16);
        paramsMap.put("paramsList", params);
        Map idAndCountDownMap = (Map)SWCServiceHelper.invokeHPDIService((String)"IShareService", (String)"queryCountDownMap", (Object[])new Object[]{paramsMap});
        this.getView().getFormShowParameter().setCustomParam(PAGE_CACHE_KEY, (Object)idAndCountDownMap);
    }

    private List<Map<String, Object>> getParamsOfQueryPayNodeTimes(BeforePackageDataEvent dataEvent) {
        DynamicObjectCollection pageData = dataEvent.getPageData();
        int pageDataSize = pageData.size();
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(pageDataSize);
        ArrayList<String> bizItemGroupNumberList = new ArrayList<String>(pageDataSize);
        ArrayList<String> calPeriodNumberList = new ArrayList<String>(pageDataSize);
        for (int i = 0; i < pageDataSize; ++i) {
            String calPeriodNumber;
            DynamicObject rowData = (DynamicObject)pageData.get(i);
            String bizItemGroupNumber = rowData.getString(KEY_BIZITEM_GROUP);
            if (!StringUtils.isEmpty((CharSequence)bizItemGroupNumber)) {
                bizItemGroupNumberList.add(bizItemGroupNumber);
            }
            if (StringUtils.isEmpty((CharSequence)(calPeriodNumber = rowData.getString(KEY_CALPERIOD)))) continue;
            calPeriodNumberList.add(calPeriodNumber);
        }
        QFilter bizItemGroupQFilter = new QFilter("number", "in", bizItemGroupNumberList);
        DynamicObject[] bizItemGroups = BusinessDataServiceHelper.load((String)"hsbs_bizitemgroup", (String)"id,number,calperiodtype.id,createorg.id", (QFilter[])new QFilter[]{bizItemGroupQFilter});
        Map<Object, Object> bizItemGroupsMap = Maps.newHashMapWithExpectedSize((int)16);
        if (bizItemGroups != null && bizItemGroups.length > 0) {
            bizItemGroupsMap = Arrays.stream(bizItemGroups).collect(Collectors.toMap(bizItemGroup -> bizItemGroup.getString("number"), obj -> obj, (o1, o2) -> o2));
        }
        QFilter calPeriodNumberQFilter = new QFilter("number", "in", calPeriodNumberList);
        DynamicObject[] calPeriods = BusinessDataServiceHelper.load((String)"hsbs_calperiod", (String)"id,number", (QFilter[])new QFilter[]{calPeriodNumberQFilter});
        Map<Object, Object> calPeriodsMap = Maps.newHashMapWithExpectedSize((int)16);
        if (calPeriods != null && calPeriods.length > 0) {
            calPeriodsMap = Arrays.stream(calPeriods).collect(Collectors.toMap(bizItemGroup -> bizItemGroup.getString("number"), obj -> obj, (o1, o2) -> o2));
        }
        for (int i = 0; i < pageDataSize; ++i) {
            String bizItemGroupNumber;
            String billType;
            DynamicObject rowData = (DynamicObject)pageData.get(i);
            try {
                billType = rowData.getString(KEY_BILL_TYPE);
            }
            catch (Exception exception) {
                return null;
            }
            if (!StringUtils.equals((CharSequence)billType, (CharSequence)STR_ONE) || StringUtils.isEmpty((CharSequence)(bizItemGroupNumber = rowData.getString(KEY_BIZITEM_GROUP)))) continue;
            DynamicObject bizItemGroup2 = (DynamicObject)bizItemGroupsMap.get(bizItemGroupNumber);
            String calPeriodNumber = rowData.getString(KEY_CALPERIOD);
            if (StringUtils.isEmpty((CharSequence)calPeriodNumber)) continue;
            DynamicObject calPeriod = (DynamicObject)calPeriodsMap.get(calPeriodNumber);
            long calPeriodTypeId = bizItemGroup2.getLong("calperiodtype.id");
            if (calPeriodTypeId == 0L) continue;
            long bizItemGroupId = bizItemGroup2.getLong(ID);
            String periodNumber = calPeriod.getString("number");
            long id = rowData.getLong(ID);
            HashMap<String, Object> paramMap = new HashMap<String, Object>(7);
            paramMap.put("calperiodtype", calPeriodTypeId);
            paramMap.put("bizitemgroupid", bizItemGroupId);
            paramMap.put("periodnumber", periodNumber);
            paramMap.put(ID, id);
            paramMap.put("orgId", bizItemGroup2.getLong("createorg.id"));
            params.add(paramMap);
        }
        return params;
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        Object sourceObj = packageDataEvent.getSource();
        String fieldKey = "";
        if (sourceObj instanceof DynamicTextColumnDesc) {
            fieldKey = ((DynamicTextColumnDesc)packageDataEvent.getSource()).getKey();
        }
        DynamicObject rowData = packageDataEvent.getRowData();
        String billType = rowData.getString(KEY_BILL_TYPE);
        if (KEY_COUNTDOWN.equals(fieldKey) && StringUtils.equals((CharSequence)billType, (CharSequence)STR_ONE)) {
            long id = rowData.getLong(ID);
            Map idAndCountDownMap = (Map)this.getView().getFormShowParameter().getCustomParam(PAGE_CACHE_KEY);
            if (idAndCountDownMap == null || idAndCountDownMap.isEmpty()) {
                return;
            }
            String countDownByTime = (String)idAndCountDownMap.get(String.valueOf(id));
            if (StringUtils.isEmpty((CharSequence)countDownByTime)) {
                return;
            }
            packageDataEvent.setFormatValue((Object)countDownByTime);
        }
    }
}

