/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.salary.income;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.ssc.hstc.business.service.SSCPermissionServiceHelper;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.servicehelper.SWCServiceHelper;
import kd.ssc.hstc.common.constant.HCSSMappingConstant;
import kd.ssc.hstc.common.salary.IncomeConstants;
import kd.ssc.hstc.common.salary.SalaryConstants;
import org.apache.commons.lang3.StringUtils;

public class IncomeTaskHistoryList
extends AbstractListPlugin
implements Serializable {
    private static final Log logger = LogFactory.getLog(IncomeTaskHistoryList.class);

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        args.getListColumn("hcss_incomeproofhandle.person.name").setFixed(true);
        args.getListColumn("hcss_incomeproofhandle.person.number").setFixed(true);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (HCSSMappingConstant.HCSS_PERMISSIN_MAP.containsKey(itemKey)) {
            if (!SSCPermissionServiceHelper.checkRole((Map)HCSSMappingConstant.HCSS_PERMISSIN_MAP, (String)itemKey, (IFormView)this.getView(), (String)"40A+670S4LST", (String)"hcss_incomeproofhandle")) {
                evt.setCancel(true);
                return;
            }
            ListSelectedRowCollection listSelectedData = this.getSelectedRows();
            if (listSelectedData != null && !listSelectedData.isEmpty()) {
                Set idSet = listSelectedData.stream().map(dd -> (Long)dd.getPrimaryKeyValue()).collect(Collectors.toSet());
                QFilter idFilter = new QFilter("id", "in", idSet);
                DynamicObject[] taskInfos = TaskService.getInstance().queryTaskHistory("id,billlongid", new QFilter[]{idFilter});
                Object[] billLongIds = Arrays.stream(taskInfos).map(dy -> dy.getLong("billlongid")).toArray();
                DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"hcss_incomeproofhandle", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billLongIds)});
                if (dynamicObject == null || billLongIds.length != dynamicObject.size()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"IncomeTaskDetailEdit_8", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection listSelectedData = this.getSelectedRows();
        if (IncomeConstants.ACTIONID_OPS.contains(itemKey)) {
            HashMap<String, Object> params;
            if (listSelectedData == null || listSelectedData.isEmpty()) {
                SalaryConstants.showMessage((IFormView)this.getView(), (String)"select");
                return;
            }
            Set idSet = listSelectedData.stream().map(dd -> (Long)dd.getPrimaryKeyValue()).collect(Collectors.toSet());
            QFilter idFilter = new QFilter("id", "in", idSet);
            DynamicObject[] taskInfos = TaskService.getInstance().queryTaskHistory("id,billlongid", new QFilter[]{idFilter});
            Object[] billLongIds = Arrays.stream(taskInfos).map(dy -> dy.getLong("billlongid")).toArray();
            OperateOption option = OperateOption.create();
            option.setVariableValue("currbizappid", "hstc");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)itemKey, (String)"hcss_incomeproofhandle", (Object[])billLongIds, (OperateOption)option);
            if (operationResult != null) {
                if (operationResult.isSuccess()) {
                    IncomeConstants.showMessage((IFormView)this.getView(), (String)itemKey);
                } else {
                    this.getView().showOperationResult(operationResult);
                }
            }
            if (itemKey.equals("issued")) {
                List paras;
                params = new HashMap<String, Object>(4);
                params.put("pageId", this.getView().getPageId());
                params.put("opNumber", itemKey);
                params.put("operationResult", operationResult);
                Map listValidatorMap = (Map)SWCServiceHelper.invokeHCSSService((String)"IShareService", (String)"previewIncomeProof", (Object[])new Object[]{params});
                if (listValidatorMap != null && !CollectionUtils.isEmpty((Collection)(paras = (List)listValidatorMap.get("paras")))) {
                    for (FormShowParameter para : paras) {
                        this.getView().showForm(para);
                    }
                }
            }
            if ("downcustomatt".equals(itemKey) && operationResult != null && !operationResult.getSuccessPkIds().isEmpty()) {
                params = new HashMap(4);
                params.put("successIds", operationResult.getSuccessPkIds());
                Map downUrlsMap = (Map)SWCServiceHelper.invokeHCSSService((String)"IShareService", (String)"downUrls", (Object[])new Object[]{params});
                List urlList = (List)downUrlsMap.get("data");
                urlList.forEach(url -> this.getView().download(url));
                IncomeConstants.showMessage((IFormView)this.getView(), (String)itemKey);
            }
        } else if ("viewissuelog".equals(itemKey)) {
            Map<String, Object> params = this.getBillLongIds(listSelectedData, itemKey);
            Map listValidatorMap = (Map)SWCServiceHelper.invokeHCSSService((String)"IShareService", (String)"listValidator", (Object[])new Object[]{params});
            if (listValidatorMap == null) {
                logger.info("listValidatorMap is null");
                return;
            }
            if (!((Boolean)listValidatorMap.get("success")).booleanValue()) {
                this.getView().showErrorNotification(String.valueOf(listValidatorMap.get("msg")));
                return;
            }
            QFilter filterList = (QFilter)listValidatorMap.get("data");
            params.put("filterList", filterList);
            params.put("formPlugin", this);
            Map viewIssueLogMap = (Map)SWCServiceHelper.invokeHCSSService((String)"IShareService", (String)"viewissuelog", (Object[])new Object[]{params});
            if (viewIssueLogMap == null) {
                logger.info("viewIssueLogMap is null");
                return;
            }
            if (!((Boolean)listValidatorMap.get("success")).booleanValue()) {
                this.getView().showErrorNotification(String.valueOf(listValidatorMap.get("msg")));
                return;
            }
            ListShowParameter parameter = (ListShowParameter)viewIssueLogMap.get("listShowParameter");
            this.getView().showForm((FormShowParameter)parameter);
        } else if ("resign".equals(itemKey)) {
            if (listSelectedData == null || listSelectedData.isEmpty()) {
                SalaryConstants.showMessage((IFormView)this.getView(), (String)"select");
                return;
            }
            Map<String, Object> params = this.getBillLongIds(listSelectedData, itemKey);
            Map listValidatorMap = (Map)SWCServiceHelper.invokeHCSSService((String)"IShareService", (String)"listValidator", (Object[])new Object[]{params});
            if (listValidatorMap == null) {
                logger.info("listValidatorMap is null");
                return;
            }
            Object[] selectIds = ((ListSelectedRowCollection)params.get("listSelectedData")).stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            this.getPageCache().put("listSelectedData_resign", SerializationUtils.toJsonString((Object)selectIds));
            FormShowParameter formShowParameter = (FormShowParameter)listValidatorMap.get("data");
            if (!((Boolean)listValidatorMap.get("success")).booleanValue() && formShowParameter == null) {
                this.getView().showErrorNotification(String.valueOf(listValidatorMap.get("msg")));
                return;
            }
            CloseCallBack closeCallBack = formShowParameter.getCloseCallBack();
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBack.getActionId()));
            formShowParameter.setCustomParam("showway", (Object)"hstc");
            this.getView().showForm(formShowParameter);
        }
    }

    private Map<String, Object> getBillLongIds(ListSelectedRowCollection listSelectedData, String itemKey) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        Set ids = listSelectedData.stream().map(dd -> (Long)dd.getPrimaryKeyValue()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObjects = TaskService.getInstance().queryTaskHistory("billlongid", new QFilter[]{qFilter});
        params.put("opNumber", itemKey);
        params.put("formPlugin", this);
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        params.put("listSelectedData", listSelectedRows);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            logger.info("dynamicObjects is null");
            return params;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            listSelectedRows.add((Object)new ListSelectedRow((Object)dynamicObject.getLong("billlongid")));
        }
        return params;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if ("hcss_dealresign".equals(actionId)) {
            if (returnData != null && ((Boolean)((Map)returnData).get("isOk")).booleanValue()) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("lawentity", JSON.toJSONString(((Map)returnData).get("lawentity")));
                option.setVariableValue("ignoreFlag", "1");
                option.setVariableValue("currbizappid", "hstc");
                String listSelectedDataResignStr = this.getPageCache().get("listSelectedData_resign");
                Object[] selectedRows = new Object[]{};
                if (!StringUtils.isEmpty((CharSequence)listSelectedDataResignStr)) {
                    selectedRows = SerializationUtils.fromJsonStringToList((String)listSelectedDataResignStr, Object.class).toArray();
                }
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"resign", (String)"hcss_incomeproofhandle", (Object[])selectedRows, (OperateOption)option);
                logger.info("operationResult info:{}", (Object)operationResult.getMessage());
                if (operationResult != null) {
                    if (operationResult.isSuccess()) {
                        IncomeConstants.showMessage((IFormView)this.getView(), (String)"resign");
                    } else {
                        this.getView().showOperationResult(operationResult);
                    }
                }
            } else {
                logger.info("operationResult returnData is null returnData:{}", returnData);
            }
        }
    }
}

