/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.salary.sinsurver;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.common.salary.SalaryConstants;

public class SinsurverBillHistoryList
extends AbstractListPlugin {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        args.getListColumn("hpdi_sinsurverbill.personname").setFixed(true);
        args.getListColumn("hpdi_sinsurverbill.empno").setFixed(true);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection coll = this.getSelectedRows();
        if (itemKey.equals("donothing_createtask")) {
            if (coll == null || coll.isEmpty()) {
                SalaryConstants.showMessage((IFormView)this.getView(), (String)"select");
                return;
            }
            String entityNumber = "hpdi_summaryvbill";
            Set taskIds = coll.stream().map(dd -> (Long)dd.getPrimaryKeyValue()).collect(Collectors.toSet());
            QFilter idFilter = new QFilter("id", "in", taskIds);
            DynamicObject[] taskInfos = TaskService.getInstance().queryTaskHistory("id,billlongid", new QFilter[]{idFilter});
            Object[] billlongids = Arrays.stream(taskInfos).map(dy -> dy.getLong("billlongid")).toArray();
            OperateOption option = OperateOption.create();
            option.setVariableValue("currbizappid", "hstc");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)itemKey, (String)entityNumber, (Object[])billlongids, (OperateOption)option);
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u534f\u4f5c\u4efb\u52a1\u6210\u529f\u3002", (String)"SinsurverBillHistoryList_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(operationResult);
            }
        }
    }
}

