/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.schedule;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.ssc.hstc.business.servicehelper.SSCServiceHelper;

public class PocTaskSyncDataToBizSchedule
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(PocTaskSyncDataToBizSchedule.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("PocTaskSyncDataToBizSchedule.execute start. map:{}", map);
        long start = System.currentTimeMillis();
        try {
            String sendMq = (String)map.get("sendMq");
            boolean isBatchSync = Boolean.parseBoolean((String)map.get("isBatchSync"));
            LOGGER.info("PocTaskSyncDataToBizSchedule execute, sendMq:{}, isBatchSync:{}", (Object)sendMq, (Object)isBatchSync);
            if (isBatchSync) {
                this.doBatchExecute(sendMq, map);
            } else {
                this.doFullExecute(sendMq);
            }
            LOGGER.info("PocTaskSyncDataToBizSchedule.execute finish.");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            LOGGER.info("PocTaskSyncDataToBizSchedule.execute end use time:{} ms.", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void doFullExecute(String sendMq) {
        this.doFullExecute("task_task", sendMq);
        this.doFullExecute("task_taskhistory", sendMq);
    }

    private void doFullExecute(String taskEntityNumber, String sendMq) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("taskEntityNumber", taskEntityNumber);
        paramMap.put("isFullSync", true);
        PocTaskSyncDataToBizSchedule.paramSendToService(sendMq, paramMap);
        PocTaskSyncDataToBizSchedule.doInvokeBizService(paramMap);
    }

    private static void paramSendToService(String sendMq, Map<String, Object> paramMap) {
        if (StringUtils.equals((CharSequence)"0", (CharSequence)sendMq)) {
            paramMap.put("sendToService", "1");
        }
    }

    private void doBatchExecute(String sendMq, Map<String, Object> map) {
        String taskEntityNumber = (String)map.get("taskEntityNumber");
        String dataChangeType = (String)map.get("dataChangeType");
        String idListStr = (String)map.get("idList");
        String[] idArr = idListStr.split(",");
        LOGGER.info("PocTaskSyncDataToBizSchedule doBatchExecute, taskEntityNumber:{}, dataChangeType:{}, idList:{}", new Object[]{taskEntityNumber, dataChangeType, idListStr});
        if (StringUtils.isEmpty((CharSequence)taskEntityNumber) || StringUtils.isEmpty((CharSequence)dataChangeType) || StringUtils.isEmpty((CharSequence)idListStr)) {
            return;
        }
        List idList = Arrays.stream(idArr).map(Long::parseLong).collect(Collectors.toList());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("taskEntityNumber", taskEntityNumber);
        paramMap.put("isFullSync", false);
        paramMap.put("dataChangeType", dataChangeType);
        paramMap.put("idList", idList);
        PocTaskSyncDataToBizSchedule.paramSendToService(sendMq, paramMap);
        PocTaskSyncDataToBizSchedule.doInvokeBizService(paramMap);
    }

    private static void doInvokeBizService(Map<String, Object> paramMap) {
        try {
            Map result = (Map)SSCServiceHelper.invokeHSTCService((String)"ISSCTaskSyncDataService", (String)"syncData", (Object[])new Object[]{paramMap});
            boolean success = Boolean.parseBoolean(String.valueOf(result.get("success")));
            String errorMsg = result.getOrDefault("msg", "");
            if (!success) {
                throw new KDBizException("PocTaskSyncDataToBizSchedule Invoke RPC service error! Message\uff1a" + errorMsg);
            }
            LOGGER.info("PocTaskSyncDataToBizSchedule Invoke RPC service success!");
        }
        catch (Exception e) {
            LOGGER.error("PocTaskSyncDataToBizSchedule Invoke RPC service error!", (Throwable)e);
            throw e;
        }
    }
}

