/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.schedule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.taskdatasync.BizTaskEntityService;
import kd.ssc.hstc.business.taskdatasync.util.BizTaskEntityUtil;

public class RefreshTaskResttimeSchedule
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(RefreshTaskResttimeSchedule.class);
    private static final int BATCH_COUNT = 1000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("RefreshTaskResttimeSchedule.execute start. map:{}", map);
        long start = System.currentTimeMillis();
        try {
            String updateProperty = (String)map.getOrDefault("updateProperty", "resttime");
            this.doExecute(updateProperty);
            LOGGER.info("RefreshTaskResttimeSchedule.execute finish.");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            LOGGER.info("RefreshTaskResttimeSchedule.execute end use time:{} ms.", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void doExecute(String updateProperty) {
        DynamicObjectCollection taskDbTableDyColl = BizTaskEntityService.getInstance().queryAllDbTable();
        if (taskDbTableDyColl.isEmpty()) {
            return;
        }
        for (DynamicObject taskDbTableDy : taskDbTableDyColl) {
            String taskentity = taskDbTableDy.getString("taskentity");
            if (!BizTaskEntityUtil.isWhiteMainQuery((String)taskentity)) continue;
            this.doUpdateTask(taskentity, updateProperty);
        }
    }

    private void doUpdateTask(String taskentity, String updateProperty) {
        long lastId = 0L;
        while (true) {
            DynamicObject[] taskentityDyArr;
            if ((taskentityDyArr = BusinessDataServiceHelper.load((String)taskentity, (String)("id," + updateProperty), (QFilter[])new QFilter[]{new QFilter("id", ">", (Object)lastId)}, (String)"id", (int)1000)).length == 0) {
                LOGGER.info("RefreshTaskResttimeSchedule.doUpdateTask end loop. taskentity:{}", (Object)taskentity);
                return;
            }
            this.doUpdateTask(taskentityDyArr, updateProperty);
            if (taskentityDyArr.length < 1000) {
                LOGGER.info("RefreshTaskResttimeSchedule.doUpdateTask last loop. taskentity:{}", (Object)taskentity);
                return;
            }
            lastId = taskentityDyArr[taskentityDyArr.length - 1].getLong("id");
        }
    }

    private void doUpdateTask(DynamicObject[] taskentityDyArr, String updateProperty) {
        List idList = Arrays.stream(taskentityDyArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection taskDyColl = TaskService.getInstance().queryTaskData(new QFilter[]{new QFilter("id", "in", idList)}, "id," + updateProperty, true);
        Map<Long, DynamicObject> taskDyMap = taskDyColl.stream().collect(Collectors.toMap(taskDy -> taskDy.getLong("id"), taskDy -> taskDy));
        String[] updatePropertyArr = updateProperty.split(",");
        for (DynamicObject taskentityDy : taskentityDyArr) {
            long taskId = taskentityDy.getLong("id");
            DynamicObject taskDy2 = taskDyMap.get(taskId);
            if (taskDy2 == null) continue;
            for (String property : updatePropertyArr) {
                taskentityDy.set(property, taskDy2.get(property));
            }
        }
        SaveServiceHelper.update((DynamicObject[])taskentityDyArr);
    }
}

