/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.tasksync;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncBusinessService;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncBusinessServiceFactory;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordSyncStatusEnum;

public class TaskDatasyncRecordListPlugin
extends AbstractListPlugin {
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("retry".equals(itemKey)) {
            this.retry();
        }
    }

    private void retry() {
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            return;
        }
        if (primaryKeyValues.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TaskDatasyncRecordListPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return;
        }
        Long focusRowPkId = (Long)this.getFocusRowPkId();
        if (this.validateRetry(focusRowPkId)) {
            return;
        }
        TaskDataSyncBusinessService service = TaskDataSyncBusinessServiceFactory.createServiceByRecordId((Long)focusRowPkId);
        DynamicObject updateRecordDy = service.syncData();
        String syncstatus = updateRecordDy.getString("syncstatus");
        if (TaskRecordSyncStatusEnum.isFinish((String)syncstatus)) {
            updateRecordDy.set("retrycount", (Object)(updateRecordDy.getInt("retrycount") + 1));
            SaveServiceHelper.update((DynamicObject)updateRecordDy);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"TaskDatasyncRecordListPlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"TaskDatasyncRecordListPlugin_2", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }

    private boolean validateRetry(Long focusRowPkId) {
        DynamicObject taskdatasyncRecordDy = QueryServiceHelper.queryOne((String)"hstc_taskdatasyncrecord", (String)"id,batchnumber,syncstatus,retrycount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)focusRowPkId)});
        if (taskdatasyncRecordDy == null) {
            this.getView().showErrorNotification("data not found.");
            return true;
        }
        String syncstatus = taskdatasyncRecordDy.getString("syncstatus");
        if (TaskRecordSyncStatusEnum.isFinish((String)syncstatus)) {
            this.getView().showTipNotification("syncstatus is finish.");
            return true;
        }
        return false;
    }
}

