/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.hstc.business.service.HstcLicenseService;
import kd.ssc.hstc.business.task.AppHomeService;
import kd.ssc.hstc.business.task.PermService;
import kd.ssc.hstc.business.task.ShareAuthService;
import kd.ssc.hstc.util.ObjectUtils;

public class HstcAppHomePlugin
extends GridContainerPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(HstcAppHomePlugin.class);
    private static final String SSCID = "sscid";
    private static final String USERGROUP = "usergroup";
    private static final String REFRESHBTN = "refreshbtn";
    private static final String SOURCE = "source";
    private static final String SOURCE_BIZADMIN = "bizadmin";
    private static final String SOURCE_BIZ = "biz";
    private static final String IFSHOW_LEADERHOMEPAGE = "ifShowLeaderHomePage";
    private static final String PGCACHE_CURRENTSCHEME = "pgCache_currentScheme";

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        String from = (String)formShowParameter.getCustomParam(SOURCE);
        if (ObjectUtils.isEmpty((Object)from) || "hstc_apphome".equals(formShowParameter.getFormId())) {
            return;
        }
        boolean ifHasNoPagePerm = false;
        if (SOURCE_BIZADMIN.equals(from)) {
            ifHasNoPagePerm = !AppHomeService.getInstance().ifShowLeaderHomePage(RequestContext.getOrCreate().getCurrUserId());
        } else {
            List orgIdsBiz = PermService.getAllPermSSC((Long)RequestContext.getOrCreate().getCurrUserId(), (String)"hstc", (String)"hstc_apphomebiz");
            if (ObjectUtils.isEmpty((Object)orgIdsBiz)) {
                ifHasNoPagePerm = true;
            }
        }
        if (ifHasNoPagePerm) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"HstcAppHomePlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        long userId = RequestContext.get().getCurrUserId();
        if (userId < 1L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u9646\u7528\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"HstcAppHomePlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return;
        }
        Set sscIds = ShareAuthService.getInstance().getHRShare("task_task", "hstc");
        if (this.getModel().getDataEntity().getLong("sscid.id") == 0L && ObjectUtils.isNotEmpty((Object)sscIds)) {
            Long sscid = sscIds.stream().findFirst().orElse(0L);
            this.getModel().setValue(SSCID, (Object)sscid);
            this.getPageCache().put(SSCID, sscid.toString());
        }
        long schemeId = 0L;
        String from = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE);
        if (ObjectUtils.isEmpty((Object)from)) {
            List orgIdsBiz = PermService.getAllPermSSC((Long)RequestContext.getOrCreate().getCurrUserId(), (String)"hstc", (String)"hstc_apphomebiz");
            boolean ifShowLeaderHomePage = AppHomeService.getInstance().ifShowLeaderHomePage(userId);
            if (ObjectUtils.isEmpty((Object)orgIdsBiz) || !HstcLicenseService.getInstance().checkLicenseByBizObj("hstc_apphomebiz")) {
                if (ifShowLeaderHomePage && HstcLicenseService.getInstance().checkLicenseByBizObj("hstc_apphomeadmin")) {
                    schemeId = 1950101676992029696L;
                    Long orgId = this.getModel().getDataEntity().getLong("sscid.id");
                    this.setGroup(orgId, userId);
                    this.getPageCache().put(IFSHOW_LEADERHOMEPAGE, String.valueOf(ifShowLeaderHomePage));
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{USERGROUP});
                }
            } else {
                schemeId = 1950098725946844160L;
                this.getView().setVisible(Boolean.FALSE, new String[]{USERGROUP});
                if (ifShowLeaderHomePage) {
                    this.openCustomHomeTab("hstc_apphomeadmin", SOURCE_BIZADMIN);
                } else {
                    this.openCustomHomeTab("hstc_apphomebiz", SOURCE_BIZ);
                }
            }
        } else if (SOURCE_BIZADMIN.equals(from)) {
            schemeId = 1950101676992029696L;
            Long orgId = this.getModel().getDataEntity().getLong("sscid.id");
            this.setGroup(orgId, userId);
            this.getPageCache().put(IFSHOW_LEADERHOMEPAGE, Boolean.TRUE.toString());
        } else {
            schemeId = 1950098725946844160L;
            this.getView().setVisible(Boolean.FALSE, new String[]{USERGROUP});
            this.getPageCache().put(IFSHOW_LEADERHOMEPAGE, Boolean.FALSE.toString());
        }
        if (schemeId == 0L) {
            long curSchemeId = ObjectUtils.getLongValOfObject((Object)this.getPageCache().get(PGCACHE_CURRENTSCHEME));
            if (curSchemeId == 1950098725946844160L || curSchemeId == 1950101676992029696L) {
                this.resetGridContainerLayout(null);
                this.showItemOnlyModify();
                this.getPageCache().remove(PGCACHE_CURRENTSCHEME);
            }
            return;
        }
        try {
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"portal_scheme", (String)"id,layout,schemetype,ismultiorg");
            LOGGER.info("TsivpHomePagePlugin.afterBindData schemeObj : {}", (Object)schemeObj);
            if (schemeObj != null) {
                this.refreshGridContainer(schemeObj);
            }
        }
        catch (Throwable throwable) {
            LOGGER.error(throwable);
        }
    }

    private void openCustomHomeTab(String formId, String source) {
        String checkedNodeID = null;
        if ("hstc_apphomebiz".equals(formId)) {
            checkedNodeID = "1950888282946684928";
        } else if ("hstc_apphomeadmin".equals(formId)) {
            checkedNodeID = "1950889396987381760";
        }
        if (checkedNodeID == null) {
            LOGGER.info("checkedNodeID==null");
            return;
        }
        try {
            AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)"hstc", (String)checkedNodeID);
            if (menu == null) {
                LOGGER.info("menu==null");
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("view", this.getView());
            map.put("formnumber", formId);
            map.put("parametertype", menu.getParamType());
            map.put("parameter", JSONArray.parseObject((String)menu.getParams()));
            map.put("menuname", menu.getName());
            map.put("openType", menu.getOpenType());
            map.put("permItem", menu.getPermission());
            OpenPageUtils.openApp((String)"hstc", (String)checkedNodeID, map, (IFormView)this.getView());
        }
        catch (Throwable throwable) {
            LOGGER.error(throwable);
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit sscidEdit = (BasedataEdit)this.getView().getControl(SSCID);
        sscidEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{REFRESHBTN});
    }

    public void click(EventObject evt) {
        Button btn;
        super.click(evt);
        if (evt.getSource() instanceof Button && REFRESHBTN.equals((btn = (Button)evt.getSource()).getKey())) {
            if (this.getPageCache().get(PGCACHE_CURRENTSCHEME) == null) {
                LOGGER.info("Cannot Fresh GridContainer");
                return;
            }
            super.clickFreshGridContainer();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("refresh".equals(evt.getItemKey()) && this.getPageCache().get(PGCACHE_CURRENTSCHEME) == null) {
            LOGGER.info("Cannot Fresh GridContainer");
            return;
        }
        super.itemClick(evt);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (SSCID.equals(name)) {
            QFilter qFilter = new QFilter("id", "in", (Object)ShareAuthService.getInstance().getHRShare("task_task", "hstc"));
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (SSCID.equals(name)) {
            Long orgId = this.getModel().getDataEntity().getLong("sscid.id");
            this.getPageCache().put(SSCID, orgId.toString());
            this.setGroup(orgId, RequestContext.getOrCreate().getCurrUserId());
            super.clickFreshGridContainer();
        } else if (USERGROUP.equals(name)) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().getString(USERGROUP))) {
                this.getModel().beginInit();
                this.getModel().setValue(USERGROUP, (Object)"-1");
                this.getModel().endInit();
            }
            this.getPageCache().put("usergroupid", this.getModel().getDataEntity().getString(USERGROUP));
            super.clickFreshGridContainer();
        }
    }

    boolean setGroup(Long orgId, Long userId) {
        QFilter qFilter = new QFilter("createorg", "=", (Object)orgId);
        boolean isSysAdminAndAllRight = PermService.getInstance().isAdminRole(String.valueOf(orgId), userId, new String[]{"HXLFBW8ZGNH", "HXLT47Z1L8S"});
        this.getPageCache().put("isSysAdminAndAllRight", String.valueOf(isSysAdminAndAllRight));
        if (!isSysAdminAndAllRight) {
            qFilter.and("entryentity.userfield", "=", (Object)userId);
            if (AppHomeService.isOpenTeamleader((String)String.valueOf(orgId))) {
                qFilter.and("entryentity.teamleader", "=", (Object)Boolean.TRUE);
            }
        }
        DynamicObject[] groups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        IFormView view = this.getView();
        if (!(isSysAdminAndAllRight || groups != null && groups.length != 0)) {
            view.close();
            String caption = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ba1\u7406\u5458\u9996\u9875", (String)"HstcAppHomePlugin_2", (String)"ssc-hstc-formplugin", (Object[])new Object[0]);
            HstcAppHomePlugin.showForm(view, caption);
            return false;
        }
        Set groupIdSet = Arrays.stream(groups).map(dd -> dd.getLong("id")).collect(Collectors.toSet());
        String groupIdSetStr = SerializationUtils.toJsonString(groupIdSet);
        this.getPageCache().put("usergroupidset", groupIdSetStr);
        List<ComboItem> comboItems = this.getComboItems(groups);
        ComboEdit combo = (ComboEdit)this.getControl(USERGROUP);
        if (combo != null) {
            if (comboItems.size() > 0) {
                combo.setComboItems(comboItems);
                String value = comboItems.get(0).getValue();
                this.getModel().setValue(USERGROUP, (Object)value);
                this.getView().updateView(USERGROUP);
                this.getPageCache().put("usergroupid", value);
            } else {
                this.getModel().setValue(USERGROUP, (Object)"");
                combo.setComboItems(null);
            }
        }
        return true;
    }

    private List<ComboItem> getComboItems(DynamicObject[] items) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        ComboItem unLimitedItem = new ComboItem();
        unLimitedItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"HstcAppHomePlugin_3", (String)"ssc-hstc-formplugin", (Object[])new Object[0])));
        unLimitedItem.setValue("-1");
        list.add(unLimitedItem);
        for (DynamicObject item : items) {
            ComboItem citem = new ComboItem();
            citem.setCaption(new LocaleString(item.getLocaleString("name") + ""));
            citem.setValue(item.get("id") + "");
            list.add(citem);
        }
        return list;
    }

    public static void showForm(IFormView view, String caption) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", "task_errorpage");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submitintab_");
        if (caption != null) {
            showParameter.setCaption(caption);
        }
        showParameter.setHasRight(true);
        view.showForm(showParameter);
    }
}

