/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.business.task.TaskIndexDataService;
import kd.ssc.hstc.common.entity.MonthInfo;
import kd.ssc.hstc.common.entity.WeekInfo;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.util.DateUtils;

public class TaskNumAndTimeEffPlugin
extends WbCardCommonPlugin
implements TabSelectListener {
    private static final Log LOGGER = LogFactory.getLog(TaskNumAndTimeEffPlugin.class);
    private static final String HANDLECHART = "handleChart";
    private static final String TAB = "tab";
    private static final String WEEK = "week";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        Chart customchart = (Chart)this.getControl(HANDLECHART);
        Date firstDayOfCurrentMonth = DateUtils.getFirstDayOfCurrentMonth();
        Date lastDayOfCurrentMonth = DateUtils.getLastDayOfCurrentMonth();
        this.getModel().setValue(START_DATE, (Object)firstDayOfCurrentMonth);
        this.getModel().setValue(END_DATE, (Object)lastDayOfCurrentMonth);
        this.setEchartData(customchart, firstDayOfCurrentMonth, lastDayOfCurrentMonth, this.getUnitType());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getControl(TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        Date startDate = this.getModel().getDataEntity().getDate(START_DATE);
        Date endDate = this.getModel().getDataEntity().getDate(END_DATE);
        Chart customchart = (Chart)this.getControl(HANDLECHART);
        this.setEchartData(customchart, startDate, endDate, this.getUnitType());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if (START_DATE.equals(propertyName) || END_DATE.equals(propertyName)) {
            Date startDate = this.getModel().getDataEntity().getDate(START_DATE);
            Date endDate = this.getModel().getDataEntity().getDate(END_DATE);
            Chart customchart = (Chart)this.getControl(HANDLECHART);
            this.setEchartData(customchart, startDate, endDate, this.getUnitType());
        }
    }

    private String getUnitType() {
        Tab tab = (Tab)this.getControl(TAB);
        return tab.getCurrentTab();
    }

    private void setEchartData(Chart customchart, Date startDate, Date endDate, String unitType) {
        List xDimensions;
        BigDecimal[] taskefficiencyAvg;
        Integer[] taskamountAvg;
        if (startDate == null || endDate == null) {
            customchart.clearData();
            customchart.bindData(null);
            LOGGER.info("startDate:{}, endDate:{}", (Object)startDate, (Object)endDate);
            return;
        }
        customchart.clearData();
        customchart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
        customchart.setShowTooltip(true);
        Axis xAxis = customchart.createXAxis(null, AxisType.category);
        if (WEEK.equals(unitType)) {
            List weekInfos = DateUtils.getWeekInfos((Date)startDate, (Date)endDate);
            Tuple<Integer[], BigDecimal[]> tuple = this.getEchartDataWithWeek(weekInfos, startDate, endDate);
            taskamountAvg = (Integer[])tuple.item1;
            taskefficiencyAvg = (BigDecimal[])tuple.item2;
            xDimensions = weekInfos.stream().map(weekInfo -> ResManager.loadKDString((String)"%1$s\u5e74\u7b2c%2$s\u5468", (String)"TaskNumAndTimeEffPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[]{weekInfo.getYear(), weekInfo.getWeekSeqOfYear()})).collect(Collectors.toList());
        } else {
            List monthInfos = DateUtils.getMonthInfos((Date)startDate, (Date)endDate);
            Tuple<Integer[], BigDecimal[]> tuple = this.getEchartDataWithMonth(monthInfos, startDate, endDate);
            taskamountAvg = (Integer[])tuple.item1;
            taskefficiencyAvg = (BigDecimal[])tuple.item2;
            xDimensions = monthInfos.stream().map(monthInfo -> ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708", (String)"TaskNumAndTimeEffPlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[]{monthInfo.getYear(), monthInfo.getMonthSeqOfYear()})).collect(Collectors.toList());
        }
        xAxis.setCategorys(xDimensions);
        this.setAmountYAxis(customchart, taskamountAvg);
        this.setEfficiencyYAxis(customchart, taskefficiencyAvg);
        customchart.bindData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<Integer[], BigDecimal[]> getEchartDataWithWeek(List<WeekInfo> weekInfos, Date startDate, Date endDate) {
        int index;
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Long sscId = this.getSscId();
        int size = weekInfos.size();
        Object[] taskamountAvg = new Integer[size];
        Arrays.fill(taskamountAvg, (Object)0);
        Object[] taskefficiencyAvg = new BigDecimal[size];
        Arrays.fill(taskefficiencyAvg, BigDecimal.ZERO);
        Object[] costwaittimeArr = new BigDecimal[size];
        Arrays.fill(costwaittimeArr, BigDecimal.ZERO);
        QFilter qFilter = TaskIndexDataService.getTaskefficiencyQFilter((Date)startDate, (Date)endDate, (Long)sscId);
        this.setQFilterRealtime(qFilter);
        DataSet taskefficiencyDs = this.ifShowLeaderHomePage() ? TaskIndexDataService.getInstance().getTaskefficiencyDSet(qFilter, sscId, Long.valueOf(this.getUsergroupId()), this.isSysAdminAndAllRight()) : TaskIndexDataService.getInstance().getTaskefficiencyDSet(qFilter, userId);
        if (taskefficiencyDs != null) {
            taskefficiencyDs = taskefficiencyDs.select(new String[]{"(case when coefficient = 0 then 1 else coefficient end) as coefficient", "completetime", "(case when costwaittime is null or costwaittime = 0 then 0.02 else costwaittime end) as costwaittime"}).groupBy(new String[]{"completetime"}).count("taskcount").sum("coefficient", "taskamount").sum("costwaittime").finish().orderBy(new String[]{"completetime asc"});
            try {
                index = 0;
                WeekInfo weekInfo = weekInfos.get(index);
                Date weekEndDate = weekInfo.getEndDate();
                for (Row row : taskefficiencyDs) {
                    Date date = DateUtils.truncateDate((Date)row.getDate("completetime"));
                    while (weekEndDate.compareTo(date) < 0 && ++index < size) {
                        weekInfo = weekInfos.get(index);
                        weekEndDate = weekInfo.getEndDate();
                    }
                    Object[] objectArray = taskamountAvg;
                    int n = index;
                    Integer.valueOf((Integer)objectArray[n] + row.getInteger("taskamount"));
                    costwaittimeArr[index] = ((BigDecimal)costwaittimeArr[index]).add(row.getBigDecimal("costwaittime"));
                }
            }
            finally {
                taskefficiencyDs.close();
            }
        }
        for (index = 0; index < size; ++index) {
            if ((Integer)taskamountAvg[index] == 0 || ((BigDecimal)costwaittimeArr[index]).equals(BigDecimal.ZERO)) continue;
            taskefficiencyAvg[index] = ((BigDecimal)costwaittimeArr[index]).divide(new BigDecimal((Integer)taskamountAvg[index]), 2, 4);
        }
        return Tuple.create((Object)taskamountAvg, (Object)taskefficiencyAvg);
    }

    public QFilter setQFilterRealtime(QFilter qFilter) {
        return qFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<Integer[], BigDecimal[]> getEchartDataWithMonth(List<MonthInfo> monthInfos, Date startDate, Date endDate) {
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Long sscId = this.getSscId();
        int size = monthInfos.size();
        Object[] taskamountAvg = new Integer[size];
        Arrays.fill(taskamountAvg, (Object)0);
        Object[] taskefficiencyAvg = new BigDecimal[size];
        Arrays.fill(taskefficiencyAvg, BigDecimal.ZERO);
        QFilter qFilter = TaskIndexDataService.getTaskefficiencyQFilter((Date)startDate, (Date)endDate, (Long)sscId);
        this.setQFilterRealtime(qFilter);
        DataSet taskefficiencyDs = this.ifShowLeaderHomePage() ? TaskIndexDataService.getInstance().getTaskefficiencyDSet(qFilter, sscId, Long.valueOf(this.getUsergroupId()), this.isSysAdminAndAllRight()) : TaskIndexDataService.getInstance().getTaskefficiencyDSet(qFilter, userId);
        if (taskefficiencyDs != null) {
            taskefficiencyDs = taskefficiencyDs.select(new String[]{"personid", "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "(cast(year(completetime) as integer)*100+cast(month(completetime) as integer)) as completetime", "(case when costwaittime is null or costwaittime = 0 then 0.02 else costwaittime end) as costwaittime"}).groupBy(new String[]{"completetime"}).count("taskcount").sum("coefficient", "taskamount").sum("costwaittime").finish().orderBy(new String[]{"completetime asc"});
            taskefficiencyDs = taskefficiencyDs.select(new String[]{"taskcount", "taskamount", "costwaittime", "completetime", "cast(case when taskcount=0 then 0 else costwaittime/taskamount end as decimal) as taskefficiency"});
            try {
                int index = 0;
                MonthInfo monthInfo = monthInfos.get(index);
                int yearMonth = monthInfo.getYear();
                int seqMonth = monthInfo.getMonthSeqOfYear();
                for (Row row : taskefficiencyDs) {
                    int year = row.getInteger("completetime") / 100;
                    int month = row.getInteger("completetime") % 100;
                    while ((year != yearMonth || month != seqMonth) && ++index < size) {
                        monthInfo = monthInfos.get(index);
                        yearMonth = monthInfo.getYear();
                        seqMonth = monthInfo.getMonthSeqOfYear();
                    }
                    taskamountAvg[index] = row.getInteger("taskamount");
                    taskefficiencyAvg[index] = row.getBigDecimal("taskefficiency").setScale(2, 4);
                }
            }
            finally {
                taskefficiencyDs.close();
            }
        }
        return Tuple.create((Object)taskamountAvg, (Object)taskefficiencyAvg);
    }

    public void setAmountYAxisView(Axis taskAmountAxis, BarSeries barSeries) {
        String unitName = ResManager.loadKDString((String)"\u5355", (String)"TaskNumAndTimeEffPlugin_2", (String)"ssc-hstc-formplugin", (Object[])new Object[0]);
        taskAmountAxis.setName(unitName);
        taskAmountAxis.setPropValue("nameLocation", (Object)"end");
        HashMap<String, Object> nameTextStyle = new HashMap<String, Object>();
        nameTextStyle.put("align", "left");
        nameTextStyle.put("padding", new Integer[]{0, 0, 0, -18});
        taskAmountAxis.setPropValue("nameTextStyle", nameTextStyle);
        String amountName = ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u91cf", (String)"TaskNumAndTimeEffPlugin_3", (String)"ssc-hstc-formplugin", (Object[])new Object[0]);
        barSeries.setName(amountName);
        barSeries.setColor("#40A9FF");
        barSeries.setStack(amountName);
    }

    private void setAmountYAxis(Chart customchart, Integer[] dataArray) {
        Axis taskAmountAxis = customchart.createYAxis(null, AxisType.value);
        BarSeries barSeries = customchart.createBarSeries(null);
        barSeries.setBarWidth("20%");
        barSeries.setColor("#40A9FF");
        barSeries.setData((Number[])dataArray);
        barSeries.getLabel().setShow(false);
        int currMaxValue = Collections.max(Arrays.asList(dataArray));
        int yMaxValue = TaskIndexDataService.getBaseYMaxValue((int)currMaxValue);
        int interval = yMaxValue / 5;
        taskAmountAxis.setMax((Number)yMaxValue);
        taskAmountAxis.setInterval((Number)interval);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axisTick.put("alignWithLabel", Boolean.TRUE);
        taskAmountAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(taskAmountAxis, "#40A9FF");
        taskAmountAxis.setPropValue("axisLine", axisTick);
        this.setAmountYAxisView(taskAmountAxis, barSeries);
    }

    public void setEfficiencyYAxisView(Axis efficiencyAxis, LineSeries lineSeries) {
        String unitName = ResManager.loadKDString((String)"\uff08\u5c0f\u65f6/\u5355\uff09", (String)"TaskNumAndTimeEffPlugin_4", (String)"ssc-hstc-formplugin", (Object[])new Object[0]);
        efficiencyAxis.setName(unitName);
        HashMap<String, Object> nameTextStyle = new HashMap<String, Object>();
        nameTextStyle.put("align", "right");
        nameTextStyle.put("padding", new Integer[]{0, -26, 0, 0});
        efficiencyAxis.setPropValue("nameTextStyle", nameTextStyle);
        String efficiencyName = ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u65f6\u6548", (String)"TaskNumAndTimeEffPlugin_5", (String)"ssc-hstc-formplugin", (Object[])new Object[0]);
        lineSeries.setName(efficiencyName);
        lineSeries.setLineColor("#FF991C");
        lineSeries.setItemColor("#FF991C");
    }

    private void setEfficiencyYAxis(Chart customchart, BigDecimal[] dataArray) {
        Axis efficiencyAxis = customchart.createYAxis(null, AxisType.value);
        LineSeries lineSeries = customchart.createLineSeries(null);
        lineSeries.setYAxisIndex(1);
        lineSeries.setData((Number[])dataArray);
        BigDecimal currMaxValue = Collections.max(Arrays.asList(dataArray));
        BigDecimal yMaxValue = TaskIndexDataService.getBaseYMaxValue((BigDecimal)currMaxValue);
        float interval = yMaxValue.floatValue() / 5.0f;
        efficiencyAxis.setMax((Number)yMaxValue);
        efficiencyAxis.setInterval((Number)Float.valueOf(interval));
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("alignWithLabel", Boolean.TRUE);
        efficiencyAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(efficiencyAxis, "#666666");
        efficiencyAxis.setPropValue("axisLine", axisTick);
        this.setEfficiencyYAxisView(efficiencyAxis, lineSeries);
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

