/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.task.TaskIndexDataService;
import kd.ssc.hstc.business.task.UserGroupService;
import kd.ssc.hstc.common.entity.WeekInfo;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.util.ControlUtil;
import kd.ssc.hstc.util.DateUtils;
import kd.ssc.hstc.util.ObjectUtils;

public class WbCostTimeTopPlugin
extends WbCardCommonPlugin
implements TabSelectListener {
    private static final String TAB = "tab";
    private static final String TODAY = "today";
    private static final String THISWEEK = "thisweek";
    private static final String FLEXTOP = "flextop";
    private static final String PROGRESSBAR = "progressbar";
    private static final String TASKTYPE = "tasktype";
    private static final String LBLCOSTTIME = "lblcosttime";
    private static final int TOPNUM = 5;

    public void afterCreateNewData(EventObject eventObject) {
        this.loadAndSetTopInfo(this.getUnitType());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getControl(TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.loadAndSetTopInfo(this.getUnitType());
    }

    private String getUnitType() {
        Tab tab = (Tab)this.getControl(TAB);
        return tab.getCurrentTab();
    }

    private void loadAndSetTopInfo(String currentTab) {
        int index;
        Date startDate;
        Date endDate = new Date();
        if (TODAY.equals(currentTab)) {
            startDate = new Date();
        } else if (THISWEEK.equals(currentTab)) {
            WeekInfo weekInfo = DateUtils.getWeekInfo((Date)new Date());
            startDate = weekInfo.getStartDate();
        } else {
            startDate = DateUtils.getFirstDayOfCurrentMonth();
        }
        long sscid = this.getSscId();
        QFilter shareCenterFilter = TaskIndexDataService.getTaskHistoryQFilter((Long)sscid, (Date)startDate, (Date)endDate);
        shareCenterFilter.and(new QFilter("qualitysamplelibrary", "=", (Object)0L));
        if (this.ifShowLeaderHomePage()) {
            long usergroupId = this.getUsergroupId();
            if (usergroupId != -1L) {
                QFilter groupFilter = new QFilter("usergroup", "=", (Object)usergroupId);
                shareCenterFilter.and(groupFilter);
            } else if (!this.isSysAdminAndAllRight()) {
                String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
                Set manageGroupSet = UserGroupService.getManageGroup((String)String.valueOf(sscid), (String)currUserId);
                if (ObjectUtils.isNotEmpty((Object)manageGroupSet)) {
                    shareCenterFilter.and(new QFilter("usergroup", "in", (Object)manageGroupSet));
                }
                shareCenterFilter.and(new QFilter("usergroup", "!=", (Object)0L));
            }
        } else {
            shareCenterFilter.and(new QFilter("personid", "=", (Object)RequestContext.getOrCreate().getCurrUserId()));
        }
        Tuple[] tuples = TaskService.getInstance().queryCostTimeByBillType(shareCenterFilter, this.ifShowLeaderHomePage());
        if (ObjectUtils.isEmpty((Object)tuples)) {
            for (int i = 1; i <= 5; ++i) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXTOP + i});
            }
            return;
        }
        BigDecimal currMaxValue = (BigDecimal)Collections.max(Stream.of(tuples).map(tuple -> (BigDecimal)tuple.item2).collect(Collectors.toList()));
        BigDecimal yMaxValue = TaskIndexDataService.getBaseYMaxValue((BigDecimal)currMaxValue);
        for (index = 1; index <= tuples.length && index <= 5; ++index) {
            String value = ((BigDecimal)tuples[index - 1].item2).setScale(2, 4).toString();
            int percent = ((BigDecimal)tuples[index - 1].item2).divide(yMaxValue, 2, 4).multiply(new BigDecimal("100")).intValue();
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBAR + index);
            bar.setPercent(percent, value);
            ControlUtil.setLabelText((IFormView)this.getView(), (String)(TASKTYPE + index), (String)((String)tuples[index - 1].item1));
            ControlUtil.setLabelText((IFormView)this.getView(), (String)(LBLCOSTTIME + index), (String)value);
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXTOP + index});
        }
        while (index <= 5) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXTOP + index});
            ++index;
        }
    }
}

