/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.business.task.TaskIndexDataService;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.util.ControlUtil;
import kd.ssc.hstc.util.DateUtils;

public class WbMyTaskAdminPlugin
extends WbCardCommonPlugin {
    private static final String lblnum_waitassign = "lblnumwaitassign";
    private static final String lblnum_assignerror = "lblnumassignerror";
    private static final String lblnum_waitdeal = "lblnumwaitdeal";
    private static final String lblnum_outtime = "lblnumouttime";
    private static final String lblnum_pending = "lblnumpending";
    private static final String lblnum_todaydone = "lblnumtodaydone";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IFormView formView = this.getView();
        long sscId = this.getSscId();
        long usergroupId = this.getUsergroupId();
        boolean isSysAdminAndAllRight = this.isSysAdminAndAllRight();
        Map dataMap = TaskIndexDataService.getIndexData((Long)sscId, (String)String.valueOf(usergroupId), (boolean)isSysAdminAndAllRight);
        Long waitassign = dataMap.getOrDefault("tobeassigned", 0L);
        ControlUtil.setLabelText((IFormView)formView, (String)lblnum_waitassign, (String)String.valueOf(waitassign));
        int assignerror = TaskIndexDataService.getTaskNumAssignError((Long)sscId, (String)String.valueOf(usergroupId), (boolean)isSysAdminAndAllRight);
        ControlUtil.setLabelText((IFormView)formView, (String)lblnum_assignerror, (String)String.valueOf(assignerror));
        int waitdeal = TaskIndexDataService.getTaskNumWaitdeal((Long)sscId, (String)String.valueOf(usergroupId), (boolean)isSysAdminAndAllRight);
        ControlUtil.setLabelText((IFormView)formView, (String)lblnum_waitdeal, (String)String.valueOf(waitdeal));
        Long outtime = dataMap.getOrDefault("expire", 0L);
        ControlUtil.setLabelText((IFormView)formView, (String)lblnum_outtime, (String)String.valueOf(outtime));
        int pending = TaskIndexDataService.getTaskNumPending((Long)sscId, (String)String.valueOf(usergroupId), (boolean)isSysAdminAndAllRight);
        ControlUtil.setLabelText((IFormView)formView, (String)lblnum_pending, (String)String.valueOf(pending));
        Long todaydone = dataMap.getOrDefault("today_receivecomplete", 0L);
        ControlUtil.setLabelText((IFormView)formView, (String)lblnum_todaydone, (String)String.valueOf(todaydone));
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{lblnum_waitassign, lblnum_assignerror, lblnum_waitdeal, lblnum_outtime, lblnum_pending, lblnum_todaydone});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label) {
            Label label = (Label)source;
            long sscId = this.getSscId();
            long usergroupid = this.getUsergroupId();
            String key = label.getKey();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            QFilter qFilter = new QFilter("pooltype", "=", (Object)"1");
            switch (key) {
                case "lblnumwaitassign": {
                    this.showTaskAdministrateList(sscId, usergroupid, "0", null, paramMap);
                    break;
                }
                case "lblnumassignerror": {
                    qFilter = new QFilter("state", "=", (Object)TaskStateEnum.DIS_EXCEPTION.getValue());
                    this.showTaskAdministrateList(sscId, usergroupid, "0", qFilter, paramMap);
                    break;
                }
                case "lblnumwaitdeal": {
                    qFilter = new QFilter("state", "=", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
                    this.showTaskAdministrateList(sscId, usergroupid, "1", qFilter, paramMap);
                    break;
                }
                case "lblnumouttime": {
                    paramMap.put("expire", "2");
                    this.showTaskAdministrateList(sscId, usergroupid, "1", qFilter, paramMap);
                    break;
                }
                case "lblnumpending": {
                    qFilter = new QFilter("state", "=", (Object)TaskStateEnum.PAUSE.getValue());
                    this.showTaskAdministrateList(sscId, usergroupid, "1", qFilter, paramMap);
                    break;
                }
                case "lblnumtodaydone": {
                    Date today = DateUtils.getTodayTruncate();
                    Date tomorrow = DateUtils.addDay((Date)today, (int)1);
                    qFilter = new QFilter("completetime", ">=", (Object)today);
                    qFilter.and("completetime", "<", (Object)tomorrow);
                    this.showTaskAdministrateList(sscId, usergroupid, "2", qFilter, paramMap);
                    break;
                }
            }
        }
    }

    private void showTaskAdministrateList(long sscid, long usergroupid, String pooltype, QFilter qFilter, Map<String, Object> paramMap) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("task_administrate");
        showParameter.setBillFormId("task_task");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u7ba1\u7406", (String)"WbMyTaskAdminPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParams(paramMap);
        showParameter.setCustomParam("ServiceAppId", (Object)"ssc");
        showParameter.setCustomParam("pooltype", (Object)pooltype);
        showParameter.setCustomParam("sscid", (Object)sscid);
        showParameter.setCustomParam("usergroupid", (Object)usergroupid);
        showParameter.setCustomParam("sources", (Object)"TaskBusinessManageIndexPlugin");
        if (qFilter != null) {
            QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)0L);
            qFilter.and(notQuaCheckTask);
            showParameter.setCustomParam("qfilter", (Object)qFilter.toSerializedString());
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

