/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.task.TaskIndexDataService;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.formplugin.web.common.TaskCommonService;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.util.ControlUtil;
import kd.ssc.hstc.util.DateUtils;

public class WbMyTaskBizPlugin
extends WbCardCommonPlugin {
    private static final String lblnum_waitdeal = "lblnumwaitdeal";
    private static final String lblnum_outtime = "lblnumouttime";
    private static final String lblnum_pending = "lblnumpending";
    private static final String lblnum_todaydone = "lblnumtodaydone";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        long sscId = this.getSscId();
        IFormView formView = this.getView();
        Map dataMap = TaskIndexDataService.getSaleIndexData((Long)RequestContext.getOrCreate().getCurrUserId(), (Long)sscId);
        Integer waitdeal = dataMap.getOrDefault("sale_myprocess", TaskService.getInstance().countTaskWaitdeal(sscId));
        ControlUtil.setLabelText((IFormView)formView, (String)lblnum_waitdeal, (String)String.valueOf(waitdeal));
        Integer pending = dataMap.getOrDefault("sale_pause", TaskService.getInstance().countTaskPending(sscId));
        ControlUtil.setLabelText((IFormView)formView, (String)lblnum_pending, (String)String.valueOf(pending));
        Integer outtime = dataMap.getOrDefault("sale_expirestate", TaskService.getInstance().countTaskOuttime(sscId));
        ControlUtil.setLabelText((IFormView)formView, (String)lblnum_outtime, (String)String.valueOf(outtime));
        Integer todaydone = dataMap.getOrDefault("sale_complet", TaskService.getInstance().countTaskTodaydone(sscId));
        ControlUtil.setLabelText((IFormView)formView, (String)lblnum_todaydone, (String)String.valueOf(todaydone));
        Integer lastdaydone = TaskService.getInstance().countTaskLastdaydone(sscId);
        int diffDone = todaydone - lastdaydone;
        if (diffDone == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"vectorapup", "vectorapdown"});
            ControlUtil.setLabelText((IFormView)formView, (String)"lblnumthanlastday", (String)"--");
        } else if (diffDone > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"vectorapdown"});
            ControlUtil.setLabelText((IFormView)formView, (String)"lblnumthanlastday", (String)String.valueOf(diffDone));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"vectorapup"});
            ControlUtil.setLabelText((IFormView)formView, (String)"lblnumthanlastday", (String)String.valueOf(Math.abs(diffDone)));
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{lblnum_waitdeal, lblnum_outtime, lblnum_pending, lblnum_todaydone});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label) {
            Label label = (Label)source;
            long sscId = this.getSscId();
            String key = label.getKey();
            QFilter qFilter = null;
            switch (key) {
                case "lblnumwaitdeal": {
                    this.showFormTaskpool(sscId, true, "2", qFilter);
                    break;
                }
                case "lblnumouttime": {
                    qFilter = new QFilter("expirestate", "=", (Object)"2");
                    this.showFormTaskpool(sscId, true, "2", qFilter);
                    break;
                }
                case "lblnumpending": {
                    qFilter = new QFilter("state", "=", (Object)TaskStateEnum.PAUSE.getValue());
                    this.showFormTaskpool(sscId, true, "2", qFilter);
                    break;
                }
                case "lblnumtodaydone": {
                    Date today = DateUtils.getTodayTruncate();
                    Date tomorrow = DateUtils.addDay((Date)today, (int)1);
                    qFilter = new QFilter("completetime", ">=", (Object)today);
                    qFilter.and("completetime", "<", (Object)tomorrow);
                    this.showFormTaskpool(sscId, false, "2", qFilter);
                    break;
                }
            }
        }
    }

    private void showFormTaskpool(long sscid, boolean ifProcess, String taskType, QFilter qFilter) {
        ListShowParameter showParameter = TaskCommonService.getInstance().getShowParameterTaskpool(sscid, ifProcess, taskType, qFilter);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

