/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.GradientItem;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.business.repository.TaskHistoryRepository;
import kd.ssc.hstc.business.repository.TaskRepository;
import kd.ssc.hstc.business.task.TaskIndexDataService;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.util.DateUtils;

public class WbTaskActivityLevelPlugin
extends WbCardCommonPlugin {
    public void afterCreateNewData(EventObject eventObject) {
        List timePoints = DateUtils.getTimePoints((Date)new Date(), (int)25);
        String[] categorys = new String[24];
        for (int i = 0; i < categorys.length; ++i) {
            categorys[i] = DateUtils.format((Date)((Date)timePoints.get(i + 1)), (String)"HH:mm");
        }
        PointLineChart pointLineChart = (PointLineChart)this.getControl("pointlinechart");
        pointLineChart.clearData();
        pointLineChart.setShowTooltip(true);
        pointLineChart.setLegendPropValue("top", (Object)"20");
        Axis xAxis = pointLineChart.createXAxis(null, AxisType.category);
        xAxis.setCategorys(categorys);
        Axis yAxis = pointLineChart.createYAxis(null, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("alignWithLabel", Boolean.TRUE);
        yAxis.setPropValue("axisTick", axisTick);
        yAxis.setPropValue("axisLine", axisTick);
        Tuple<Integer[], Integer[]> amountChangeTuple = this.getAmountChangeInDay(timePoints);
        int currMaxValue1 = (Integer)Collections.max(Arrays.asList((Object[])amountChangeTuple.item1));
        int currMaxValue2 = (Integer)Collections.max(Arrays.asList((Object[])amountChangeTuple.item2));
        int currMaxValue = Math.max(currMaxValue1, currMaxValue2);
        int yMaxValue = TaskIndexDataService.getBaseYMaxValue((int)currMaxValue);
        int interval = yMaxValue / 5;
        yAxis.setMax((Number)yMaxValue);
        yAxis.setInterval((Number)interval);
        LineSeries lineSeriesNew = pointLineChart.createLineSeries(ResManager.loadKDString((String)"\u65b0\u589e\u91cf", (String)"WbTaskActivityLevelPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        lineSeriesNew.setSmooth(true);
        lineSeriesNew.setData((Number[])amountChangeTuple.item1);
        lineSeriesNew.setColor("#41A9FF");
        lineSeriesNew.setLineColor("#41A9FF");
        lineSeriesNew.setItemColor("#41A9FF");
        lineSeriesNew.setPropValue("axisLine", Collections.singletonMap("lineStyle", Collections.singletonMap("color", "#41A9FF")));
        GradientItem gradientItem1 = new GradientItem();
        gradientItem1.setOffset(0);
        gradientItem1.setColor("#41A9FF");
        GradientItem gradientItem2 = new GradientItem();
        gradientItem2.setOffset(1);
        gradientItem2.setColor("#FFFFFF");
        lineSeriesNew.setAreaColor(0, 0, 0, 1, (List)Lists.newArrayList((Object[])new GradientItem[]{gradientItem1, gradientItem2}));
        lineSeriesNew.getAreaNormalStyle().put("opacity", 0.5);
        LineSeries lineSeriesDone = pointLineChart.createLineSeries(ResManager.loadKDString((String)"\u5904\u7406\u91cf", (String)"WbTaskActivityLevelPlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        lineSeriesDone.setSmooth(true);
        lineSeriesDone.setData((Number[])amountChangeTuple.item2);
        lineSeriesDone.setColor("#FF991C");
        lineSeriesDone.setLineColor("#FF991C");
        lineSeriesDone.setItemColor("#FF991C");
        lineSeriesDone.setPropValue("axisLine", Collections.singletonMap("lineStyle", Collections.singletonMap("color", "#FF991C")));
        GradientItem gradientItemDone1 = new GradientItem();
        gradientItemDone1.setOffset(0);
        gradientItemDone1.setColor("#FF991C");
        GradientItem gradientItemDone2 = new GradientItem();
        gradientItemDone2.setOffset(1);
        gradientItemDone2.setColor("#FFFFFF");
        lineSeriesDone.setAreaColor(0, 0, 0, 1, (List)Lists.newArrayList((Object[])new GradientItem[]{gradientItemDone1, gradientItemDone2}));
        lineSeriesDone.getAreaNormalStyle().put("opacity", 0.5);
        HashMap<String, Object> dataZoom = new HashMap<String, Object>();
        dataZoom.put("type", "slider");
        dataZoom.put("start", "66");
        dataZoom.put("end", "100");
        dataZoom.put("left", "20");
        dataZoom.put("showDataShadow", "auto");
        HashMap<String, Integer> handleStyle = new HashMap<String, Integer>();
        handleStyle.put("borderWidth", 0);
        dataZoom.put("handleStyle", handleStyle);
        pointLineChart.getProperties().put("dataZoom", dataZoom);
        pointLineChart.bindData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<Integer[], Integer[]> getAmountChangeInDay(List<Date> timePoints) {
        int size = timePoints.size() - 1;
        Object[] countHourNew = new Integer[size];
        Object[] countHourDone = new Integer[size];
        Arrays.fill(countHourNew, (Object)0);
        Arrays.fill(countHourDone, (Object)0);
        Date startDate = timePoints.get(0);
        Date endDate = timePoints.get(timePoints.size() - 1);
        long sscid = this.getSscId();
        QFilter qFilterWait = TaskIndexDataService.getTaskQFilter((Long)sscid);
        qFilterWait.and(new QFilter("createtime", ">=", (Object)startDate));
        qFilterWait.and(new QFilter("createtime", "<=", (Object)endDate));
        QFilter qFilterDone = TaskIndexDataService.getTaskHistoryQFilterNoTruncate((Long)sscid, (Date)startDate, (Date)endDate);
        boolean isShowForLeader = this.ifShowLeaderHomePage();
        long usergroupId = isShowForLeader ? this.getUsergroupId() : -1L;
        QFilter qFilterUser = TaskIndexDataService.getUserQFilter((Long)sscid, (long)usergroupId, (boolean)isShowForLeader, (boolean)this.isSysAdminAndAllRight());
        if (qFilterUser != null) {
            qFilterDone.and(qFilterUser);
            qFilterWait.and(qFilterUser);
        }
        DataSet waitingTaskDs = TaskRepository.getInstance().getTaskDataSet("id,coefficient,createtime", new QFilter[]{qFilterWait}, "createtime asc").select(new String[]{"id", "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "createtime"});
        DataSet doneTaskDsCreate = TaskHistoryRepository.getInstance().getTaskHistoryDataSet("id,coefficient,createtime,completetime", new QFilter[]{qFilterDone}, "createtime asc").select(new String[]{"id", "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "createtime", "completetime"});
        DataSet doneTaskDsComplete = null;
        if (doneTaskDsCreate != null) {
            doneTaskDsComplete = doneTaskDsCreate.copy().orderBy(new String[]{"completetime asc"});
        }
        this.setCountHourNewArray((Integer[])countHourNew, timePoints, waitingTaskDs, doneTaskDsCreate);
        if (doneTaskDsComplete != null) {
            try {
                int index = 0;
                Date endTime = timePoints.get(index + 1);
                for (Row row : doneTaskDsComplete) {
                    Date completetime = row.getDate("completetime");
                    while (completetime.compareTo(endTime) > 0 && ++index < size) {
                        endTime = timePoints.get(index + 1);
                    }
                    if (index >= size) {
                        break;
                    }
                    Object[] objectArray = countHourDone;
                    int n = index;
                    Integer.valueOf((Integer)objectArray[n] + row.getInteger("coefficient"));
                }
            }
            finally {
                doneTaskDsComplete.close();
            }
        }
        return Tuple.create((Object)countHourNew, (Object)countHourDone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCountHourNewArray(Integer[] countHourNew, List<Date> timePoints, DataSet waitingTaskDs, DataSet doneTaskDsCreate) {
        int n;
        Integer[] integerArray;
        Date createtime;
        Date endTime;
        int index;
        int size = timePoints.size() - 1;
        if (waitingTaskDs != null) {
            try {
                index = 0;
                endTime = timePoints.get(index + 1);
                for (Row row : waitingTaskDs) {
                    createtime = row.getDate("createtime");
                    while (createtime.compareTo(endTime) > 0 && ++index < size) {
                        endTime = timePoints.get(index + 1);
                    }
                    if (index >= size) {
                        break;
                    }
                    integerArray = countHourNew;
                    n = index;
                    Integer.valueOf(integerArray[n] + row.getInteger("coefficient"));
                }
            }
            finally {
                waitingTaskDs.close();
            }
        }
        if (doneTaskDsCreate != null) {
            try {
                index = 0;
                endTime = timePoints.get(index + 1);
                for (Row row : doneTaskDsCreate) {
                    createtime = row.getDate("createtime");
                    while (createtime.compareTo(endTime) > 0 && ++index < size) {
                        endTime = timePoints.get(index + 1);
                    }
                    if (index >= size) {
                        break;
                    }
                    integerArray = countHourNew;
                    n = index;
                    Integer.valueOf(integerArray[n] + row.getInteger("coefficient"));
                }
            }
            finally {
                doneTaskDsCreate.close();
            }
        }
    }
}

