/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.task.TaskIndexDataService;
import kd.ssc.hstc.business.task.UserGroupService;
import kd.ssc.hstc.common.entity.WeekInfo;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.util.ControlUtil;
import kd.ssc.hstc.util.DateUtils;
import kd.ssc.hstc.util.ObjectUtils;

public class WbTaskEfficiencyRankPlugin
extends WbCardCommonPlugin
implements TabSelectListener,
BeforeF7SelectListener {
    private static final String TAB_RANKTYPE = "tabranktype";
    private static final String AMOUNTRANK = "amountrank";
    private static final String TAB_DATERANGETYPE = "tabdaterangetype";
    private static final String TODAY = "today";
    private static final String THISWEEK = "thisweek";
    private static final String FLEXTOP = "flextop";
    private static final String PROGRESSBAR = "progressbar";
    private static final String USERNAME = "username";
    private static final String LBLCOSTTIME = "lblcosttime";
    private static final String LBLTOP = "lbltop";
    private static final int TOPNUM = 5;
    private static final String LBLCURRENTSEQ = "lblcurrentseq";
    private static final String FLEXPANELCURRUSER = "flexpanelcurruser";
    private static final String USERGROUP = "usergroup";
    private static final String ORDERSEQ = "orderseq";

    public void afterCreateNewData(EventObject eventObject) {
        if (this.ifShowLeaderHomePage()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{USERGROUP});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ORDERSEQ});
            List userGroupIds = UserGroupService.getUsergroupIds((Long)this.getSscId(), (Long)RequestContext.getOrCreate().getCurrUserId());
            if (userGroupIds != null) {
                this.getModel().setValue(USERGROUP, userGroupIds.get(0));
            }
        }
        this.queryAndRank(this.getRankType(), this.getUnitType(), this.getCurrCardUsergroupId(), this.ifOrderByDesc());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tabranktype = (Tab)this.getControl(TAB_RANKTYPE);
        tabranktype.addTabSelectListener((TabSelectListener)this);
        Tab tabdaterangetype = (Tab)this.getControl(TAB_DATERANGETYPE);
        tabdaterangetype.addTabSelectListener((TabSelectListener)this);
        BasedataEdit sscidEdit = (BasedataEdit)this.getView().getControl(USERGROUP);
        sscidEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.queryAndRank(this.getRankType(), this.getUnitType(), this.getCurrCardUsergroupId(), this.ifOrderByDesc());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (ORDERSEQ.equals(name) || USERGROUP.equals(name)) {
            if (ORDERSEQ.equals(name) && ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().getString(ORDERSEQ))) {
                this.getModel().beginInit();
                this.getModel().setValue(ORDERSEQ, args.getChangeSet()[0].getOldValue());
                this.getModel().endInit();
                return;
            }
            this.queryAndRank(this.getRankType(), this.getUnitType(), this.getCurrCardUsergroupId(), this.ifOrderByDesc());
        }
    }

    private String getRankType() {
        Tab tab = (Tab)this.getControl(TAB_RANKTYPE);
        return tab.getCurrentTab();
    }

    private String getUnitType() {
        Tab tab = (Tab)this.getControl(TAB_DATERANGETYPE);
        return tab.getCurrentTab();
    }

    public long getCurrCardUsergroupId() {
        if (this.ifShowLeaderHomePage()) {
            return this.getUsergroupId();
        }
        return this.getModel().getDataEntity().getLong("usergroup.id");
    }

    private boolean ifOrderByDesc() {
        return "2".equals(this.getModel().getDataEntity().getString(ORDERSEQ));
    }

    private void queryAndRank(String rankType, String dateRangeType, long usergroupId, boolean ifOrderDesc) {
        int index;
        List taskRankList;
        Date startDate;
        Date endDate = new Date();
        if (TODAY.equals(dateRangeType)) {
            startDate = new Date();
        } else if (THISWEEK.equals(dateRangeType)) {
            WeekInfo weekInfo = DateUtils.getWeekInfo((Date)new Date());
            startDate = weekInfo.getStartDate();
        } else {
            startDate = DateUtils.getFirstDayOfCurrentMonth();
        }
        ArrayList userIdList = new ArrayList();
        long sscid = this.getSscId();
        QFilter qFilter = TaskIndexDataService.getTaskHistoryQFilter((Long)sscid, (Date)startDate, (Date)endDate);
        boolean ifShowForLeader = this.ifShowLeaderHomePage();
        if (ifShowForLeader) {
            if (usergroupId != -1L) {
                QFilter groupFilter = new QFilter(USERGROUP, "=", (Object)usergroupId);
                qFilter.and(groupFilter);
                userIdList.addAll(UserGroupService.getInstance().getGroupBosUsers((Set)Sets.newHashSet((Object[])new Long[]{usergroupId})));
            } else if (!this.isSysAdminAndAllRight()) {
                String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
                Set manageGroupSet = UserGroupService.getManageGroup((String)String.valueOf(sscid), (String)currUserId);
                if (ObjectUtils.isEmpty((Object)manageGroupSet)) {
                    qFilter.and(new QFilter(USERGROUP, "in", (Object)manageGroupSet));
                    userIdList.addAll(UserGroupService.getInstance().getGroupBosUsers(manageGroupSet));
                }
                qFilter.and(new QFilter(USERGROUP, "!=", (Object)0L));
            } else {
                userIdList.addAll(UserGroupService.getInstance().getGroupBosUsers(Long.valueOf(sscid)));
            }
        } else {
            qFilter.and(new QFilter(USERGROUP, "=", (Object)usergroupId));
            userIdList.addAll(UserGroupService.getInstance().getGroupBosUsers((Set)Sets.newHashSet((Object[])new Long[]{usergroupId})));
        }
        if (AMOUNTRANK.equals(rankType)) {
            taskRankList = TaskService.getInstance().queryRankTaskAmount(new QFilter[]{qFilter}, true, userIdList);
            this.getView().setVisible(Boolean.TRUE, new String[]{"lblunitamount1", "lblunitamount2", "lblunitamount3", "lblunitamount4", "lblunitamount5"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblunitefficiency1", "lblunitefficiency2", "lblunitefficiency3", "lblunitefficiency4", "lblunitefficiency5"});
        } else {
            taskRankList = TaskService.getInstance().queryRankTaskEfficiency(new QFilter[]{qFilter}, false, ifShowForLeader, userIdList);
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblunitamount1", "lblunitamount2", "lblunitamount3", "lblunitamount4", "lblunitamount5"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"lblunitefficiency1", "lblunitefficiency2", "lblunitefficiency3", "lblunitefficiency4", "lblunitefficiency5"});
        }
        if (ObjectUtils.isEmpty((Object)taskRankList)) {
            for (int i = 1; i <= 5; ++i) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXTOP + i});
            }
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRENTSEQ, (String)"0");
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
        if (this.ifShowLeaderHomePage()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELCURRUSER});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELCURRUSER});
        }
        if (ifOrderDesc) {
            int seq;
            this.getView().setVisible(Boolean.FALSE, new String[]{"imageap1", "imageap2", "imageap3"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"lbltop1", "lbltop2", "lbltop3"});
            int lastSeq = taskRankList.size();
            for (int i = 0; i < 5 && (seq = lastSeq - i) != 0; ++i) {
                ControlUtil.setLabelText((IFormView)this.getView(), (String)(LBLTOP + (i + 1)), (String)String.valueOf(seq));
            }
            Collections.reverse(taskRankList);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"imageap1", "imageap2", "imageap3"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lbltop1", "lbltop2", "lbltop3"});
            for (int i = 1; i <= 5; ++i) {
                ControlUtil.setLabelText((IFormView)this.getView(), (String)(LBLTOP + i), (String)String.valueOf(i));
            }
        }
        BigDecimal currMaxValue = (BigDecimal)Collections.max(taskRankList.stream().map(tuple -> (BigDecimal)tuple.item2).collect(Collectors.toList()));
        BigDecimal yMaxValue = TaskIndexDataService.getBaseYMaxValue((BigDecimal)currMaxValue);
        for (index = 1; index <= taskRankList.size(); ++index) {
            Tuple tuple2 = (Tuple)taskRankList.get(index - 1);
            long userId = ((DynamicObject)tuple2.item1).getLong("id");
            String userName = ((DynamicObject)tuple2.item1).getString("name");
            String value = ((BigDecimal)tuple2.item2).setScale(2, 4).toString();
            if (RequestContext.getOrCreate().getCurrUserId() == userId) {
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRENTSEQ, (String)(index + ""));
            }
            if (index > 5) continue;
            int percent = ((BigDecimal)tuple2.item2).divide(yMaxValue, 2, 4).multiply(new BigDecimal("100")).intValue();
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBAR + index);
            bar.setPercent(percent, value);
            ControlUtil.setLabelText((IFormView)this.getView(), (String)(USERNAME + index), (String)userName);
            ControlUtil.setLabelText((IFormView)this.getView(), (String)(LBLCOSTTIME + index), (String)value);
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXTOP + index});
        }
        while (index <= 5) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXTOP + index});
            ++index;
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (USERGROUP.equals(name)) {
            QFilter qFilter = new QFilter("createorg", "=", (Object)this.getSscId());
            qFilter.and(new QFilter("entryentity.userfield", "=", (Object)RequestContext.getOrCreate().getCurrUserId()));
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }
}

