/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.task.TaskIndexDataService;
import kd.ssc.hstc.common.TaskPoolTypeEnum;
import kd.ssc.hstc.common.entity.WeekInfo;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.util.ControlUtil;
import kd.ssc.hstc.util.DateUtils;

public class WbTaskOverdueRatioPlugin
extends WbCardCommonPlugin
implements TabSelectListener {
    private static final String TODAY = "today";
    private static final String THISWEEK = "thisweek";
    private static final String TAB_DATERANGETYPE = "tabdaterangetype";
    private static final String LBL_RATIOOVERED = "lblratioovered";
    private static final String LBL_COUNTOVERED = "lblcountovered";
    private static final String LBL_RATIOTOOVER = "lblratiotoover";
    private static final String LBL_COUNTTOOVER = "lblcounttoover";
    private static final String LBL_RATIONOOVER = "lblrationoover";
    private static final String LBL_COUNTNOOVER = "lblcountnoover";

    public void afterCreateNewData(EventObject eventObject) {
        this.queryAndShowOverdueRatio(this.getUnitType());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getControl(TAB_DATERANGETYPE);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.queryAndShowOverdueRatio(this.getUnitType());
    }

    private String getUnitType() {
        Tab tab = (Tab)this.getControl(TAB_DATERANGETYPE);
        return tab.getCurrentTab();
    }

    private void queryAndShowOverdueRatio(String dateRangeType) {
        DynamicObject[] taskHisInfos;
        DynamicObject[] taskInfos;
        Date startDate;
        long sscid = this.getSscId();
        Date endDate = new Date();
        if (TODAY.equals(dateRangeType)) {
            startDate = new Date();
        } else if (THISWEEK.equals(dateRangeType)) {
            WeekInfo weekInfo = DateUtils.getWeekInfo((Date)new Date());
            startDate = weekInfo.getStartDate();
        } else {
            startDate = DateUtils.getFirstDayOfCurrentMonth();
        }
        QFilter qFilterDone = TaskIndexDataService.getTaskHistoryQFilter((Long)sscid, (Date)startDate, (Date)endDate);
        QFilter qFilterWait = TaskIndexDataService.getTaskQFilter((Long)sscid);
        boolean isShowForLeader = this.ifShowLeaderHomePage();
        long usergroupId = isShowForLeader ? this.getUsergroupId() : -1L;
        QFilter qFilterUser = TaskIndexDataService.getUserQFilter((Long)sscid, (long)usergroupId, (boolean)isShowForLeader, (boolean)this.isSysAdminAndAllRight());
        if (qFilterUser != null) {
            qFilterWait.and(qFilterUser);
            qFilterDone.and(qFilterUser);
        }
        qFilterWait.and(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
        int countOvered = 0;
        int countToOver = 0;
        int countNoOver = 0;
        for (DynamicObject taskInfo : taskInfos = TaskService.getInstance().queryTask("expirestate", new QFilter[]{qFilterWait})) {
            String expirestate = taskInfo.getString("expirestate");
            if ("2".equals(expirestate)) {
                ++countOvered;
                continue;
            }
            if ("3".equals(expirestate)) {
                ++countToOver;
                continue;
            }
            ++countNoOver;
        }
        for (DynamicObject taskInfo : taskHisInfos = TaskService.getInstance().queryTaskHistory("expirestate", new QFilter[]{qFilterDone})) {
            String expirestate = taskInfo.getString("expirestate");
            if ("2".equals(expirestate)) {
                ++countOvered;
                continue;
            }
            if ("3".equals(expirestate)) {
                ++countToOver;
                continue;
            }
            ++countNoOver;
        }
        BigDecimal total = new BigDecimal(countOvered + countToOver + countNoOver);
        BigDecimal percentOvered = total.intValue() == 0 ? BigDecimal.ZERO : new BigDecimal(countOvered).multiply(new BigDecimal("100")).divide(total, 2, 4);
        BigDecimal percentToOver = total.intValue() == 0 ? BigDecimal.ZERO : new BigDecimal(countToOver).multiply(new BigDecimal("100")).divide(total, 2, 4);
        BigDecimal percentNoOver = total.intValue() == 0 ? BigDecimal.ZERO : new BigDecimal(countNoOver).multiply(new BigDecimal("100")).divide(total, 2, 4);
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_RATIOOVERED, (String)(percentOvered + "%"));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_RATIOTOOVER, (String)(percentToOver + "%"));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_RATIONOOVER, (String)(percentNoOver + "%"));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_COUNTOVERED, (String)(countOvered + ""));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_COUNTTOOVER, (String)(countToOver + ""));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_COUNTNOOVER, (String)(countNoOver + ""));
        ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>(4);
        itemValues.add(new ItemValue(ResManager.loadKDString((String)"\u5df2\u8d85\u671f", (String)"WbTaskOverdueRatioPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), (Number)countOvered, "#F57582"));
        itemValues.add(new ItemValue(ResManager.loadKDString((String)"\u5373\u5c06\u8d85\u671f", (String)"WbTaskOverdueRatioPlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), (Number)countToOver, "#FBC53D"));
        itemValues.add(new ItemValue(ResManager.loadKDString((String)"\u672a\u8d85\u671f", (String)"WbTaskOverdueRatioPlugin_2", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), (Number)countNoOver, "#40A9FF"));
        this.setPieChart(itemValues.toArray(new ItemValue[0]));
    }

    private void setPieChart(ItemValue[] itemValues) {
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        PieSeries pieSeries = pieChart.createSeries(ResManager.loadKDString((String)"\u4efb\u52a1\u5360\u6bd4", (String)"WbTaskOverdueRatioPlugin_3", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        pieSeries.setCenter("50%", "50%");
        HashMap<String, Object> labelmap = new HashMap<String, Object>();
        labelmap.put("show", true);
        labelmap.put("position", "inside");
        labelmap.put("formatter", "{d}%");
        pieSeries.setPropValue("label", labelmap);
        HashMap map = new HashMap();
        HashMap<String, String> labelmap2 = new HashMap<String, String>();
        labelmap2.put("fontSize", "20");
        map.put("label", labelmap2);
        pieSeries.setPropValue("emphasis", map);
        pieSeries.setPropValue("avoidLabelOverlap", (Object)true);
        pieSeries.setPropValue("stillShowZeroSum", (Object)false);
        pieSeries.setPropValue("labelLine", Collections.singletonMap("show", false));
        pieSeries.setPropValue("itemStyle", Collections.singletonMap("borderWidth", 0));
        pieSeries.setData(itemValues);
        pieSeries.setRadius("50%", "90%");
        pieChart.bindData(null);
    }
}

