/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.business.repository.TaskHistoryRepository;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.task.TaskIndexDataService;
import kd.ssc.hstc.common.TaskPoolTypeEnum;
import kd.ssc.hstc.common.entity.WeekInfo;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.util.ControlUtil;
import kd.ssc.hstc.util.DateUtils;

public class WbTaskProAnalysisPlugin
extends WbCardCommonPlugin
implements TabSelectListener {
    private static final String TODAY = "today";
    private static final String THISWEEK = "thisweek";
    private static final String TAB_DATERANGETYPE = "tabdaterangetype";
    private static final String FLEXWAITASSIGN = "flexwaitassign";
    private static final String LBL_RATIOWAITASSIGN = "lblratiowaitassign";
    private static final String LBL_COUNTWAITASSIGN = "lblcountwaitassign";
    private static final String LBL_RATIOWAITDEAL = "lblratiowaitdeal";
    private static final String LBL_COUNTWAITDEAL = "lblcountwaitdeal";
    private static final String LBL_RATIODONE = "lblratiodone";
    private static final String LBL_COUNTDONE = "lblcountdone";

    public void afterCreateNewData(EventObject eventObject) {
        this.queryAndShowTaskProcess(this.getUnitType());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getControl(TAB_DATERANGETYPE);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.queryAndShowTaskProcess(this.getUnitType());
    }

    private String getUnitType() {
        Tab tab = (Tab)this.getControl(TAB_DATERANGETYPE);
        return tab.getCurrentTab();
    }

    private void queryAndShowTaskProcess(String dateRangeType) {
        DynamicObject[] taskInfos;
        Date startDate;
        long sscid = this.getSscId();
        Date endDate = new Date();
        if (TODAY.equals(dateRangeType)) {
            startDate = new Date();
        } else if (THISWEEK.equals(dateRangeType)) {
            WeekInfo weekInfo = DateUtils.getWeekInfo((Date)new Date());
            startDate = weekInfo.getStartDate();
        } else {
            startDate = DateUtils.getFirstDayOfCurrentMonth();
        }
        QFilter qFilterDone = TaskIndexDataService.getTaskHistoryQFilter((Long)sscid, (Date)startDate, (Date)endDate);
        QFilter qFilterWait = TaskIndexDataService.getTaskQFilter((Long)sscid);
        boolean isShowForLeader = this.ifShowLeaderHomePage();
        long usergroupId = isShowForLeader ? this.getUsergroupId() : -1L;
        QFilter qFilterUser = TaskIndexDataService.getUserQFilter((Long)sscid, (long)usergroupId, (boolean)isShowForLeader, (boolean)this.isSysAdminAndAllRight());
        if (qFilterUser != null) {
            qFilterDone.and(qFilterUser);
            qFilterWait.and(qFilterUser);
        }
        int countDone = TaskHistoryRepository.getInstance().countTaskHistory(new QFilter[]{qFilterDone});
        int countWaitAssign = 0;
        int countWaitDeal = 0;
        for (DynamicObject taskInfo : taskInfos = TaskService.getInstance().queryTask("pooltype", new QFilter[]{qFilterWait})) {
            String poolType = taskInfo.getString("pooltype");
            if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(poolType)) {
                ++countWaitAssign;
                continue;
            }
            if (!TaskPoolTypeEnum.PROCESSING.getValue().equals(poolType)) continue;
            ++countWaitDeal;
        }
        BigDecimal total = new BigDecimal(countWaitAssign + countWaitDeal + countDone);
        BigDecimal percentWaitAssign = total.intValue() == 0 ? BigDecimal.ZERO : new BigDecimal(countWaitAssign).multiply(new BigDecimal("100")).divide(total, 2, 4);
        BigDecimal percentWaitDeal = total.intValue() == 0 ? BigDecimal.ZERO : new BigDecimal(countWaitDeal).multiply(new BigDecimal("100")).divide(total, 2, 4);
        BigDecimal percentDone = total.intValue() == 0 ? BigDecimal.ZERO : new BigDecimal(countDone).multiply(new BigDecimal("100")).divide(total, 2, 4);
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_RATIOWAITASSIGN, (String)(percentWaitAssign + "%"));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_RATIOWAITDEAL, (String)(percentWaitDeal + "%"));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_RATIODONE, (String)(percentDone + "%"));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_COUNTWAITASSIGN, (String)(countWaitAssign + ""));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_COUNTWAITDEAL, (String)(countWaitDeal + ""));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBL_COUNTDONE, (String)(countDone + ""));
        ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>(4);
        if (isShowForLeader) {
            itemValues.add(new ItemValue(ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"WbTaskProAnalysisPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), (Number)countWaitAssign, "#45cdff"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXWAITASSIGN});
        }
        itemValues.add(new ItemValue(ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"WbTaskProAnalysisPlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), (Number)countWaitDeal, "#40A9FF"));
        itemValues.add(new ItemValue(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"WbTaskProAnalysisPlugin_2", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), (Number)countDone, "#45DAD1"));
        this.setPieChart(itemValues.toArray(new ItemValue[0]));
    }

    private void setPieChart(ItemValue[] itemValues) {
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        PieSeries pieSeries = pieChart.createSeries(ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6", (String)"WbTaskProAnalysisPlugin_3", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        pieSeries.setCenter("50%", "50%");
        HashMap<String, Object> labelmap = new HashMap<String, Object>();
        labelmap.put("show", true);
        labelmap.put("position", "inside");
        labelmap.put("formatter", "{d}%");
        labelmap.put("fontSize", "12");
        pieSeries.setPropValue("label", labelmap);
        HashMap map = new HashMap();
        HashMap<String, Object> labelmap2 = new HashMap<String, Object>();
        labelmap2.put("show", true);
        labelmap2.put("position", "center");
        labelmap2.put("fontSize", "20");
        map.put("label", labelmap2);
        pieSeries.setPropValue("emphasis", map);
        pieSeries.setPropValue("labelLine", Collections.singletonMap("show", false));
        pieSeries.setPropValue("itemStyle", Collections.singletonMap("borderWidth", 0));
        pieSeries.setData(itemValues);
        pieSeries.setRadius("50%", "90%");
        pieChart.bindData(null);
    }
}

