/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.business.repository.TaskHistoryRepository;
import kd.ssc.hstc.business.repository.TaskRepository;
import kd.ssc.hstc.business.task.TaskIndexDataService;
import kd.ssc.hstc.business.task.UserGroupService;
import kd.ssc.hstc.common.TaskPoolTypeEnum;
import kd.ssc.hstc.common.entity.MonthInfo;
import kd.ssc.hstc.common.entity.UserTaskSituaton;
import kd.ssc.hstc.common.entity.WeekInfo;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.util.ControlUtil;
import kd.ssc.hstc.util.DateUtils;

public class WbTaskSituationPlugin
extends WbCardCommonPlugin
implements TabSelectListener,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(WbTaskSituationPlugin.class);
    private static final String TODAY = "today";
    private static final String THISWEEK = "thisweek";
    private static final String USERGROUP = "usergroup";
    private static final String TAB_DATERANGETYPE = "tabdaterangetype";
    private static final String LBLCURRRECEIVENUM = "lblcurrreceivenum";
    private static final String LBLRECEIVERATIO = "lblreceiveratio";
    private static final String VECTORAPUPRECEIVE = "vectorapupreceive";
    private static final String VECTORAPDOWNRECEIVE = "vectorapdownreceive";
    private static final String LBLCURRRECEIVETOP = "lblcurrreceivetop";
    private static final String LBLCURRDONENUM = "lblcurrdonenum";
    private static final String LBLDONERATIO = "lbldoneratio";
    private static final String VECTORAPUPDONE = "vectorapupdone";
    private static final String VECTORAPDOWNDONE = "vectorapdowndone";
    private static final String LBLCURRDONETOP = "lblcurrdonetop";
    private static final String LBLCURREFFICIENCY = "lblcurrefficiency";
    private static final String LBLEFFICIENCYRATIO = "lblefficiencyratio";
    private static final String VECTORAPUPEFFICIENCY = "vectorapupefficiency";
    private static final String VECTORAPDOWNEFFICIENCY = "vectorapdownefficiency";
    private static final String LBLEFFICIENCYTOP = "lblefficiencytop";

    public void afterCreateNewData(EventObject eventObject) {
        List userGroupIds = UserGroupService.getUsergroupIds((Long)this.getSscId(), (Long)RequestContext.getOrCreate().getCurrUserId());
        if (userGroupIds != null) {
            this.getModel().setValue(USERGROUP, userGroupIds.get(0));
        }
        this.queryAndShowData(this.getUnitType(), this.getCurrCardUsergroupId());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getControl(TAB_DATERANGETYPE);
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit usergroupEdit = (BasedataEdit)this.getView().getControl(USERGROUP);
        usergroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.queryAndShowData(this.getUnitType(), this.getCurrCardUsergroupId());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (USERGROUP.equals(name)) {
            QFilter qFilter = new QFilter("createorg", "=", (Object)this.getSscId());
            qFilter.and(new QFilter("entryentity.userfield", "=", (Object)RequestContext.getOrCreate().getCurrUserId()));
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (USERGROUP.equals(name)) {
            this.queryAndShowData(this.getUnitType(), this.getCurrCardUsergroupId());
        }
    }

    private String getUnitType() {
        Tab tab = (Tab)this.getControl(TAB_DATERANGETYPE);
        return tab.getCurrentTab();
    }

    public long getCurrCardUsergroupId() {
        if (this.ifShowLeaderHomePage()) {
            return this.getUsergroupId();
        }
        return this.getModel().getDataEntity().getLong("usergroup.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryAndShowData(String dateRangeType, long usergroupId) {
        Date receivetime;
        UserTaskSituaton userTaskSituaton2;
        Long personId;
        Date lastStartDate;
        Date currStartDate;
        long sscid = this.getSscId();
        Date currEndDate = new Date();
        if (TODAY.equals(dateRangeType)) {
            currStartDate = new Date();
            lastStartDate = DateUtils.addDay((Date)currStartDate, (int)-1);
        } else if (THISWEEK.equals(dateRangeType)) {
            WeekInfo weekInfo = DateUtils.getWeekInfo((Date)new Date());
            currStartDate = weekInfo.getStartDate();
            WeekInfo lastWeekInfo = DateUtils.getWeekInfo((Date)DateUtils.addDay((Date)currStartDate, (int)-1));
            lastStartDate = lastWeekInfo.getStartDate();
        } else {
            currStartDate = DateUtils.getFirstDayOfCurrentMonth();
            MonthInfo monthInfo = DateUtils.getLastMonthInfo();
            lastStartDate = monthInfo.getStartDate();
        }
        currStartDate = DateUtils.truncateDate((Date)currStartDate);
        QFilter qFilterDone = TaskIndexDataService.getTaskHistoryQFilter((Long)sscid, (Date)lastStartDate, (Date)currEndDate);
        QFilter qFilterWait = TaskIndexDataService.getTaskQFilter((Long)sscid);
        qFilterWait.and(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
        boolean isShowForLeader = this.ifShowLeaderHomePage();
        QFilter qFilterUser = TaskIndexDataService.getUserQFilter((Long)sscid, (long)usergroupId, (boolean)isShowForLeader, (boolean)this.isSysAdminAndAllRight());
        if (qFilterUser != null) {
            qFilterDone.and(qFilterUser);
            qFilterWait.and(qFilterUser);
        }
        ArrayList<Long> userIdList = new ArrayList<Long>();
        if (usergroupId == -1L) {
            userIdList.addAll(UserGroupService.getInstance().getGroupBosUsers(Long.valueOf(sscid)));
        } else {
            userIdList.addAll(UserGroupService.getInstance().getGroupBosUsers((Set)Sets.newHashSet((Object[])new Long[]{usergroupId})));
        }
        HashMap<Long, UserTaskSituaton> userTaskSituatonMap = new HashMap<Long, UserTaskSituaton>();
        DataSet waitingTaskDs = TaskRepository.getInstance().getTaskDataSet("id,coefficient,receivetime,personid", new QFilter[]{qFilterWait}, "receivetime asc").select(new String[]{"id", "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "receivetime", "personid"});
        DataSet doneTaskDs = TaskHistoryRepository.getInstance().getTaskHistoryDataSet("id,coefficient,receivetime,completetime,personid", new QFilter[]{qFilterDone}, null).select(new String[]{"id", "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "receivetime", "completetime", "personid"});
        if (waitingTaskDs != null) {
            try {
                for (Row row : waitingTaskDs) {
                    personId = row.getLong("personid");
                    userTaskSituaton2 = (UserTaskSituaton)userTaskSituatonMap.get(personId);
                    if (userTaskSituaton2 == null) {
                        userTaskSituaton2 = new UserTaskSituaton(personId.longValue());
                    }
                    if ((receivetime = row.getDate("receivetime")) != null && receivetime.compareTo(currStartDate) > 0) {
                        userTaskSituaton2.setCurrReceiveNum(userTaskSituaton2.getCurrReceiveNum() + row.getInteger("coefficient"));
                    } else {
                        userTaskSituaton2.setLastReceiveNum(userTaskSituaton2.getLastReceiveNum() + row.getInteger("coefficient"));
                    }
                    userTaskSituatonMap.put(personId, userTaskSituaton2);
                }
            }
            finally {
                waitingTaskDs.close();
            }
        }
        if (doneTaskDs != null) {
            try {
                for (Row row : doneTaskDs) {
                    personId = row.getLong("personid");
                    userTaskSituaton2 = (UserTaskSituaton)userTaskSituatonMap.get(personId);
                    if (userTaskSituaton2 == null) {
                        userTaskSituaton2 = new UserTaskSituaton(personId.longValue());
                    }
                    receivetime = row.getDate("receivetime");
                    Date completetime = row.getDate("completetime");
                    if (receivetime != null && receivetime.compareTo(currStartDate) > 0) {
                        userTaskSituaton2.setCurrReceiveNum(userTaskSituaton2.getCurrReceiveNum() + row.getInteger("coefficient"));
                    } else {
                        userTaskSituaton2.setLastReceiveNum(userTaskSituaton2.getLastReceiveNum() + row.getInteger("coefficient"));
                    }
                    if (completetime != null && completetime.compareTo(currStartDate) > 0) {
                        userTaskSituaton2.setCurrDoneNum(userTaskSituaton2.getCurrDoneNum() + row.getInteger("coefficient"));
                    } else {
                        userTaskSituaton2.setLastDoneNum(userTaskSituaton2.getLastDoneNum() + row.getInteger("coefficient"));
                    }
                    userTaskSituatonMap.put(personId, userTaskSituaton2);
                }
            }
            finally {
                doneTaskDs.close();
            }
        }
        this.showReceiveSituation(userTaskSituatonMap, userIdList);
        userTaskSituatonMap.values().forEach(userTaskSituaton -> {
            if (userTaskSituaton.getCurrReceiveNum() == 0 || userTaskSituaton.getCurrDoneNum() == 0) {
                userTaskSituaton.setCurrEfficiency(BigDecimal.ZERO);
            } else {
                userTaskSituaton.setCurrEfficiency(new BigDecimal(userTaskSituaton.getCurrDoneNum()).divide(new BigDecimal(userTaskSituaton.getCurrReceiveNum()), 2, 4));
            }
            if (userTaskSituaton.getLastReceiveNum() == 0 || userTaskSituaton.getLastDoneNum() == 0) {
                userTaskSituaton.setLastEfficiency(BigDecimal.ZERO);
            } else {
                userTaskSituaton.setLastEfficiency(new BigDecimal(userTaskSituaton.getLastDoneNum()).divide(new BigDecimal(userTaskSituaton.getLastReceiveNum()), 2, 4));
            }
        });
        this.showDoneSituation(userTaskSituatonMap, userIdList);
        this.showEfficiencySituation(userTaskSituatonMap, userIdList);
    }

    private void showReceiveSituation(Map<Long, UserTaskSituaton> userTaskSituatonMap, List<Long> userIdList) {
        UserTaskSituaton taskSituaton;
        BigDecimal receiveRatio;
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        UserTaskSituaton userTaskSituaton = userTaskSituatonMap.get(currUserId);
        if (userTaskSituaton == null) {
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRRECEIVENUM, (String)"0");
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLRECEIVERATIO, (String)"--");
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPUPRECEIVE, VECTORAPDOWNRECEIVE});
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRRECEIVETOP, (String)"0%");
            return;
        }
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRRECEIVENUM, (String)(userTaskSituaton.getCurrReceiveNum() + ""));
        if (userTaskSituaton.getCurrReceiveNum() == userTaskSituaton.getLastReceiveNum()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPUPRECEIVE, VECTORAPDOWNRECEIVE});
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLRECEIVERATIO, (String)"--");
        } else if (userTaskSituaton.getCurrReceiveNum() > userTaskSituaton.getLastReceiveNum()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{VECTORAPUPRECEIVE});
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPDOWNRECEIVE});
            if (userTaskSituaton.getLastReceiveNum() == 0) {
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLRECEIVERATIO, (String)"100%");
            } else {
                receiveRatio = new BigDecimal(userTaskSituaton.getCurrReceiveNum()).multiply(new BigDecimal("100")).divide(new BigDecimal(userTaskSituaton.getLastReceiveNum()), 2, 4);
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLRECEIVERATIO, (String)(receiveRatio + "%"));
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{VECTORAPDOWNRECEIVE});
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPUPRECEIVE});
            if (userTaskSituaton.getCurrReceiveNum() == 0) {
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLRECEIVERATIO, (String)"-100%");
            } else {
                receiveRatio = new BigDecimal(userTaskSituaton.getCurrReceiveNum()).multiply(new BigDecimal("100")).divide(new BigDecimal(userTaskSituaton.getLastReceiveNum()), 2, 4);
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLRECEIVERATIO, (String)("-" + receiveRatio + "%"));
            }
        }
        if (userTaskSituaton.getCurrReceiveNum() == 0) {
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRRECEIVETOP, (String)"0%");
            return;
        }
        int rankSeq = 1;
        List sortList = userTaskSituatonMap.values().stream().sorted((o1, o2) -> o2.getCurrReceiveNum() - o1.getCurrReceiveNum()).collect(Collectors.toList());
        Iterator iterator = sortList.iterator();
        while (iterator.hasNext() && (taskSituaton = (UserTaskSituaton)iterator.next()).getPersonid() != currUserId) {
            ++rankSeq;
        }
        int totalPersonNum = userIdList == null || userIdList.size() == 0 ? sortList.size() : userIdList.size();
        LOGGER.info("totalPersonNumL{}, rankSeq:{}", (Object)totalPersonNum, (Object)rankSeq);
        BigDecimal top = new BigDecimal(totalPersonNum - rankSeq).multiply(new BigDecimal("100")).divide(new BigDecimal(totalPersonNum), 0, 4);
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRRECEIVETOP, (String)(top + "%"));
    }

    private void showDoneSituation(Map<Long, UserTaskSituaton> userTaskSituatonMap, List<Long> userIdList) {
        UserTaskSituaton taskSituaton;
        BigDecimal doneratio;
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        UserTaskSituaton userTaskSituaton = userTaskSituatonMap.get(currUserId);
        if (userTaskSituaton == null) {
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRDONENUM, (String)"0");
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLDONERATIO, (String)"--");
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPUPDONE, VECTORAPDOWNDONE});
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRDONETOP, (String)"0%");
            return;
        }
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRDONENUM, (String)(userTaskSituaton.getCurrDoneNum() + ""));
        if (userTaskSituaton.getCurrDoneNum() == userTaskSituaton.getLastDoneNum()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPUPDONE, VECTORAPDOWNDONE});
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLDONERATIO, (String)"--");
        } else if (userTaskSituaton.getCurrDoneNum() > userTaskSituaton.getLastDoneNum()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{VECTORAPUPDONE});
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPDOWNDONE});
            if (userTaskSituaton.getLastReceiveNum() == 0) {
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLDONERATIO, (String)"100%");
            } else {
                doneratio = new BigDecimal(userTaskSituaton.getCurrReceiveNum()).multiply(new BigDecimal("100")).divide(new BigDecimal(userTaskSituaton.getLastReceiveNum()), 2, 4);
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLDONERATIO, (String)(doneratio + "%"));
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{VECTORAPDOWNDONE});
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPUPDONE});
            if (userTaskSituaton.getCurrReceiveNum() == 0) {
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLDONERATIO, (String)"-100%");
            } else {
                doneratio = new BigDecimal(userTaskSituaton.getCurrReceiveNum()).multiply(new BigDecimal("100")).divide(new BigDecimal(userTaskSituaton.getLastReceiveNum()), 2, 4);
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLDONERATIO, (String)("-" + doneratio + "%"));
            }
        }
        if (userTaskSituaton.getCurrDoneNum() == 0) {
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRDONETOP, (String)"0%");
            return;
        }
        int rankSeq = 1;
        List sortList = userTaskSituatonMap.values().stream().sorted((o1, o2) -> o2.getCurrDoneNum() - o1.getCurrDoneNum()).collect(Collectors.toList());
        Iterator iterator = sortList.iterator();
        while (iterator.hasNext() && (taskSituaton = (UserTaskSituaton)iterator.next()).getPersonid() != currUserId) {
            ++rankSeq;
        }
        int totalPersonNum = userIdList == null || userIdList.size() == 0 ? sortList.size() : userIdList.size();
        LOGGER.info("totalPersonNumL{}, rankSeq:{}", (Object)totalPersonNum, (Object)rankSeq);
        BigDecimal top = new BigDecimal(totalPersonNum - rankSeq).multiply(new BigDecimal("100")).divide(new BigDecimal(totalPersonNum), 0, 4);
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURRDONETOP, (String)(top + "%"));
    }

    private void showEfficiencySituation(Map<Long, UserTaskSituaton> userTaskSituatonMap, List<Long> userIdList) {
        UserTaskSituaton taskSituaton;
        BigDecimal doneratio;
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        UserTaskSituaton userTaskSituaton = userTaskSituatonMap.get(currUserId);
        if (userTaskSituaton == null) {
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURREFFICIENCY, (String)"0");
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLEFFICIENCYRATIO, (String)"--");
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPUPEFFICIENCY, VECTORAPDOWNEFFICIENCY});
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLEFFICIENCYTOP, (String)"0%");
            return;
        }
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLCURREFFICIENCY, (String)(userTaskSituaton.getCurrEfficiency() + ""));
        if (userTaskSituaton.getCurrDoneNum() == userTaskSituaton.getLastDoneNum()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPUPEFFICIENCY, VECTORAPDOWNEFFICIENCY});
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLEFFICIENCYRATIO, (String)"--");
        } else if (userTaskSituaton.getCurrDoneNum() > userTaskSituaton.getLastDoneNum()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{VECTORAPUPEFFICIENCY});
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPDOWNEFFICIENCY});
            if (userTaskSituaton.getLastReceiveNum() == 0) {
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLEFFICIENCYRATIO, (String)"100%");
            } else {
                doneratio = new BigDecimal(userTaskSituaton.getCurrReceiveNum()).multiply(new BigDecimal("100")).divide(new BigDecimal(userTaskSituaton.getLastReceiveNum()), 2, 4);
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLEFFICIENCYRATIO, (String)(doneratio + "%"));
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{VECTORAPDOWNEFFICIENCY});
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAPUPEFFICIENCY});
            if (userTaskSituaton.getCurrReceiveNum() == 0) {
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLEFFICIENCYRATIO, (String)"-100%");
            } else {
                doneratio = new BigDecimal(userTaskSituaton.getCurrReceiveNum()).multiply(new BigDecimal("100")).divide(new BigDecimal(userTaskSituaton.getLastReceiveNum()), 2, 4);
                ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLEFFICIENCYRATIO, (String)("-" + doneratio + "%"));
            }
        }
        if (BigDecimal.ZERO.compareTo(userTaskSituaton.getCurrEfficiency()) == 0) {
            ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLEFFICIENCYTOP, (String)"0%");
            return;
        }
        int rankSeq = 1;
        List sortList = userTaskSituatonMap.values().stream().sorted((o1, o2) -> o2.getCurrEfficiency().compareTo(o1.getCurrEfficiency())).collect(Collectors.toList());
        Iterator iterator = sortList.iterator();
        while (iterator.hasNext() && (taskSituaton = (UserTaskSituaton)iterator.next()).getPersonid() != currUserId) {
            ++rankSeq;
        }
        int totalPersonNum = userIdList == null || userIdList.size() == 0 ? sortList.size() : userIdList.size();
        LOGGER.info("totalPersonNumL{}, rankSeq:{}", (Object)totalPersonNum, (Object)rankSeq);
        BigDecimal top = new BigDecimal(totalPersonNum - rankSeq).multiply(new BigDecimal("100")).divide(new BigDecimal(totalPersonNum), 0, 4);
        ControlUtil.setLabelText((IFormView)this.getView(), (String)LBLEFFICIENCYTOP, (String)(top + "%"));
    }
}

