/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench;

import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.ssc.util.LogBuildUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.ssc.hstc.business.repository.TaskRepository;
import kd.ssc.hstc.business.service.TaskLevelService;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.common.TaskPoolTypeEnum;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.formplugin.web.common.TaskCommonService;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.util.ObjectUtils;

public class WbTodoTaskPlugin
extends WbCardCommonPlugin {
    private static final Log LOGGER = LogFactory.getLog(WbTodoTaskPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String LBL_MORE = "lblmore";
    private static final String ACTION_ASKTASK = "action_asktask";
    private static final int MAX_COUNT = 40;
    private static final String FLEXPANEL_ASK = "flexpanel_ask";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        QFilter qFilter = this.getListQFilter();
        DynamicObject[] taskInfos = TaskRepository.getInstance().loadTaskData("id,subject,expirestate,tasklevelid,firstreceivetime,creator", new QFilter[]{qFilter}, "tasklevelid.priority asc,receivetime asc", 41);
        this.initCardEntry(taskInfos);
        if (ObjectUtils.isNotEmpty((Object)taskInfos) && taskInfos.length > 40) {
            this.getView().setVisible(Boolean.TRUE, new String[]{LBL_MORE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{LBL_MORE});
        }
        long sscId = this.getSscId();
        QFilter sscIdFilter = new QFilter("sscid", "=", (Object)sscId);
        QFilter toDisFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        QFilter stateFilter = new QFilter("state", "in", (Object)new String[]{TaskStateEnum.TO_BE_DIS.getValue(), TaskStateEnum.DIS_EXCEPTION.getValue()});
        int countSSCId = TaskRepository.getInstance().countTask(new QFilter[]{sscIdFilter, toDisFilter, stateFilter});
        if (countSSCId > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANEL_ASK});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANEL_ASK});
        }
    }

    private void initCardEntry(DynamicObject[] taskInfos) {
        if (ObjectUtils.isEmpty((Object)taskInfos)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData(ENTRYENTITY);
            this.getView().updateView(ENTRYENTITY);
            return;
        }
        int priority = TaskLevelService.getInstance().getMinPriority(this.getSscId());
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("subject", new Object[0]);
        vs.addField("expirestate", new Object[0]);
        vs.addField("tasklevelid", new Object[0]);
        vs.addField("firstreceivetime", new Object[0]);
        vs.addField("creator", new Object[0]);
        int length = Math.min(taskInfos.length, 40);
        for (int i = 0; i < length; ++i) {
            DynamicObject taskInfo = taskInfos[i];
            vs.set("id", (Object)taskInfo.getLong("id"), i);
            vs.set("subject", (Object)taskInfo.getString("subject"), i);
            vs.set("expirestate", (Object)taskInfo.getString("expirestate"), i);
            vs.set("tasklevelid", (Object)taskInfo.getLong("tasklevelid.id"), i);
            vs.set("firstreceivetime", (Object)taskInfo.getDate("firstreceivetime"), i);
            vs.set("creator", (Object)taskInfo.getLong("creator.id"), i);
            if (taskInfo.getInt("tasklevelid.priority") <= priority) continue;
            cardEntry.setChildVisible(false, i, new String[]{"tasklevelid"});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        cardEntry.addHyperClickListener(hyperLinkClickEvent -> {
            String fieldName = hyperLinkClickEvent.getFieldName();
            if ("subject".equals(fieldName)) {
                int rowIndex = hyperLinkClickEvent.getRowIndex();
                long taskId = cardEntry.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex).getLong("id");
                DynamicObject taskInfo = TaskService.getInstance().getTaskById("id,tasktypeid.qualityjudge", taskId, true);
                if (taskInfo == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u72b6\u6001\u5df2\u53d8\u66f4\u3002", (String)"WbTodoTaskPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
                    cardEntry.getView().updateView();
                    return;
                }
                IFormView formView = cardEntry.getView();
                boolean ifProcessing = true;
                if ("4".equals(taskInfo.getString("tasktypeid.qualityjudge"))) {
                    TaskCommonService.getInstance().getDetailPageParameter(formView, taskId, ifProcessing);
                } else {
                    TaskCommonService.getInstance().getApproveDetailPageParameter(formView, taskId, ifProcessing);
                }
            }
        });
        this.addClickListeners(new String[]{LBL_MORE});
    }

    private QFilter getListQFilter() {
        long userId = RequestContext.getOrCreate().getCurrUserId();
        long sscId = this.getSscId();
        QFilter qFilter = new QFilter("personid", "=", (Object)userId);
        if (sscId != 0L) {
            qFilter.and(new QFilter("sscid", "=", (Object)sscId));
        }
        return qFilter;
    }

    public void click(EventObject evt) {
        Label label;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label && LBL_MORE.equals(key = (label = (Label)source).getKey())) {
            long sscId = this.getSscId();
            ListShowParameter showParameter = TaskCommonService.getInstance().getShowParameterTaskpool(sscId, true, "2", null);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("ask".equals(key)) {
            this.askTaskOp();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (ACTION_ASKTASK.equalsIgnoreCase(actionId)) {
            this.askTaskCallBack((Map)returnData);
        }
    }

    private void askTaskOp() {
        FormShowParameter parameEdit = new FormShowParameter();
        long sscId = this.getSscId();
        if (sscId == 0L) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u65e0\u5171\u4eab\u4e2d\u5fc3\u4e0d\u80fd\u83b7\u53d6\u4efb\u52a1\u3002", (String)"WbTodoTaskPlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
        } else {
            parameEdit.setFormId("task_taskask");
            parameEdit.getOpenStyle().setShowType(ShowType.Modal);
            parameEdit.setCustomParam("sscid.id", (Object)String.valueOf(sscId));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_ASKTASK);
            parameEdit.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameEdit);
        }
    }

    private void askTaskCallBack(Map<String, StringBuffer> dataMap) {
        if (dataMap != null) {
            if (dataMap.containsKey("success")) {
                StringBuffer local = dataMap.get("success");
                this.getView().showSuccessNotification(local.toString(), Integer.valueOf(3000));
            } else if (dataMap.containsKey("parent")) {
                StringBuffer local = dataMap.get("parent");
                this.getView().showTipNotification(local.toString(), Integer.valueOf(3000));
            } else if (dataMap.containsKey("local")) {
                StringBuffer local = dataMap.get("local");
                this.getView().showTipNotification(local.toString(), Integer.valueOf(3000));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u4efb\u52a1\u5931\u8d25\u3002", (String)"WbTodoTaskPlugin_4", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
                LOGGER.info("dataMap:{}", dataMap);
            }
            AppLogInfo logInfo = LogBuildUtil.buildLogInfo((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u83b7\u53d6\u4efb\u52a1\u64cd\u4f5c\u3002", (String)"WbTodoTaskPlugin_2", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), null, (String)"task_task", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u4efb\u52a1", (String)"WbTodoTaskPlugin_3", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            LogServiceHelper.addLog((AppLogInfo)logInfo);
        }
        this.getView().updateView();
    }
}

