/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench.admin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.task.TaskIndexDataService;
import kd.ssc.hstc.common.ExpireStateEnum;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.formplugin.web.workbench.WbCardCommonPlugin;
import kd.ssc.hstc.formplugin.web.workbench.common.DutyUserService;
import kd.ssc.hstc.formplugin.web.workbench.common.PersonInfo;
import kd.ssc.hstc.formplugin.web.workbench.common.ToDoTask;
import kd.ssc.hstc.formplugin.web.workbench.common.WorkBenchKDString;
import kd.ssc.hstc.util.ControlUtil;
import kd.ssc.hstc.util.DateUtils;

public class TaskDistributionPlugin
extends WbCardCommonPlugin
implements TabSelectListener {
    private static final Log LOGGER = LogFactory.getLog(TaskDistributionPlugin.class);
    private static final String TODONUM = "todonum";
    private static final String ADDNUM = "addnum";
    private static final String RESIDUENUM = "residuenum";
    private static final String AVGNUM = "avgnum";
    private static final String BILLTYPEENTRYENTITY = "billtypeentryentity";
    private static final String TASKBILLID = "taskbillid";
    private static final String TASKBILL = "taskbill";
    private static final String TASKBILLNUM = "taskbillnum";
    private static final String DISENTRYENTITY = "disentryentity";
    private static final String USERID = "userid";
    private static final String PICTUREFIELD = "picturefield";
    private static final String USERNAME = "username";
    private static final String DOINGNUM = "doingnum";
    private static final String PUSHNUM = "pushnum";
    private static final String OVERDUENUM = "overduenum";
    private static final String DONENUM = "donenum";
    private static final String ONDUTYTIME = "ondutytime";
    private static final String DUTYTAB = "dutytab";
    private static final String ONDUTYCACHE = "ondutyinfo";
    private static final String OFFDUTYCACHE = "offdutyinfo";
    private static final String CUSTOMCHARTAP = "customchartap";

    private QFilter getDefaultQFilter(long sscId, long userGroupId, Set<Long> userGroupIdSet) {
        QFilter ssc = new QFilter("sscid", "=", (Object)sscId);
        if (userGroupId > 0L) {
            ssc.and(new QFilter("usergroup", "=", (Object)userGroupId));
        } else {
            ssc.and(new QFilter("usergroup", "in", userGroupIdSet));
        }
        ssc.and(new QFilter("autoprocess", "=", (Object)"0"));
        ssc.and(new QFilter("qualitysamplelibrary.id", "=", (Object)0L));
        return ssc;
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        long sscId = this.getSscId();
        long userGroupId = this.getUsergroupId();
        Set<Long> userGroupIdSet = this.getUserGroupIdSet();
        QFilter defaultQFilter = this.getDefaultQFilter(sscId, userGroupId, userGroupIdSet);
        Date today = DateUtils.getTodayTruncate();
        Date preDate7 = DateUtils.truncateDate((Date)DateUtils.addDay((Date)today, (int)-7));
        DynamicObject[] taskArr = TaskService.getInstance().queryTask("id,personid,firstreceivetime,billtype,state,expirestate", new QFilter[]{defaultQFilter});
        QFilter firstReceiveTimeQFilter = new QFilter("firstreceivetime", ">=", (Object)preDate7);
        DynamicObject[] hisTaskArr = TaskService.getInstance().queryTaskHistory("id,personid,firstreceivetime,billtype,state,expirestate,completetime", new QFilter[]{defaultQFilter, firstReceiveTimeQFilter});
        Map<String, Tuple<List<PersonInfo>, List<PersonInfo>>> userOfDuty = DutyUserService.getInstance().getUserOfDuty(sscId, userGroupId, userGroupIdSet);
        HashMap<Long, ToDoTask> map = new HashMap<Long, ToDoTask>();
        this.dealWithTop(taskArr, userOfDuty, today, map);
        this.dealWithToDoTask(map);
        this.dealWithDistribution(taskArr, hisTaskArr, today, userOfDuty);
        this.dealWithChart(taskArr, hisTaskArr, today, userOfDuty);
    }

    private void dealWithChart(DynamicObject[] taskArr, DynamicObject[] hisTaskArr, Date today, Map<String, Tuple<List<PersonInfo>, List<PersonInfo>>> userOfDuty) {
        ArrayList<Map<String, String>> chartList = new ArrayList<Map<String, String>>(7);
        for (int ii = 0; ii < 7; ++ii) {
            Date firstReceiveTime;
            Date today0 = DateUtils.truncateDate((Date)DateUtils.addDay((Date)today, (int)(-ii)));
            Date today24 = DateUtils.truncateDate((Date)DateUtils.addDay((Date)today, (int)(1 + -ii)));
            String key = String.valueOf(ii);
            Date preDay0 = DateUtils.truncateDate((Date)DateUtils.addDay((Date)today, (int)(-ii - 1)));
            int add = 0;
            int done = 0;
            int process = 0;
            if (taskArr != null && taskArr.length > 0) {
                for (DynamicObject dy : taskArr) {
                    firstReceiveTime = dy.getDate("firstreceivetime");
                    if (firstReceiveTime != null && today0.compareTo(firstReceiveTime) <= 0 && firstReceiveTime.compareTo(today24) < 0) {
                        ++add;
                    }
                    String state = dy.getString("state");
                    if (!TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) || firstReceiveTime == null || firstReceiveTime.compareTo(today0) >= 0) continue;
                    ++process;
                }
            }
            if (hisTaskArr != null && hisTaskArr.length > 0) {
                for (DynamicObject dy : hisTaskArr) {
                    firstReceiveTime = dy.getDate("firstreceivetime");
                    Date completeTime = dy.getDate("completetime");
                    if (firstReceiveTime == null || firstReceiveTime.compareTo(today0) >= 0 || completeTime == null || completeTime.compareTo(preDay0) < 0) continue;
                    ++done;
                }
            }
            int onDuty = 0;
            Tuple<List<PersonInfo>, List<PersonInfo>> listListTuple = userOfDuty.get(key);
            if (listListTuple != null) {
                onDuty = this.onDutyToday((List)listListTuple.item1) + this.onDutyToday((List)listListTuple.item2);
            }
            HashMap<String, String> map = new HashMap<String, String>(5);
            map.put("weekday", this.getWeekDay(today0));
            map.put("addtoday", String.valueOf(add));
            map.put("yesterdayremain", String.valueOf(done + process));
            map.put("daysum", String.valueOf(add + done + process));
            BigDecimal avg = new BigDecimal("0.00");
            if (onDuty > 0) {
                avg = new BigDecimal(String.valueOf(add + done + process)).divide(new BigDecimal(String.valueOf(onDuty)), 2, RoundingMode.HALF_UP);
            }
            map.put("avg", avg.toPlainString());
            chartList.add(map);
        }
        this.setChartData(chartList);
    }

    private String getWeekDay(Date today0) {
        int weekDay = DateUtils.getWeekDay((Date)today0);
        String weekDayStr = "";
        switch (weekDay) {
            case 1: {
                weekDayStr = WorkBenchKDString.WeekDay7();
                break;
            }
            case 2: {
                weekDayStr = WorkBenchKDString.WeekDay1();
                break;
            }
            case 3: {
                weekDayStr = WorkBenchKDString.WeekDay2();
                break;
            }
            case 4: {
                weekDayStr = WorkBenchKDString.WeekDay3();
                break;
            }
            case 5: {
                weekDayStr = WorkBenchKDString.WeekDay4();
                break;
            }
            case 6: {
                weekDayStr = WorkBenchKDString.WeekDay5();
                break;
            }
            case 7: {
                weekDayStr = WorkBenchKDString.WeekDay6();
                break;
            }
        }
        return weekDayStr;
    }

    private void dealWithDistribution(DynamicObject[] taskArr, DynamicObject[] hisTaskArr, Date today, Map<String, Tuple<List<PersonInfo>, List<PersonInfo>>> userOfDuty) {
        Tuple<List<PersonInfo>, List<PersonInfo>> listListTuple;
        HashMap<Long, Integer> toDoMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> pauseMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> overdueMap = new HashMap<Long, Integer>();
        this.dealProcessTask(taskArr, toDoMap, pauseMap, overdueMap);
        HashMap<Long, Integer> doneMap = new HashMap<Long, Integer>();
        this.dealHisTask(hisTaskArr, today, doneMap);
        if (userOfDuty != null && !userOfDuty.isEmpty() && (listListTuple = userOfDuty.get("0")) != null) {
            List onDutyList = (List)listListTuple.item1;
            for (PersonInfo personInfo : onDutyList) {
                long uid = personInfo.getUid();
                personInfo.setTodoNum(toDoMap.getOrDefault(uid, 0));
                personInfo.setPauseNum(pauseMap.getOrDefault(uid, 0));
                personInfo.setOverdueNum(overdueMap.getOrDefault(uid, 0));
                personInfo.setDoneNum(doneMap.getOrDefault(uid, 0));
            }
            onDutyList.sort(new Comparator<PersonInfo>(){

                @Override
                public int compare(PersonInfo o1, PersonInfo o2) {
                    return Integer.compare(o2.getTodoNum(), o1.getTodoNum());
                }
            });
            String onDutyInfo = SerializationUtils.toJsonString((Object)onDutyList);
            this.getPageCache().put(ONDUTYCACHE, onDutyInfo);
            this.assignment(onDutyList);
            List offDutyList = (List)listListTuple.item2;
            for (PersonInfo personInfo : offDutyList) {
                long uid = personInfo.getUid();
                personInfo.setTodoNum(toDoMap.getOrDefault(uid, 0));
                personInfo.setOverdueNum(overdueMap.getOrDefault(uid, 0));
                personInfo.setPauseNum(pauseMap.getOrDefault(uid, 0));
                personInfo.setDoneNum(doneMap.getOrDefault(uid, 0));
            }
            offDutyList.sort(new Comparator<PersonInfo>(){

                @Override
                public int compare(PersonInfo o1, PersonInfo o2) {
                    return Integer.compare(o2.getTodoNum(), o1.getTodoNum());
                }
            });
            String info = SerializationUtils.toJsonString((Object)offDutyList);
            this.getPageCache().put(OFFDUTYCACHE, info);
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(DISENTRYENTITY);
        this.getView().updateView(DISENTRYENTITY);
    }

    private void assignment(List<PersonInfo> onDutyList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(DISENTRYENTITY);
        model.beginInit();
        if (onDutyList != null && !onDutyList.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"filedflex"});
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(USERID, new Object[0]);
            vs.addField(PICTUREFIELD, new Object[0]);
            vs.addField(USERNAME, new Object[0]);
            vs.addField(DOINGNUM, new Object[0]);
            vs.addField(PUSHNUM, new Object[0]);
            vs.addField(OVERDUENUM, new Object[0]);
            vs.addField(DONENUM, new Object[0]);
            vs.addField(ONDUTYTIME, new Object[0]);
            for (int ii = 0; ii < onDutyList.size(); ++ii) {
                PersonInfo personInfo = onDutyList.get(ii);
                vs.set(USERID, (Object)personInfo.getUid(), ii);
                vs.set(PICTUREFIELD, (Object)personInfo.getPicture(), ii);
                vs.set(USERNAME, (Object)personInfo.getUserName(), ii);
                vs.set(DOINGNUM, (Object)personInfo.getTodoNum(), ii);
                vs.set(PUSHNUM, (Object)personInfo.getPauseNum(), ii);
                vs.set(OVERDUENUM, (Object)personInfo.getOverdueNum(), ii);
                vs.set(DONENUM, (Object)personInfo.getDoneNum(), ii);
                vs.set(ONDUTYTIME, (Object)personInfo.getDutyTimeStr(), ii);
            }
            model.batchCreateNewEntryRow(DISENTRYENTITY, vs);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filedflex"});
        }
        model.endInit();
        this.getView().updateView(DISENTRYENTITY);
    }

    private void dealWithToDoTask(Map<Long, ToDoTask> map) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(BILLTYPEENTRYENTITY);
        model.beginInit();
        if (map != null && !map.isEmpty()) {
            ArrayList<ToDoTask> list = new ArrayList<ToDoTask>(map.size());
            Set<Map.Entry<Long, ToDoTask>> entries = map.entrySet();
            Iterator<Map.Entry<Long, ToDoTask>> iterator = entries.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next().getValue());
            }
            list.sort(new Comparator<ToDoTask>(){

                @Override
                public int compare(ToDoTask o1, ToDoTask o2) {
                    return Integer.compare(o2.getNum(), o1.getNum());
                }
            });
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(TASKBILLID, new Object[0]);
            vs.addField(TASKBILL, new Object[0]);
            vs.addField(TASKBILLNUM, new Object[0]);
            for (int ii = 0; ii < list.size(); ++ii) {
                ToDoTask toDoTask = (ToDoTask)list.get(ii);
                vs.set(TASKBILLID, (Object)toDoTask.getId(), ii);
                vs.set(TASKBILL, (Object)toDoTask.getName(), ii);
                vs.set(TASKBILLNUM, (Object)toDoTask.getNum(), ii);
            }
            model.batchCreateNewEntryRow(BILLTYPEENTRYENTITY, vs);
        }
        model.endInit();
        this.getView().updateView(BILLTYPEENTRYENTITY);
    }

    private void dealWithTop(DynamicObject[] taskArr, Map<String, Tuple<List<PersonInfo>, List<PersonInfo>>> userOfDuty, Date today, Map<Long, ToDoTask> map) {
        int sum = 0;
        int add = 0;
        int residue = 0;
        BigDecimal avg = BigDecimal.ZERO;
        int dutyToday = 0;
        Tuple<List<PersonInfo>, List<PersonInfo>> listListTuple = userOfDuty.get("0");
        if (listListTuple != null) {
            dutyToday = this.onDutyToday((List)listListTuple.item1) + this.onDutyToday((List)listListTuple.item2);
        }
        if (taskArr != null && taskArr.length > 0) {
            for (DynamicObject dy : taskArr) {
                DynamicObject billType;
                String state = dy.getString("state");
                boolean toDo = TaskStateEnum.TO_BE_AUDIT.getValue().equals(state);
                if (!toDo) continue;
                Date firstReceiveTime = dy.getDate("firstreceivetime");
                if (firstReceiveTime != null && firstReceiveTime.compareTo(today) >= 0) {
                    ++add;
                }
                if (firstReceiveTime != null && firstReceiveTime.compareTo(today) < 0) {
                    ++residue;
                }
                if ((billType = dy.getDynamicObject("billtype")) == null) continue;
                long id = billType.getLong("id");
                ToDoTask toDoTask = map.getOrDefault(id, new ToDoTask());
                toDoTask.setId(id);
                toDoTask.setName(billType.getString("name"));
                toDoTask.setNum(toDoTask.getNum() + 1);
                map.put(id, toDoTask);
            }
        }
        sum = add + residue;
        if (dutyToday > 0) {
            avg = new BigDecimal(String.valueOf(sum)).divide(new BigDecimal(String.valueOf(dutyToday)), 2, RoundingMode.HALF_UP);
        }
        ControlUtil.setLabelText((IFormView)this.getView(), (String)TODONUM, (String)String.valueOf(sum));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)ADDNUM, (String)String.valueOf(add));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)RESIDUENUM, (String)String.valueOf(residue));
        ControlUtil.setLabelText((IFormView)this.getView(), (String)AVGNUM, (String)avg.toPlainString());
    }

    private void dealProcessTask(DynamicObject[] taskArr, Map<Long, Integer> toDoMap, Map<Long, Integer> pauseMap, Map<Long, Integer> overdueMap) {
        if (taskArr != null && taskArr.length > 0) {
            for (DynamicObject dy : taskArr) {
                boolean pause;
                boolean overdue;
                DynamicObject person = dy.getDynamicObject("personid");
                if (person == null) continue;
                long userId = person.getLong("id");
                String state = dy.getString("state");
                boolean toDo = TaskStateEnum.TO_BE_AUDIT.getValue().equals(state);
                if (toDo) {
                    Integer orDefault = toDoMap.getOrDefault(userId, 0);
                    orDefault = orDefault + 1;
                    toDoMap.put(userId, orDefault);
                }
                if (overdue = ExpireStateEnum.OVERDUE.getValue().equals(dy.getString("expirestate"))) {
                    Integer overdueNum = overdueMap.getOrDefault(userId, 0);
                    overdueNum = overdueNum + 1;
                    overdueMap.put(userId, overdueNum);
                }
                if (!(pause = TaskStateEnum.PAUSE.getValue().equals(state))) continue;
                Integer orDefault = pauseMap.getOrDefault(userId, 0);
                orDefault = orDefault + 1;
                pauseMap.put(userId, orDefault);
            }
        }
    }

    private void dealHisTask(DynamicObject[] hisTaskArr, Date today, Map<Long, Integer> doneMap) {
        if (hisTaskArr != null && hisTaskArr.length > 0) {
            HashSet<String> stateSet = new HashSet<String>();
            stateSet.add(TaskStateEnum.AUDIT_PASSED.getValue());
            stateSet.add(TaskStateEnum.AUDIT_NOTPASSED.getValue());
            stateSet.add(TaskStateEnum.PROCESSED.getValue());
            for (DynamicObject dy : hisTaskArr) {
                DynamicObject person = dy.getDynamicObject("personid");
                if (person == null) continue;
                Date firstReceiveTime = dy.getDate("firstreceivetime");
                String state = dy.getString("state");
                if (firstReceiveTime == null || firstReceiveTime.compareTo(today) < 0 || !stateSet.contains(state)) continue;
                long userId = person.getLong("id");
                Integer orDefault = doneMap.getOrDefault(userId, 0);
                orDefault = orDefault + 1;
                doneMap.put(userId, orDefault);
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getControl(DUTYTAB);
        tab.addTabSelectListener((TabSelectListener)this);
        HashMap paramMap = new HashMap();
        CardEntry disCardEntry = (CardEntry)this.getView().getControl(DISENTRYENTITY);
        disCardEntry.addHyperClickListener(hyperLinkClickEvent -> {
            String fieldName = hyperLinkClickEvent.getFieldName();
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            String userId = disCardEntry.getModel().getEntryRowEntity(DISENTRYENTITY, rowIndex).getString(USERID);
            IFormView formView = disCardEntry.getView();
            QFilter qFilter = null;
            String poolType = null;
            String pause = null;
            if (DOINGNUM.equals(fieldName)) {
                qFilter = new QFilter("state", "=", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
                poolType = "1";
            } else if (PUSHNUM.equals(fieldName)) {
                poolType = "1";
                pause = "0";
                qFilter = new QFilter("state", "=", (Object)TaskStateEnum.PAUSE.getValue());
            } else if (OVERDUENUM.equals(fieldName)) {
                poolType = "1";
                qFilter = new QFilter("expirestate", "=", (Object)ExpireStateEnum.OVERDUE.getValue());
            } else {
                return;
            }
            if (StringUtils.isNotEmpty((String)userId)) {
                qFilter.and(new QFilter("personid", "=", (Object)Long.parseLong(userId)));
            }
            this.showTaskAdministrateList(formView, poolType, qFilter, paramMap, null, pause);
        });
        CardEntry billCardEntry = (CardEntry)this.getView().getControl(BILLTYPEENTRYENTITY);
        billCardEntry.addHyperClickListener(hyperLinkClickEvent -> {
            String fieldName = hyperLinkClickEvent.getFieldName();
            if (TASKBILLNUM.equals(fieldName)) {
                int rowIndex = hyperLinkClickEvent.getRowIndex();
                String billTypeId = billCardEntry.getModel().getEntryRowEntity(BILLTYPEENTRYENTITY, rowIndex).getString(TASKBILLID);
                if (StringUtils.isNotEmpty((String)billTypeId)) {
                    QFilter qFilter = new QFilter("billtype", "=", (Object)Long.parseLong(billTypeId));
                    IFormView formView = billCardEntry.getView();
                    this.showTaskAdministrateList(formView, "1", qFilter, paramMap, billTypeId, null);
                }
            }
        });
    }

    private void showTaskAdministrateList(IFormView formView, String poolType, QFilter qFilter, Map<String, Object> paramMap, String billTypeId, String pause) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("task_administrate");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId("task_task");
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u7ba1\u7406", (String)"WbMyTaskAdminPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParams(paramMap);
        showParameter.setCustomParam("ServiceAppId", (Object)"ssc");
        if (StringUtils.isNotEmpty((String)poolType)) {
            showParameter.setCustomParam("pooltype", (Object)poolType);
        }
        showParameter.setCustomParam("billtypeid", (Object)billTypeId);
        if (StringUtils.isNotEmpty((String)pause)) {
            showParameter.setCustomParam("state", (Object)pause);
        }
        showParameter.setCustomParam("sscid", (Object)this.getSscId());
        long userGroupId = this.getUsergroupId();
        showParameter.setCustomParam("usergroupid", (Object)userGroupId);
        showParameter.setCustomParam("sources", (Object)"TaskBusinessManageIndexPlugin");
        if (qFilter != null) {
            qFilter.and(new QFilter("qualitysamplelibrary", "=", (Object)0L));
            showParameter.setCustomParam("qfilter", (Object)qFilter.toSerializedString());
        }
        showParameter.setHasRight(true);
        formView.showForm((FormShowParameter)showParameter);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        String cacheInfo = this.getPageCache().get(tabKey);
        List onDutyList = null;
        if (StringUtils.isNotEmpty((String)cacheInfo)) {
            onDutyList = SerializationUtils.fromJsonStringToList((String)cacheInfo, PersonInfo.class);
            this.assignment(onDutyList);
        } else {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData(DISENTRYENTITY);
            this.getView().updateView(DISENTRYENTITY);
        }
    }

    private void setChartData(List<Map<String, String>> chartList) {
        Chart customChart = (Chart)this.getControl(CUSTOMCHARTAP);
        customChart.clearData();
        if (chartList.isEmpty()) {
            customChart.bindData(null);
            return;
        }
        customChart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
        customChart.setShowTooltip(true);
        Axis xAxis = customChart.createXAxis(null, AxisType.category);
        ArrayList<String> xDimensions = new ArrayList<String>(chartList.size());
        Integer[] num = new Integer[chartList.size()];
        Integer[] add = new Integer[chartList.size()];
        Integer[] remain = new Integer[chartList.size()];
        BigDecimal[] avg = new BigDecimal[chartList.size()];
        for (int ii = chartList.size() - 1; ii >= 0; --ii) {
            Map<String, String> map = chartList.get(ii);
            xDimensions.add(map.get("weekday"));
            int index = chartList.size() - 1 - ii;
            num[index] = Integer.valueOf(map.get("daysum"));
            add[index] = Integer.valueOf(map.get("addtoday"));
            remain[index] = Integer.valueOf(map.get("yesterdayremain"));
            avg[index] = new BigDecimal(map.get("avg"));
        }
        xAxis.setCategorys(xDimensions);
        this.setY(customChart, num);
        this.setSum(customChart, add, remain);
        this.setLineSeries(customChart, avg);
        customChart.refresh();
    }

    private void setY(Chart customChart, Integer[] num) {
        Axis taskAmountAxis = customChart.createYAxis(WorkBenchKDString.billName(), AxisType.value);
        int currMaxValue = Collections.max(Arrays.asList(num));
        int yMaxValue = TaskIndexDataService.getBaseYMaxValue((int)currMaxValue);
        taskAmountAxis.setMax((Number)yMaxValue);
        taskAmountAxis.setInterval((Number)(yMaxValue / 5));
        HashMap<String, Comparable<Boolean>> axisTick = new HashMap<String, Comparable<Boolean>>();
        axisTick.put("show", Boolean.FALSE);
        axisTick.put("alignWithLabel", Boolean.TRUE);
        axisTick.put("interval", Integer.valueOf(1));
        taskAmountAxis.setPropValue("axisLine", axisTick);
        taskAmountAxis.setPropValue("nameLocation", (Object)"end");
        taskAmountAxis.setPropValue("axisTick", axisTick);
        HashMap<String, Object> nameTextStyle = new HashMap<String, Object>();
        nameTextStyle.put("align", "left");
        nameTextStyle.put("padding", new Integer[]{0, 0, 0, -18});
        taskAmountAxis.setPropValue("nameTextStyle", nameTextStyle);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#666666");
        HashMap<String, HashMap<String, String>> axisLineMap = new HashMap<String, HashMap<String, String>>();
        axisLineMap.put("lineStyle", lineStyleMap);
        taskAmountAxis.setPropValue("axisLine", axisLineMap);
    }

    private void setLineSeries(Chart customChart, BigDecimal[] avg) {
        String avgName = WorkBenchKDString.avgName();
        LineSeries lineSeries = customChart.createLineSeries(avgName);
        lineSeries.setData((Number[])avg);
        lineSeries.setLineColor("#FF991C");
        lineSeries.setItemColor("#FF991C");
    }

    private void setSum(Chart customChart, Integer[] add, Integer[] remain) {
        String stack = "distack";
        String addName = WorkBenchKDString.addName();
        BarSeries barSeries = customChart.createBarSeries(addName);
        barSeries.setBarWidth("20%");
        barSeries.setColor("#40A9FF");
        barSeries.setData((Number[])add);
        barSeries.getLabel().setShow(false);
        barSeries.setColor("#40A9FF");
        barSeries.setStack(stack);
        String remainName = WorkBenchKDString.remainName();
        BarSeries barSeries2 = customChart.createBarSeries(remainName);
        barSeries2.setBarWidth("20%");
        barSeries2.setData((Number[])remain);
        barSeries2.getLabel().setShow(false);
        barSeries2.setColor("#35CFC6");
        barSeries2.setStack(stack);
        customChart.setShowTooltip(true);
    }

    private int onDutyToday(List<PersonInfo> item) {
        int onDuty = 0;
        for (PersonInfo personInfo : item) {
            if (personInfo.getDutyTimeOfGroup() <= 0 && personInfo.getDutyTime() <= 0) continue;
            ++onDuty;
        }
        return onDuty;
    }
}

