/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.workbench.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.hstc.business.service.UserGroupService;
import kd.ssc.hstc.business.service.WorkCalendarService;
import kd.ssc.hstc.formplugin.web.workbench.common.PersonInfo;
import kd.ssc.hstc.formplugin.web.workbench.common.WorkBenchKDString;
import org.apache.commons.lang3.time.DateUtils;

public class DutyUserService {
    private static final Log LOG = LogFactory.getLog(DutyUserService.class);
    private SimpleDateFormat SDFTIME = new SimpleDateFormat("HH:mm");
    private SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");

    public static DutyUserService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public Map<String, Tuple<List<PersonInfo>, List<PersonInfo>>> getUserOfDuty(Long sscId, Long groupId, Set<Long> userGroupIdSet) {
        HashMap<String, Tuple<List<PersonInfo>, List<PersonInfo>>> result = new HashMap<String, Tuple<List<PersonInfo>, List<PersonInfo>>>(7);
        DynamicObject[] groupArr = this.getUserGroup(groupId, userGroupIdSet);
        if (groupArr == null || groupArr.length == 0) {
            return result;
        }
        HashSet<Long> userIdSet = new HashSet<Long>();
        List<PersonInfo> list = this.getUserListByGroupId(groupArr, userIdSet);
        if (list.isEmpty()) {
            return result;
        }
        Map<String, List<PersonInfo>> map = this.calculateTime(sscId, groupArr, userIdSet);
        Set<Map.Entry<String, List<PersonInfo>>> entries = map.entrySet();
        for (Map.Entry<String, List<PersonInfo>> next : entries) {
            String index = next.getKey();
            List<PersonInfo> personList = next.getValue();
            ArrayList<PersonInfo> left = new ArrayList<PersonInfo>();
            ArrayList<PersonInfo> right = new ArrayList<PersonInfo>();
            if (personList != null && !personList.isEmpty()) {
                for (PersonInfo personInfo : personList) {
                    this.setDutyTimeStr(personInfo);
                    boolean workStatus = personInfo.getWorkStatus();
                    if (workStatus) {
                        left.add(personInfo);
                        continue;
                    }
                    right.add(personInfo);
                }
            }
            result.put(index, (Tuple<List<PersonInfo>, List<PersonInfo>>)new Tuple(left, right));
        }
        return result;
    }

    private int diffTime(Date beginTime, Date endTime, Date nowTime) {
        if (nowTime == null) {
            long diff = kd.ssc.hstc.util.DateUtils.diffTime((Date)beginTime, (Date)endTime);
            return (int)(diff / 1000L);
        }
        long diff = kd.ssc.hstc.util.DateUtils.diffTime((Date)beginTime, (Date)endTime, (Date)nowTime);
        if (diff < 0L) {
            return 0;
        }
        return (int)(diff / 1000L);
    }

    private int workTime(Date amStart, Date amEnd, Date pmStart, Date pmEnd, Date nowTime) {
        int time = 0;
        if (amStart != null && amEnd != null) {
            time = this.diffTime(amStart, amEnd, nowTime);
        }
        if (pmStart != null && pmEnd != null) {
            time += this.diffTime(pmStart, pmEnd, nowTime);
        }
        return time;
    }

    private List<PersonInfo> getUserListByGroupId(DynamicObject[] groupArr, Set<Long> userIdSet) {
        ArrayList<PersonInfo> userList = new ArrayList<PersonInfo>(16);
        for (DynamicObject group : groupArr) {
            DynamicObjectCollection groupUsers = group.getDynamicObjectCollection("entryentity");
            for (DynamicObject groupUser : groupUsers) {
                DynamicObject user;
                long userId;
                Object userO = groupUser.get("userfield");
                boolean status = groupUser.getBoolean("usestatus");
                if (userO == null || !status || userIdSet.contains(userId = (user = (DynamicObject)userO).getLong("id"))) continue;
                userIdSet.add(userId);
                PersonInfo personInfo = new PersonInfo();
                personInfo.setUid(user.getLong("id"));
                personInfo.setUserName(user.getString("name"));
                userList.add(personInfo);
            }
        }
        return userList;
    }

    private Map<String, List<PersonInfo>> calculateTime(Long sscId, DynamicObject[] groupArr, Set<Long> userIdSet) {
        DynamicObject orgTimezone = InteServiceHelper.getOrgTimezone((Long)sscId);
        String zoneTimeNumber = null;
        if (orgTimezone != null) {
            zoneTimeNumber = orgTimezone.getString("number");
        }
        Calendar now = Calendar.getInstance();
        Date date = now.getTime();
        HashMap<String, List<PersonInfo>> map = new HashMap<String, List<PersonInfo>>();
        try {
            LOG.info("DutyUserService.calculateTime zoneTimeNumber={}", (Object)zoneTimeNumber);
            Date nowDate = this.SDF.parse(this.SDF.format(date));
            int hour = now.get(11);
            int minute = now.get(12);
            LOG.info("DutyUserService.calculateTime hour={},minute={}", (Object)hour, (Object)minute);
            Date nowTime = this.SDFTIME.parse(kd.ssc.hstc.util.DateUtils.getTimeShow((int)(hour * 60 * 60 + minute * 60)));
            Date preDate6 = kd.ssc.hstc.util.DateUtils.truncateDate((Date)kd.ssc.hstc.util.DateUtils.addDay((Date)nowDate, (int)-6));
            Set<Long> groupIdSet = Arrays.stream(groupArr).map(dd -> dd.getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection sscCollAll = this.getData(sscId, null, preDate6, null);
            DynamicObjectCollection groupCollAll = this.getData(sscId, groupIdSet, preDate6, null);
            DynamicObjectCollection userCollAll = this.getData(sscId, groupIdSet, preDate6, userIdSet);
            for (int ii = 0; ii < 7; ++ii) {
                Date curDate = kd.ssc.hstc.util.DateUtils.truncateDate((Date)kd.ssc.hstc.util.DateUtils.addDay((Date)nowDate, (int)(-ii)));
                ArrayList pList = new ArrayList(16);
                HashMap<Long, PersonInfo> userMap = new HashMap<Long, PersonInfo>();
                for (DynamicObject group : groupArr) {
                    this.dealWithGroup(group, userMap, curDate, nowTime, ii, sscCollAll, groupCollAll, userCollAll);
                }
                Set entries = userMap.entrySet();
                for (Map.Entry next : entries) {
                    pList.add(next.getValue());
                }
                map.put(String.valueOf(ii), pList);
            }
        }
        catch (Exception e) {
            LOG.info("DutyUserService.calculateTime error={}", (Object)e);
        }
        return map;
    }

    private void dealWithGroup(DynamicObject group, Map<Long, PersonInfo> userMap, Date curDate, Date nowTime, int ii, DynamicObjectCollection sscCollAll, DynamicObjectCollection groupCollAll, DynamicObjectCollection userCollAll) throws ParseException {
        long groupId = group.getLong("id");
        DynamicObjectCollection groupUsers = group.getDynamicObjectCollection("entryentity");
        for (DynamicObject groupUser : groupUsers) {
            Object userO = groupUser.get("userfield");
            boolean status = groupUser.getBoolean("usestatus");
            if (userO == null || !status) continue;
            DynamicObject user = (DynamicObject)userO;
            long userId = user.getLong("id");
            PersonInfo personInfo = this.getPersonInfo(userMap, user, userId);
            List<DynamicObject> userList = this.getData(userCollAll, "3", curDate, groupId, userId);
            this.dealDutyTimeOfUser(userList, personInfo, nowTime, ii);
            List<DynamicObject> groupList = this.getData(groupCollAll, "2", curDate, groupId, userId);
            boolean haveGroup = this.dealDutyTime(groupList, personInfo, nowTime, true, ii);
            if (!haveGroup) {
                List<DynamicObject> sscList = this.getData(sscCollAll, "1", curDate, groupId, userId);
                this.dealDutyTime(sscList, personInfo, nowTime, false, ii);
            }
            userMap.put(userId, personInfo);
        }
    }

    private boolean dealDutyTime(List<DynamicObject> calendarList, PersonInfo personInfo, Date nowTime, boolean isGroup, int ii) throws ParseException {
        if (calendarList.isEmpty()) {
            personInfo.setWorkStatus(false);
            return false;
        }
        boolean isWork = false;
        int dutyTime = 0;
        for (DynamicObject obj : calendarList) {
            String dateType = obj.getString("dateentry.datetype");
            Date amStart = this.tranDate(obj, "dateentry.timeentry.begintimeam");
            Date amEnd = this.tranDate(obj, "dateentry.timeentry.endtimeam");
            Date pmStart = this.tranDate(obj, "dateentry.timeentry.begintimepm");
            Date pmEnd = this.tranDate(obj, "dateentry.timeentry.endtimepm");
            if ("1".equals(dateType)) {
                if (ii == 0) {
                    if (kd.ssc.hstc.util.DateUtils.belongTime((Date)amStart, (Date)amEnd, (Date)nowTime) || kd.ssc.hstc.util.DateUtils.belongTime((Date)pmStart, (Date)pmEnd, (Date)nowTime)) {
                        isWork = true;
                    }
                    dutyTime += this.workTime(amStart, amEnd, pmStart, pmEnd, nowTime);
                    continue;
                }
                dutyTime += this.workTime(amStart, amEnd, pmStart, pmEnd, null);
                continue;
            }
            if ("5".equals(dateType)) {
                if (ii == 0) {
                    if (kd.ssc.hstc.util.DateUtils.belongTime((Date)amStart, (Date)amEnd, (Date)nowTime)) {
                        isWork = true;
                    }
                    dutyTime += this.workTime(amStart, amEnd, null, null, nowTime);
                    continue;
                }
                dutyTime += this.workTime(amStart, amEnd, null, null, null);
                continue;
            }
            if (!"6".equals(dateType)) continue;
            if (ii == 0) {
                boolean pmf = kd.ssc.hstc.util.DateUtils.belongTime((Date)pmStart, (Date)pmEnd, (Date)nowTime);
                if (pmf) {
                    isWork = true;
                }
                dutyTime += this.workTime(null, null, pmStart, pmEnd, nowTime);
                continue;
            }
            dutyTime += this.workTime(null, null, pmStart, pmEnd, null);
        }
        if (!personInfo.getWorkStatus()) {
            personInfo.setWorkStatus(isWork);
        }
        int userTime = personInfo.getDutyTimeOfUser();
        if (isGroup) {
            int dutyTimeOfGroup = personInfo.getDutyTimeOfGroup();
            if (dutyTimeOfGroup < (dutyTime += userTime)) {
                personInfo.setDutyTimeOfGroup(dutyTime);
            }
            personInfo.setDutyTimeOfUser(0);
            personInfo.setHaveGroup(true);
        } else {
            int dutyTimeOfSsc = personInfo.getDutyTime();
            if (dutyTimeOfSsc < (dutyTime += userTime)) {
                personInfo.setDutyTime(dutyTime);
            }
            personInfo.setDutyTimeOfUser(0);
        }
        return true;
    }

    private boolean dealDutyTimeOfUser(List<DynamicObject> userList, PersonInfo personInfo, Date nowTime, int ii) throws ParseException {
        if (userList.isEmpty()) {
            personInfo.setWorkStatus(false);
            return false;
        }
        boolean isWork = false;
        int dutyTime = 0;
        for (DynamicObject obj : userList) {
            String timeType = obj.getString("dateentry.timeentry.timetype");
            Date amStart = this.tranDate(obj, "dateentry.timeentry.begintimeam");
            Date amEnd = this.tranDate(obj, "dateentry.timeentry.endtimeam");
            Date pmStart = this.tranDate(obj, "dateentry.timeentry.begintimepm");
            Date pmEnd = this.tranDate(obj, "dateentry.timeentry.endtimepm");
            if ("2".equals(timeType)) {
                int vaTime;
                if (ii == 0) {
                    if (amStart != null && amEnd != null && kd.ssc.hstc.util.DateUtils.belongTime((Date)amStart, (Date)amEnd, (Date)nowTime)) {
                        isWork = false;
                    }
                    if (pmStart != null && pmEnd != null && kd.ssc.hstc.util.DateUtils.belongTime((Date)pmStart, (Date)pmEnd, (Date)nowTime)) {
                        isWork = false;
                    }
                    vaTime = this.workTime(amStart, amEnd, pmStart, pmEnd, nowTime);
                    LOG.info("DutyUserService.dealDutyTimeOfUser user_vatime={}", (Object)vaTime);
                    dutyTime += -vaTime;
                    continue;
                }
                vaTime = this.workTime(amStart, amEnd, pmStart, pmEnd, null);
                dutyTime += -vaTime;
                continue;
            }
            if (!"3".equals(timeType)) continue;
            if (ii == 0) {
                if (amStart != null && amEnd != null && kd.ssc.hstc.util.DateUtils.belongTime((Date)amStart, (Date)amEnd, (Date)nowTime)) {
                    isWork = true;
                }
                if (pmStart != null && pmEnd != null && kd.ssc.hstc.util.DateUtils.belongTime((Date)pmStart, (Date)pmEnd, (Date)nowTime)) {
                    isWork = true;
                }
                int otTime = this.workTime(amStart, amEnd, pmStart, pmEnd, nowTime);
                LOG.info("DutyUserService.dealDutyTimeOfUser user_otTime={}", (Object)otTime);
                dutyTime += otTime;
                continue;
            }
            dutyTime += this.workTime(amStart, amEnd, pmStart, pmEnd, null);
        }
        personInfo.setWorkStatus(isWork);
        personInfo.setDutyTimeOfUser(dutyTime);
        return true;
    }

    private Date tranDate(DynamicObject obj, String key) throws ParseException {
        String time = obj.getString(key);
        if (StringUtils.isEmpty((String)time)) {
            return null;
        }
        return this.SDFTIME.parse(time);
    }

    private DynamicObjectCollection getData(Long orgId, Set<Long> groupIdSet, Date preDate6, Set<Long> userIdSet) {
        QFilter filters = new QFilter("ssccenter", "=", (Object)orgId);
        if (groupIdSet != null && !groupIdSet.isEmpty() && userIdSet == null) {
            filters.and(new QFilter("dateentry.usergroup", "in", groupIdSet));
            filters.and(new QFilter("dateentry.level", "=", (Object)"2"));
        } else if (groupIdSet != null && userIdSet != null) {
            filters.and(new QFilter("dateentry.user", "in", userIdSet));
            filters.and(new QFilter("dateentry.usergroup", "in", groupIdSet));
            filters.and(new QFilter("dateentry.level", "=", (Object)"3"));
        } else {
            filters.and(new QFilter("dateentry.level", "=", (Object)"1"));
        }
        filters.and(new QFilter("dateentry.date", ">=", (Object)preDate6));
        return WorkCalendarService.getInstance().queryData("id,dateentry.id,dateentry.date,dateentry.level,dateentry.ssc,dateentry.usergroup,dateentry.datetype,dateentry.user,dateentry.timeentry.*", new QFilter[]{filters});
    }

    private List<DynamicObject> getData(DynamicObjectCollection coll, String level, Date curDate, long groupId, long userId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (coll == null || coll.isEmpty()) {
            return list;
        }
        for (DynamicObject dy : coll) {
            long userGroup;
            if (!DateUtils.isSameDay((Date)dy.getDate("dateentry.date"), (Date)curDate)) continue;
            if ("1".equals(level)) {
                list.add(dy);
                continue;
            }
            if ("2".equals(level)) {
                userGroup = dy.getLong("dateentry.usergroup");
                if (!String.valueOf(groupId).equals(String.valueOf(userGroup))) continue;
                list.add(dy);
                continue;
            }
            if (!"3".equals(level)) continue;
            userGroup = dy.getLong("dateentry.usergroup");
            long user = dy.getLong("dateentry.user");
            if (!String.valueOf(groupId).equals(String.valueOf(userGroup)) || !String.valueOf(user).equals(String.valueOf(userId))) continue;
            list.add(dy);
        }
        return list;
    }

    private DynamicObject[] getUserGroup(Long groupId, Set<Long> userGroupIdSet) {
        HashSet<Long> userGroupIdSet2 = new HashSet<Long>();
        if (groupId > 0L) {
            userGroupIdSet2.add(groupId);
        } else {
            userGroupIdSet2.addAll(userGroupIdSet);
        }
        return UserGroupService.getInstance().queryUserGroupById(userGroupIdSet2);
    }

    private PersonInfo getPersonInfo(Map<Long, PersonInfo> userMap, DynamicObject user, long userId) {
        PersonInfo personInfo = userMap.get(userId);
        if (personInfo == null) {
            personInfo = new PersonInfo();
            personInfo.setUid(user.getLong("id"));
            personInfo.setUserName(user.getString("name"));
            personInfo.setPicture(user.getString("picturefield"));
        }
        return personInfo;
    }

    private void setDutyTimeStr(PersonInfo personInfo) {
        if (personInfo.isHaveGroup()) {
            int dutyTimeOfGroup = personInfo.getDutyTimeOfGroup();
            personInfo.setDutyTimeStr(this.getDutyTimeStr(personInfo, dutyTimeOfGroup));
            return;
        }
        int dutyTime = personInfo.getDutyTime();
        personInfo.setDutyTimeStr(this.getDutyTimeStr(personInfo, dutyTime));
    }

    private String getDutyTimeStr(PersonInfo personInfo, int dutyTimeOfUser) {
        int hour = 0;
        int minute = 0;
        if (dutyTimeOfUser > 0) {
            hour = dutyTimeOfUser / 60 / 60;
            minute = dutyTimeOfUser / 60 % 60;
        } else {
            personInfo.setWorkStatus(false);
        }
        return WorkBenchKDString.timeStr(hour, minute);
    }

    private static class InstanceHolder {
        private static final DutyUserService INSTANCE = new DutyUserService();

        private InstanceHolder() {
        }
    }
}

