/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.common.mservice.resp;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class MsResponse {
    public static final String MSGTYPE_INFO = "info";
    public static final String MSGTYPE_WARN = "warn";
    public static final String MSGTYPE_ERROR = "error";
    public static final String MSGTYPE_POP = "pop";
    private String success;
    private String errCode;
    private String msg;
    private String msgType = "warn";
    private Map<String, Object> data = Maps.newHashMap();

    public static MsResponse ok() {
        MsResponse msResponse = new MsResponse();
        msResponse.setSuccess(true);
        return msResponse;
    }

    public static MsResponse error() {
        MsResponse msResponse = new MsResponse();
        msResponse.setSuccess(false);
        msResponse.setErrCode("9999");
        msResponse.setMsg("fail");
        msResponse.setMsgType(MSGTYPE_ERROR);
        return msResponse;
    }

    public static MsResponse error(String errorCode) {
        MsResponse msResponse = new MsResponse();
        msResponse.setSuccess(false);
        msResponse.setErrCode(errorCode);
        msResponse.setMsgType(MSGTYPE_ERROR);
        return msResponse;
    }

    public static MsResponse error(String errorCode, String msg) {
        MsResponse msResponse = new MsResponse();
        msResponse.setSuccess(false);
        msResponse.setErrCode(errorCode);
        msResponse.setMsg(msg);
        msResponse.setMsgType(MSGTYPE_ERROR);
        return msResponse;
    }

    public static MsResponse error(String errorCode, String msg, String msgType) {
        MsResponse msResponse = new MsResponse();
        msResponse.setSuccess(false);
        msResponse.setErrCode(errorCode);
        msResponse.setMsg(msg);
        msResponse.setMsgType(msgType);
        return msResponse;
    }

    public MsResponse setSuccess(boolean success) {
        this.success = Boolean.toString(success);
        return this;
    }

    public MsResponse setErrCode(String errCode) {
        this.errCode = errCode;
        return this;
    }

    public MsResponse setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public MsResponse setMsgType(String msgType) {
        this.msgType = msgType;
        return this;
    }

    public MsResponse put(String key, Object val) {
        this.data.put(key, val);
        return this;
    }

    public MsResponse putAll(Map<String, Object> data) {
        this.data.putAll(data);
        return this;
    }

    public Map<String, Object> buildMap() {
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("success", this.success);
        resultMap.put("errCode", this.errCode);
        resultMap.put("msg", this.msg);
        resultMap.put("msgType", this.msgType);
        resultMap.put("data", this.data);
        return resultMap;
    }
}

