/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.ssc.hstc.util.ObjectUtils;

public class ControlUtil {
    public static BarItemAp genBarItemAp(String key, LocaleString name, String operationKey, boolean ifCommitValidate) {
        BarItemAp barItemAp = new BarItemAp();
        barItemAp.setKey(key);
        barItemAp.setName(name);
        if (ObjectUtils.isNotEmpty(operationKey)) {
            barItemAp.setOperationKey(operationKey);
        }
        barItemAp.setCommitValidate(ifCommitValidate);
        return barItemAp;
    }

    public static void setLabelText(IFormView formView, String labelKey, String text) {
        Label label;
        if (ObjectUtils.isNotEmpty(labelKey) && text != null && (label = (Label)formView.getControl(labelKey)) != null) {
            label.setText(text);
        }
    }

    public static Map<String, String> getComboPropValues(String pageName, String field) {
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)pageName).getProperties().get((Object)field);
        HashMap<String, String> comboPropValueMap = new HashMap<String, String>(16);
        if (iDataEntityProperty instanceof ComboProp) {
            List comboItems = ((ComboProp)iDataEntityProperty).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                comboPropValueMap.put(comboItem.getValue(), comboItem.getName().getLocaleValue());
            }
        }
        return comboPropValueMap;
    }

    public static String getComboPropValueByKey(String metadataNumber, String srcFieldName, String key) {
        if (Objects.isNull(key)) {
            return "";
        }
        String value = "";
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)metadataNumber).getProperties().get((Object)srcFieldName);
        if (dataEntityProperty instanceof ComboProp) {
            List comboItems = ((ComboProp)dataEntityProperty).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(key)) continue;
                value = comboItem.getName().getLocaleValue();
                break;
            }
        }
        return value;
    }

    public static void setValueNoChangedEvent(IFormView iFormView, String key, Object value) {
        iFormView.getModel().beginInit();
        iFormView.getModel().setValue(key, value);
        iFormView.getModel().endInit();
        iFormView.updateView(key);
    }
}

