/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.hstc.common.entity.MonthInfo;
import kd.ssc.hstc.common.entity.WeekInfo;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateUtils {
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Date getTodayTruncate() {
        Date date = new Date();
        return DateUtils.truncateDate(date);
    }

    public static Date addDay(Date date, int day) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static int getWeekWith7Days(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(3);
    }

    public static int getWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static int getWeekDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int era = cal.get(0);
        return era == 0 ? -1 * year : year;
    }

    public static Date getFirstDayOfCurrentYear() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.set(2, 0);
        c.set(5, 1);
        String first = format.format(c.getTime());
        try {
            return format.parse(first);
        }
        catch (ParseException exception) {
            return null;
        }
    }

    public static Date getFirstDayOfYear(int year) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, 0);
        calendar.set(5, 1);
        String first = format.format(calendar.getTime());
        try {
            return format.parse(first);
        }
        catch (ParseException exception) {
            return null;
        }
    }

    public static long getDayDiff(Date startDate, Date endDate) {
        startDate = DateUtils.truncateDate(startDate);
        endDate = DateUtils.truncateDate(endDate);
        if (startDate == null || endDate == null) {
            return 0L;
        }
        return Math.abs(startDate.getTime() - endDate.getTime()) / 86400000L;
    }

    public static List<WeekInfo> getWeekInfos(Date startDate, Date endDate) {
        ArrayList<WeekInfo> weekInfos = new ArrayList<WeekInfo>();
        Date nextStartDate = startDate;
        while (endDate.compareTo(nextStartDate) >= 0) {
            Date weekSatrtDate;
            int weekSatrtDateYear;
            Calendar calendar = Calendar.getInstance();
            calendar.setFirstDayOfWeek(2);
            calendar.setMinimalDaysInFirstWeek(4);
            calendar.setTime(nextStartDate);
            int weekSeqOfYear = calendar.get(3);
            int year = calendar.get(1);
            int weekDay = calendar.get(7);
            weekDay = weekDay == 1 ? 7 : --weekDay;
            long dayDiff = DateUtils.getDayDiff(nextStartDate, endDate);
            int remainNum = 7 - weekDay;
            Date currEndDate = DateUtils.addDay(nextStartDate, remainNum);
            if (weekSeqOfYear == 1) {
                year = DateUtils.getYear(currEndDate);
            } else if (weekSeqOfYear > 50 && (weekSatrtDateYear = DateUtils.getYear(weekSatrtDate = DateUtils.addDay(nextStartDate, 1 - weekDay))) != DateUtils.getYear(currEndDate)) {
                year = weekSatrtDateYear;
            }
            if (dayDiff <= (long)remainNum) {
                weekInfos.add(new WeekInfo(nextStartDate, endDate, year, weekSeqOfYear));
                return weekInfos;
            }
            weekInfos.add(new WeekInfo(nextStartDate, currEndDate, year, weekSeqOfYear));
            nextStartDate = DateUtils.addDay(currEndDate, 1);
        }
        return weekInfos;
    }

    public static WeekInfo getWeekInfo(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setTime(date);
        int weekSeqOfYear = calendar.get(3);
        int year = calendar.get(1);
        int weekDay = calendar.get(7);
        weekDay = weekDay == 1 ? 7 : --weekDay;
        Date startDate = DateUtils.addDay(date, 1 - weekDay);
        Date endDate = DateUtils.addDay(date, 7 - weekDay);
        return new WeekInfo(startDate, endDate, year, weekSeqOfYear);
    }

    public static String format(Date date, String fmt) {
        return DateUtils.format(date, fmt, null);
    }

    public static String format(Date date, String fmt, TimeZone timezone) {
        return DateUtils.format(date, fmt, timezone, null);
    }

    public static String format(Date date, String fmt, TimeZone timezone, Locale locale) {
        if (fmt == null) {
            fmt = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            df.setTimeZone(KDDateUtils.getSysTimeZone());
        } else {
            df.setTimeZone(timezone);
        }
        return df.format(date);
    }

    public static Date getFirstDayOfCurrentMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String first = format.format(calendar.getTime());
        try {
            return format.parse(first);
        }
        catch (ParseException var4) {
            return null;
        }
    }

    public static Date getLastDayOfCurrentMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String first = format.format(calendar.getTime());
        try {
            return format.parse(first);
        }
        catch (ParseException var4) {
            return null;
        }
    }

    public static MonthInfo getLastMonthInfo() {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.add(2, -1);
        startCalendar.set(5, 1);
        Date startDate = new Date(startCalendar.getTimeInMillis() / 1000L * 1000L);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.add(2, 0);
        endCalendar.set(5, -1);
        Date endDate = new Date(endCalendar.getTimeInMillis() / 1000L * 1000L);
        int year = DateUtils.getYear(startDate);
        int month = DateUtils.getMonth(startDate);
        return new MonthInfo(startDate, endDate, year, month);
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, 1);
        calendar.add(2, 0);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String first = format.format(calendar.getTime());
        try {
            return format.parse(first);
        }
        catch (ParseException var4) {
            return null;
        }
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String first = format.format(calendar.getTime());
        try {
            return format.parse(first);
        }
        catch (ParseException var4) {
            return null;
        }
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static List<MonthInfo> getMonthInfos(Date startDate, Date endDate) {
        ArrayList<MonthInfo> monthInfos = new ArrayList<MonthInfo>();
        int startMonth = DateUtils.getMonth(startDate);
        int endYear = DateUtils.getYear(endDate);
        int endMonth = DateUtils.getMonth(endDate);
        for (int startYear = DateUtils.getYear(startDate); endYear >= startYear && endMonth >= startMonth; ++startYear) {
            if (endYear == startYear) {
                while (endMonth >= startMonth) {
                    monthInfos.add(new MonthInfo(startYear, startMonth));
                    ++startMonth;
                }
                continue;
            }
            for (int month = startMonth; month < 12; ++month) {
                monthInfos.add(new MonthInfo(startYear, month));
            }
            startMonth = 1;
        }
        return monthInfos;
    }

    public static List<Date> getTimePoints(Date dt, int number) {
        ArrayList<Date> result = new ArrayList<Date>(number);
        if (dt == null) {
            return result;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        if (cal.get(12) != 0 || cal.get(13) != 0) {
            cal.set(12, 0);
            cal.set(13, 0);
            cal.add(10, 1);
        }
        Date endTime = new Date(cal.getTimeInMillis() / 1000L * 1000L);
        result.add(endTime);
        for (int i = 1; i < number; ++i) {
            Calendar calTemp = Calendar.getInstance();
            calTemp.setTime(endTime);
            calTemp.add(10, -1);
            endTime = new Date(calTemp.getTimeInMillis() / 1000L * 1000L);
            result.add(endTime);
        }
        Collections.reverse(result);
        return result;
    }

    public static String getTimeShow(int time) {
        int hour = time / 3600;
        int min = (time - hour * 3600) / 60;
        StringBuilder timeSBuilder = new StringBuilder();
        if (hour < 10) {
            timeSBuilder.append('0');
        }
        timeSBuilder.append(hour).append(':');
        if (min < 10) {
            timeSBuilder.append('0');
        }
        timeSBuilder.append(min);
        return timeSBuilder.toString();
    }

    public static boolean belongTime(Date beginTime, Date endTime, Date nowTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.compareTo(begin) >= 0 && date.compareTo(end) <= 0;
    }

    public static long diffTime(Date beginTime, Date endTime, Date nowTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        if (date.compareTo(begin) >= 0 && date.compareTo(end) <= 0) {
            return date.getTimeInMillis() - begin.getTimeInMillis();
        }
        if (date.compareTo(end) > 0) {
            return end.getTimeInMillis() - begin.getTimeInMillis();
        }
        return -1L;
    }

    public static long diffTime(Date beginTime, Date endTime) {
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return end.getTimeInMillis() - begin.getTimeInMillis();
    }

    public static Date changeTimeZone(Date date, String timeZoneNumber) {
        if (StringUtils.isEmpty((String)timeZoneNumber)) {
            return date;
        }
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneNumber);
        DateTime dt = new DateTime((Object)date);
        DateTimeZone dtZone = DateTimeZone.forTimeZone((TimeZone)timeZone);
        return dt.withZone(dtZone).toLocalDateTime().toDate();
    }

    public static Date getToday(long sscId) {
        if (sscId == 0L) {
            return DateUtils.getTodayTruncate();
        }
        DynamicObject orgTimezone = InteServiceHelper.getOrgTimezone((Long)sscId);
        String zoneTimeNumber = null;
        if (orgTimezone != null) {
            zoneTimeNumber = orgTimezone.getString("number");
        }
        if (StringUtils.isNotEmpty(zoneTimeNumber)) {
            Calendar now = Calendar.getInstance();
            Date date = now.getTime();
            now.setTimeZone(TimeZone.getTimeZone(zoneTimeNumber));
            date = DateUtils.changeTimeZone(date, zoneTimeNumber);
            Date nowDate = null;
            try {
                nowDate = SDF.parse(SDF.format(date));
            }
            catch (ParseException e) {
                nowDate = DateUtils.getTodayTruncate();
            }
            return nowDate;
        }
        return DateUtils.getTodayTruncate();
    }
}

