/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.util;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ObjectUtils {
    private static final Log LOGGER = LogFactory.getLog(ObjectUtils.class);

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof DynamicObject) {
            Object pkid = ((DynamicObject)obj).get("id");
            if (pkid instanceof String) {
                return pkid.toString().trim().equals("");
            }
            return ((DynamicObject)obj).getLong("id") == 0L;
        }
        if (obj instanceof String) {
            return obj.toString().trim().equals("");
        }
        if (obj instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !ObjectUtils.isEmpty(obj);
    }

    public static String getStringValOfObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    public static long getLongValOfObject(Object object) {
        if (object == null || object instanceof String && "".equals(object.toString().trim())) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        return Long.parseLong(object.toString());
    }

    public static int getIntValOfObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getInt("id");
        }
        return Integer.parseInt(object.toString());
    }

    public static boolean getBooleanValOfObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.parseBoolean(object.toString());
    }

    public static <T> Collection<T> getObjectsFromJSONStr(String source, Class<T> type) {
        if (source == null) {
            return null;
        }
        try {
            return JSON.parseArray((String)source, type);
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            return null;
        }
    }
}

