/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.mq;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.ssc.hstc.mq.HSTCMqSendHelper;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncBusinessService;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncBusinessServiceFactory;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordSyncStatusEnum;

public class TaskDataSyncConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(TaskDataSyncConsumer.class);
    private static final int MAX_RETRYCOUNT = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean isResend, MessageAcker messageAcker) {
        LOGGER.info("TaskDataSyncConsumer onMessage. message:{}, messageId:{}, isResend:{}", new Object[]{message, messageId, isResend});
        if (StringUtils.isBlank((CharSequence)(message + ""))) {
            LOGGER.info("TaskDataSyncConsumer message is null.");
            messageAcker.ack(messageId);
            return;
        }
        Long batchNumber = Long.parseLong(String.valueOf(message));
        DynamicObject taskdatasyncRecordDy = QueryServiceHelper.queryOne((String)"hstc_taskdatasyncrecord", (String)"id,batchnumber,syncstatus,retrycount", (QFilter[])new QFilter[]{new QFilter("batchnumber", "=", (Object)batchNumber)});
        if (taskdatasyncRecordDy == null) {
            LOGGER.info("TaskDataSyncConsumer taskdatasyncRecordDy is null.");
            messageAcker.ack(messageId);
            return;
        }
        String syncstatus = taskdatasyncRecordDy.getString("syncstatus");
        if (TaskRecordSyncStatusEnum.isFinish((String)syncstatus)) {
            LOGGER.info("TaskDataSyncConsumer ack syncstatus:{}.", (Object)syncstatus);
            messageAcker.ack(messageId);
            return;
        }
        int retrycount = taskdatasyncRecordDy.getInt("retrycount");
        if (retrycount >= 3) {
            LOGGER.info("TaskDataSyncConsumer ack retrycount:{}.", (Object)retrycount);
            messageAcker.ack(messageId);
            return;
        }
        try {
            Long recordId = taskdatasyncRecordDy.getLong("id");
            TaskDataSyncConsumer.doOnMessage(recordId);
        }
        finally {
            messageAcker.ack(messageId);
        }
    }

    private static void doOnMessage(Long recordId) {
        TaskDataSyncBusinessService service = TaskDataSyncBusinessServiceFactory.createService(recordId);
        DynamicObject updateRecordDy = service.syncData();
        String syncstatus = updateRecordDy.getString("syncstatus");
        int retrycount = updateRecordDy.getInt("retrycount");
        if (!TaskRecordSyncStatusEnum.isFinish((String)syncstatus) && retrycount < 3) {
            String mqMessage = String.valueOf(updateRecordDy.getLong("batchnumber"));
            LOGGER.info("TaskDataSyncConsumer message done syncstatus:{}, retrycount:{}, retry sendMessage:{}.", new Object[]{syncstatus, retrycount, mqMessage});
            HSTCMqSendHelper.publishToTaskDataSyncQueue((String)mqMessage);
        }
    }
}

