/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.repository;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.hstc.util.QFilterCommonUtil;

public class TaskHistoryRepository {
    private static final Log LOG = LogFactory.getLog(TaskHistoryRepository.class);

    public static TaskHistoryRepository getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public DynamicObject queryTaskHistoryData(long id, String selectProperties) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"task_taskhistory", (String)selectProperties, (QFilter[])new QFilter[]{QFilterCommonUtil.idFilter((Object)id)});
    }

    public DynamicObject queryTaskHistoryData(String selectProperties, QFilter[] qFilters) {
        return QueryServiceHelper.queryOne((String)"task_taskhistory", (String)selectProperties, (QFilter[])qFilters);
    }

    public DynamicObject[] queryTaskHistory(String selectProperties, QFilter[] filters) {
        LOG.info("TaskQueryService_getTask, selectProperties={}", (Object)selectProperties);
        return BusinessDataServiceHelper.load((String)"task_taskhistory", (String)selectProperties, (QFilter[])filters);
    }

    public int countTaskHistory(QFilter[] qFilters) {
        ORM orm = ORM.create();
        return orm.count("TaskHistoryRepository", "task_taskhistory", qFilters);
    }

    public DynamicObjectCollection queryTaskHistoryData(String selectProperties, QFilter[] qFilters, String orderBy) {
        return QueryServiceHelper.query((String)"task_taskhistory", (String)selectProperties, (QFilter[])qFilters, (String)orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple<Long, BigDecimal>> queryCostTimeByBillType(QFilter[] filters, boolean ifShowForLeader) {
        String selectFields = "billtype, costwaittime, firstcostwaittime";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryCostTimeByBillType", (String)"task_taskhistory", (String)selectFields, (QFilter[])filters, null);
        if (dataSet == null) {
            return null;
        }
        String amountFieldName = "costwaittime";
        if (ifShowForLeader) {
            amountFieldName = "firstcostwaittime";
        }
        ArrayList<Tuple<Long, BigDecimal>> costTimeList = new ArrayList<Tuple<Long, BigDecimal>>();
        dataSet = dataSet.select(new String[]{"billtype", amountFieldName + " as costwaittime"}).groupBy(new String[]{"billtype"}).sum("costwaittime").finish().orderBy(new String[]{"costwaittime desc"});
        try {
            for (Row row : dataSet) {
                costTimeList.add((Tuple<Long, BigDecimal>)Tuple.create((Object)row.getLong("billtype"), (Object)row.getBigDecimal("costwaittime")));
            }
        }
        finally {
            dataSet.close();
        }
        return costTimeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple<Long, BigDecimal>> queryRankTaskAmount(QFilter[] filters, boolean ifOrderDesc) {
        String selectFields = "personid.id as personid, coefficient";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryRankTaskAmount", (String)"task_taskhistory", (String)selectFields, (QFilter[])filters, null);
        if (dataSet == null) {
            return null;
        }
        dataSet = ifOrderDesc ? dataSet.select(new String[]{"personid", "coefficient"}).groupBy(new String[]{"personid"}).sum("coefficient", "taskamount").finish().orderBy(new String[]{"taskamount desc"}) : dataSet.select(new String[]{"personid", "coefficient"}).groupBy(new String[]{"personid"}).sum("coefficient", "taskamount").finish().orderBy(new String[]{"taskamount asc"});
        ArrayList<Tuple<Long, BigDecimal>> taskamountList = new ArrayList<Tuple<Long, BigDecimal>>();
        try {
            for (Row row : dataSet) {
                taskamountList.add((Tuple<Long, BigDecimal>)Tuple.create((Object)row.getLong("personid"), (Object)row.getBigDecimal("taskamount")));
            }
        }
        finally {
            dataSet.close();
        }
        return taskamountList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple<Long, BigDecimal>> queryRankTaskEfficiency(QFilter[] filters, boolean ifOrderDesc, boolean ifShowForLeader) {
        String selectFields = "personid.id as personid, coefficient, costwaittime, firstcostwaittime";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryRankTaskEfficiency", (String)"task_taskhistory", (String)selectFields, (QFilter[])filters, null);
        if (dataSet == null) {
            return null;
        }
        String amountFieldName = "costwaittime";
        if (ifShowForLeader) {
            amountFieldName = "firstcostwaittime";
        }
        dataSet = dataSet.select(new String[]{"personid", "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "(case when " + amountFieldName + " is null or " + amountFieldName + " = 0 then 0.02 else " + amountFieldName + " end) as costwaittime"}).groupBy(new String[]{"personid"}).count("taskcount").sum("coefficient", "taskamount").sum("costwaittime").finish();
        dataSet = dataSet.select(new String[]{"personid", "taskcount", "taskamount", "costwaittime", "cast(case when taskcount=0 then 0 else  costwaittime/taskamount end as decimal) as taskefficiency"});
        dataSet = ifOrderDesc ? dataSet.orderBy(new String[]{"taskefficiency desc"}) : dataSet.orderBy(new String[]{"taskefficiency asc"});
        ArrayList<Tuple<Long, BigDecimal>> taskefficiencyList = new ArrayList<Tuple<Long, BigDecimal>>();
        try {
            for (Row row : dataSet) {
                taskefficiencyList.add((Tuple<Long, BigDecimal>)Tuple.create((Object)row.getLong("personid"), (Object)row.getBigDecimal("taskefficiency")));
            }
        }
        finally {
            dataSet.close();
        }
        return taskefficiencyList;
    }

    public DataSet getTaskHistoryDataSet(String selectProperties, QFilter[] qFilters, String orderBy) {
        return QueryServiceHelper.queryDataSet((String)"getTaskHistoryDataSet", (String)"task_taskhistory", (String)selectProperties, (QFilter[])qFilters, (String)orderBy);
    }

    private static class InstanceHolder {
        private static final TaskHistoryRepository INSTANCE = new TaskHistoryRepository();

        private InstanceHolder() {
        }
    }
}

