/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.ssc.hstc.util.ObjectUtils;
import kd.ssc.hstc.business.repository.ArticheckpointrecordRepository;

public class ArtiCheckPointService {
    private static final Log LOG = LogFactory.getLog(ArtiCheckPointService.class);

    public static ArtiCheckPointService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public DynamicObjectCollection queryArticheckpointrecordByTaskid(Long taskid) {
        return ArticheckpointrecordRepository.getInstance().queryArticheckpointrecordByTaskid(taskid, "articheckpoint as articheckpointid,articheckpoint.name as articheckpointname,iscontented as articheckpointselected");
    }

    public static boolean isArtiCheckPointSelected(IFormView view, IDataModel model) {
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return true;
        }
        for (DynamicObject entry : entryentity) {
            if (entry.getBoolean("checkboxfield")) continue;
            view.showErrorNotification(ResManager.loadKDString((String)"\u4eba\u5de5\u68c0\u67e5\u9879\u6ca1\u6709\u68c0\u67e5\u901a\u8fc7\uff0c\u8bf7\u5148\u68c0\u67e5\u901a\u8fc7\u540e\u5e76\u52fe\u9009\u3002", (String)"ArtiCheckPointService_0", (String)"ssc-hstc-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean isArtiCheckPointSelected(DynamicObject[] entryEntity) {
        if (entryEntity == null || entryEntity.length == 0) {
            return true;
        }
        for (DynamicObject entry : entryEntity) {
            if (StringUtils.equals((CharSequence)"0", (CharSequence)entry.getString("articheckpointid")) || entry.getBoolean("checkboxfield")) continue;
            return false;
        }
        return true;
    }

    public void saveTaskArtiCheckPoint(IDataModel model, DynamicObject[] taskDys, boolean isFromList, String operationResultType) {
        try {
            Map<Long, DynamicObject> sourceTaskIdMap = Stream.of(taskDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
            List taskids = sourceTaskIdMap.keySet().stream().map(String::valueOf).collect(Collectors.toList());
            Date nowDate = new Date();
            if (isFromList) {
                QFilter filter = new QFilter("taskid", "in", taskids);
                DynamicObject[] articheckpointrecords = BusinessDataServiceHelper.load((String)"task_articheckpointrecord", (String)"id,taskid,createtime", (QFilter[])new QFilter[]{filter});
                if (articheckpointrecords != null && articheckpointrecords.length > 0) {
                    for (DynamicObject articheckpointrecord : articheckpointrecords) {
                        long taskId = ObjectUtils.getLongValOfObject((Object)articheckpointrecord.get("taskid"));
                        articheckpointrecord.set("taskid", sourceTaskIdMap.get(taskId).get("id"));
                        articheckpointrecord.set("createtime", (Object)nowDate);
                    }
                    SaveServiceHelper.save((DynamicObject[])articheckpointrecords);
                    return;
                }
                ArrayList articheckpointlist = new ArrayList();
                Map<Long, List<DynamicObject>> billtypeMap = Stream.of(taskDys).collect(Collectors.groupingBy(dy -> dy.getLong("billtype.id")));
                for (Map.Entry<Long, List<DynamicObject>> billtypeEntry : billtypeMap.entrySet()) {
                    Long billTypeId = billtypeEntry.getKey();
                    Map<Long, List<DynamicObject>> tasktypeidMap = billtypeEntry.getValue().stream().collect(Collectors.groupingBy(dy -> dy.getLong("tasktypeid.id")));
                    for (Map.Entry<Long, List<DynamicObject>> tasktypeEntry : tasktypeidMap.entrySet()) {
                        Long taskTypeId = tasktypeEntry.getKey();
                        articheckpointlist.addAll(kd.sdk.ssc.hstc.common.ArtiCheckPointService.getInstance().genArtiCheckPointWithTaskInfos(billTypeId, taskTypeId, tasktypeEntry.getValue(), operationResultType));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])articheckpointlist.toArray(new DynamicObject[0]));
            } else {
                if (model == null) {
                    return;
                }
                QFilter filter = new QFilter("taskid", "in", taskids);
                DynamicObjectCollection articheckpointrecords = QueryServiceHelper.query((String)"task_articheckpointrecord", (String)"id as articheckpointid,articheckpoint as articheckpointname,iscontented as articheckpointselected", (QFilter[])new QFilter[]{filter});
                if (articheckpointrecords != null && articheckpointrecords.size() > 0) {
                    DeleteServiceHelper.delete((String)"task_articheckpointrecord", (QFilter[])new QFilter[]{filter});
                }
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"task_articheckpointrecord");
                ArrayList<DynamicObject> articheckpointlist = new ArrayList<DynamicObject>();
                DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
                if (entryentity == null || entryentity.size() == 0) {
                    return;
                }
                for (DynamicObject taskHistoryDy : taskDys) {
                    for (DynamicObject entry : entryentity) {
                        DynamicObject articheckpointitem = new DynamicObject((DynamicObjectType)dt);
                        if ("0".equals(entry.getString("articheckpointid"))) continue;
                        articheckpointitem.set("taskid", (Object)taskHistoryDy.getString("id"));
                        articheckpointitem.set("articheckpoint", (Object)entry.getString("articheckpointid"));
                        articheckpointitem.set("createtime", (Object)nowDate);
                        articheckpointitem.set("iscontented", entry.get("checkboxfield"));
                        articheckpointlist.add(articheckpointitem);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])articheckpointlist.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception exception) {
            LOG.info("ArtiCheckPointService error :", (Object)exception);
        }
    }

    public Map<Long, DynamicObjectCollection> getArtiCheckPointByBillTypeId(Long billTypeId, Long taskTypeId, Collection<Long> billIds) {
        HashMap<Long, DynamicObjectCollection> resultMap = new HashMap<Long, DynamicObjectCollection>(billIds.size());
        String entityName = "task_taskbill";
        String selectFields = "id,entryentity.childpkid as childpkid,bindbill.number as bindbillnumber";
        QFilter billTypeFilter = new QFilter("id", "=", (Object)billTypeId);
        QFilter taskTypeFilter = new QFilter("entryentity.tasktype", "=", (Object)taskTypeId);
        DynamicObject taskBillDy = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{billTypeFilter, taskTypeFilter});
        if (taskBillDy == null) {
            return resultMap;
        }
        Long childpkid = taskBillDy.getLong("childpkid");
        QFilter filter = new QFilter("id", "=", (Object)childpkid);
        try {
            QFilter filter1 = QFilter.isNotNull((String)"entryentityarticheck.articheck.id").and("entryentityarticheck.articheck.id", "!=", (Object)0L);
            DynamicObjectCollection articheckpointCollection = QueryServiceHelper.query((String)"task_taskbill_child", (String)"entryentityarticheck.articheck.id as articheckpointid,entryentityarticheck.articheck.name as articheckpointname,entryentityarticheck.articheck.isselected as articheckpointselected,entryentityarticheck.checkconditionjson_tag as checkconditionjson,entryentityarticheck.checkcondition as checkcondition", (QFilter[])new QFilter[]{filter, filter1});
            if (articheckpointCollection == null || articheckpointCollection.size() == 0) {
                return resultMap;
            }
            for (DynamicObject dyo : articheckpointCollection) {
                List<Long> matchBillIds = new ArrayList<Long>(billIds.size());
                if (StringUtils.isBlank((CharSequence)dyo.getString("checkcondition"))) {
                    matchBillIds.addAll(billIds);
                } else {
                    matchBillIds = this.meetCondition(taskBillDy.getString("bindbillnumber"), dyo.getString("checkconditionjson"), billIds);
                }
                for (Long billId : matchBillIds) {
                    DynamicObjectCollection collection = (DynamicObjectCollection)resultMap.get(billId);
                    if (collection == null) {
                        collection = new DynamicObjectCollection();
                    }
                    collection.add((Object)dyo);
                    resultMap.put(billId, collection);
                }
            }
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
            QFilter filter1 = QFilter.isNotNull((String)"articheckpointconfig.FBasedataId");
            DynamicObjectCollection articheckpointCollection = QueryServiceHelper.query((String)"task_taskbill_child", (String)"articheckpointconfig.FBasedataId as articheckpointid,articheckpointconfig.FBasedataId.name as articheckpointname,articheckpointconfig.FBasedataId.isselected as articheckpointselected", (QFilter[])new QFilter[]{filter, filter1});
            if (articheckpointCollection == null || articheckpointCollection.size() == 0) {
                return resultMap;
            }
            for (Long billId : billIds) {
                resultMap.put(billId, articheckpointCollection);
            }
        }
        return resultMap;
    }

    private List<Long> meetCondition(String bindEntityNumber, String conditionJson, Collection<Long> billIds) {
        QFilter qFilter = new QFilter("id", "in", billIds);
        qFilter.and(this.analysisFilter(bindEntityNumber, conditionJson));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)bindEntityNumber, (String)"id", (QFilter[])qFilter.toArray());
        if (collection == null || collection.isEmpty()) {
            return new ArrayList<Long>();
        }
        return collection.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private QFilter analysisFilter(String entityNumber, String conditionJson) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition, true);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    private static class InstanceHolder {
        private static final ArtiCheckPointService INSTANCE = new ArtiCheckPointService();

        private InstanceHolder() {
        }
    }
}

