/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.ssc.hstc.AbstractHRTaskDetailPlugin;
import kd.ssc.hstc.business.repository.DetailPluginConfRepository;
import kd.ssc.hstc.util.ObjectUtils;

public class DetailPluginConfService {
    private static final Log LOGGER = LogFactory.getLog(DetailPluginConfService.class);

    public static DetailPluginConfService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public List<AbstractHRTaskDetailPlugin> getDetailPlugins(String entityNumber) {
        ArrayList<AbstractHRTaskDetailPlugin> detailPlugins = new ArrayList<AbstractHRTaskDetailPlugin>();
        DynamicObject[] detailPluginConfDys = DetailPluginConfRepository.queryDetailPlugins(entityNumber);
        if (detailPluginConfDys != null) {
            for (DynamicObject detailPluginConfDy : detailPluginConfDys) {
                String classPath = detailPluginConfDy.getString("class");
                if (ObjectUtils.isEmpty((Object)classPath)) continue;
                try {
                    Class<?> detailPlugin = Class.forName(classPath.trim());
                    detailPlugins.add((AbstractHRTaskDetailPlugin)detailPlugin.newInstance());
                }
                catch (Throwable exception) {
                    LOGGER.error(exception);
                }
            }
        }
        return detailPlugins;
    }

    private static class InstanceHolder {
        private static final DetailPluginConfService INSTANCE = new DetailPluginConfService();

        private InstanceHolder() {
        }
    }
}

