/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.service;

import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.sysint.servicehelper.SysIntegrationServiceHelper;
import kd.ssc.hstc.common.exception.TaskKDExcetptionUtil;

public class EasWorkflowService {
    private static final Log LOGGER = LogFactory.getLog(EasWorkflowService.class);
    private static final String LOCAL_FILT_PATH = "LtpaToken.properties";
    private static final String REDIRECT_TO = "/easweb/webviews/workflow/viewProcessDiagram.jsp?billId={0}";

    public static EasWorkflowService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void viewFlowchart(String subPageId, Object billid, String pageId) {
        IFormView view = SessionManager.getCurrent().getView(subPageId);
        if (view == null) {
            throw new KDBizException(ResManager.loadKDString((String)"pageId\u9519\u8bef", (String)"EasWorkflowService_0", (String)"ssc-hstc-business", (Object[])new Object[0]));
        }
        IFormView parentView = SessionManager.getCurrent().getView(pageId);
        if (parentView == null) {
            throw new KDBizException(ResManager.loadKDString((String)"pageId\u9519\u8bef", (String)"EasWorkflowService_0", (String)"ssc-hstc-business", (Object[])new Object[0]));
        }
        this.viewFlowchart(view, billid, parentView);
    }

    public void viewFlowchart(IFormView view, Object billid, IFormView parentView) {
        String redirectTo = MessageFormat.format(REDIRECT_TO, billid);
        String url = this.casEasUrl(view, redirectTo);
        if (url != null) {
            if (parentView == null) {
                view.openUrl(url);
            } else {
                parentView.openUrl(url);
            }
        }
    }

    public String casEasUrl(IFormView view, String redirectTo) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"task_easurl", (String)"id,eassystermip,ltpatoken", null);
        if (collection.isEmpty()) {
            if (view == null) {
                throw TaskKDExcetptionUtil.createKDException((String)"fi.ssc.EasCasConfigError", (String)ResManager.loadKDString((String)"EAS\u5355\u70b9\u767b\u5f55\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u57fa\u7840\u8d44\u6599\u3010task_easurl\u3011", (String)"EasWorkflowService_1", (String)"ssc-hstc-business", (Object[])new Object[0]), (Object[])new Object[]{new Object()});
            }
            throw new KDBizException(ResManager.loadKDString((String)"EAS\u5355\u70b9\u767b\u5f55\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u57fa\u7840\u8d44\u6599\u3010task_easurl\u3011", (String)"EasWorkflowService_1", (String)"ssc-hstc-business", (Object[])new Object[0]));
        }
        String easurl = (String)((DynamicObject)collection.get(0)).get("eassystermip");
        String ltpatoken = (String)((DynamicObject)collection.get(0)).get("ltpatoken");
        String[] ltpatokens = ltpatoken.split(",");
        this.newFile(ltpatokens);
        Map userMap = SysIntegrationServiceHelper.getExternalData((Long)1L, (String)"bos_user", (String)RequestContext.get().getUserId(), null, null);
        if (userMap == null) {
            if (view != null) {
                view.showMessage(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0a\u4e0b\u6587\u7528\u6237id\u5bf9\u5e94eas\u7684\u7528\u6237\u540d\u4e3a\u7a7a", (String)"EasWorkflowService_2", (String)"ssc-hstc-business", (Object[])new Object[0]));
            }
            return null;
        }
        LOGGER.info("eas username userMap :{}", (Object)userMap);
        String username = (String)userMap.get("number");
        String usernamehtml = null;
        LOGGER.info("username: {}", (Object)username);
        try {
            usernamehtml = URLEncoder.encode(username, "utf-8");
            LOGGER.info("usernamehtml:{}", (Object)usernamehtml);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("URLEncoding\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        String password = LtpaTokenManager.generate((String)username, (String)LOCAL_FILT_PATH).toString();
        LOGGER.info("redirectTo:{}", (Object)redirectTo);
        String url = "http://" + easurl + "/portal/index2sso.jsp?username=" + usernamehtml;
        url = url + "&password=" + password + "&redirectTo=" + redirectTo;
        LOGGER.info("url:{}", (Object)url);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newFile(String[] ltpatokens) {
        File file = new File(LOCAL_FILT_PATH);
        try {
            boolean isCreateNewFile;
            if (!file.exists() && (isCreateNewFile = file.createNewFile())) {
                LOGGER.info("create new file.");
            }
            LOGGER.info("viewchart canonicalpath : {}", (Object)file.getCanonicalPath());
            LOGGER.info("viewchart absolutepath  : {}", (Object)file.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error(String.format("file create error: %s", e.getMessage()), (Throwable)e);
        }
        DLock lock = DLock.create((String)LOCAL_FILT_PATH);
        lock.lock();
        try (FileOutputStream fos = new FileOutputStream(file);){
            for (String line : ltpatokens) {
                fos.write((line + "\r\n").getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("file write error:{}: %s", e.getMessage()), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private static class InstanceHolder {
        private static final EasWorkflowService INSTANCE = new EasWorkflowService();

        private InstanceHolder() {
        }
    }
}

