/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.service;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.ssc.hstc.util.ObjectUtils;

public class GptService {
    private static final Log LOGGER = LogFactory.getLog(GptService.class);
    private static final String STATUS = "status";
    private static final String GPT_DATA_KEY = "data";
    private static final String GPT_RESULT_KEY = "llmValue";
    private static final String ERROR_CODE = "errCode";
    public static final String TIPS_DELETE_CODE = "ai.gai.10009";

    public static GptService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public Map<String, Object> syncCall(long gptId, String input, Map<String, String> param) {
        if (ObjectUtils.isEmpty((Object)input)) {
            input = ResManager.loadKDString((String)"\u8bf7\u7ed9\u51fa\u7b54\u6848\u3002", (String)"GptService_0", (String)"ssc-hstc-business", (Object[])new Object[0]);
        }
        long start = System.currentTimeMillis();
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])new Object[]{gptId, input, param});
        LOGGER.info("GptService invoke GPT cost  " + (System.currentTimeMillis() - start));
        return map;
    }

    public String getSyncGPTResult(long gptId, String input, Map<String, String> param) {
        LOGGER.info(String.format("GptService getSyncGPTResult gpt  %d  input %s ,param %s,", gptId, input, JSONObject.toJSONString(param)));
        Map<String, Object> map = this.syncCall(gptId, input, param);
        if (null == map || map.isEmpty()) {
            LOGGER.error(String.format("GPT result is empty by gpt ID %s and input %s", gptId, input));
            return "";
        }
        LOGGER.info(String.format("GptService getSyncGPTResult gpt result %s", JSONObject.toJSONString(map)));
        Object errorCodeObj = map.get(ERROR_CODE);
        if (TIPS_DELETE_CODE.equals(errorCodeObj)) {
            return TIPS_DELETE_CODE;
        }
        Object statusObject = map.get(STATUS);
        if (null == statusObject || !((Boolean)statusObject).booleanValue()) {
            LOGGER.error(String.format("GPT result status is  empty by gpt ID %s and input %s and result is %s", gptId, input, SerializationUtils.toJsonString(map)));
            return "";
        }
        Object dataObject = map.get(GPT_DATA_KEY);
        if (null == dataObject) {
            LOGGER.error(String.format("GPT result data is error by gpt ID %s and input %s and result is %s", gptId, input, SerializationUtils.toJsonString(map)));
            return "";
        }
        JSONObject dataJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataObject));
        return dataJson.getString(GPT_RESULT_KEY);
    }

    private static class InstanceHolder {
        private static final GptService INSTANCE = new GptService();

        private InstanceHolder() {
        }
    }
}

