/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.service;

import kd.bos.context.RequestContext;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class HstcLicenseService {
    public static HstcLicenseService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public boolean checkLicenseByBizObj(String bizObjID) {
        String formId = MetadataDao.getIdByNumber((String)bizObjID, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        return this.checkLicenseByAppAndBizObj(formMeta.getBizappId(), bizObjID);
    }

    public boolean checkLicenseByAppAndBizObj(String bizAppID, String bizObjID) {
        return this.checkLicenseByAppAndBizObj(bizAppID, bizObjID, RequestContext.getOrCreate().getCurrUserId());
    }

    public boolean checkLicenseByAppAndBizObj(String bizAppID, String bizObjID, Long userID) {
        LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkByAppAndBizObj((String)bizAppID, (String)bizObjID, (Long)userID);
        if (licenseCheckResult != null) {
            return licenseCheckResult.getHasLicense();
        }
        return true;
    }

    private static class InstanceHolder {
        private static final HstcLicenseService INSTANCE = new HstcLicenseService();

        private InstanceHolder() {
        }
    }
}

