/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.SuperUserCache;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.utils.DbTypeConverter;
import kd.ssc.hstc.common.enums.SSCErrorInfoEnum;

public class SSCPermissionServiceHelper {
    private static Log logger = LogFactory.getLog(SSCPermissionServiceHelper.class);

    public static boolean isSuperUser() {
        long currUserId = RequestContext.get().getCurrUserId();
        return SuperUserCache.isSuperUser((long)currUserId);
    }

    public static boolean hasPermByPermItemNum(long userId, String appId, String entityName, String permItemNum) {
        String permItemId = "";
        QFilter[] permItemFilters = new QFilter[]{new QFilter("number", "=", (Object)permItemNum)};
        DynamicObject permItemDy = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_permitem", (String)"id", (QFilter[])permItemFilters);
        if (permItemDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u6743\u9650\u9879\u4e0d\u5b58\u5728\uff01", (String)"SSCPermissionServiceHelper_1", (String)"ssc-hstc-business", (Object[])new Object[]{permItemNum}));
        }
        permItemId = permItemDy.getString("id");
        return SSCPermissionServiceHelper.hasPerm(userId, appId, entityName, permItemId);
    }

    public static boolean hasPerm(long userId, String appId, String entityName, String permItemId) {
        return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appId, (String)entityName, (String)permItemId);
    }

    public static boolean checkCancelDataAndFunctionRight(IFormView iFormView, boolean fillEntityName) {
        return SSCPermissionServiceHelper.checkCancelFunctionRight(iFormView, fillEntityName, false) || SSCPermissionServiceHelper.checkCancelDataRight(iFormView, false);
    }

    public static boolean checkCancelFunctionRight(IFormView iFormView, boolean fillEntityName, boolean withException) {
        FormShowParameter formShowParameter;
        if (iFormView != null && (formShowParameter = iFormView.getFormShowParameter()) != null && formShowParameter.getCancelRight() != 0) {
            String formName;
            FormConfig config = formShowParameter.getFormConfig();
            String string = formName = fillEntityName ? "\"" + config.getCaption().toString() + "\"" : "";
            if (withException) {
                throw new KDBizException(SSCErrorInfoEnum.COMMON_FUNCTION_RIGHT_CHANGED.getErrInfo(new Object[]{formName}));
            }
            iFormView.showConfirm(SSCErrorInfoEnum.COMMON_FUNCTION_RIGHT_CHANGED.getErrInfo(new Object[]{formName}), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(SSCErrorInfoEnum.COMMON_FUNCTION_RIGHT_CHANGED.getErrCode()));
            return true;
        }
        return false;
    }

    public static boolean checkCancelDataRight(IFormView iFormView, Boolean withException) {
        boolean hasDataPerm;
        boolean isCancelDataRight;
        if (iFormView == null) {
            return false;
        }
        FormShowParameter parentViewParameter = SessionManager.getCurrent().getFormShowParameter(iFormView.getFormShowParameter().getParentPageId());
        boolean bl = isCancelDataRight = parentViewParameter != null && parentViewParameter.isCancelDataRight();
        if (!isCancelDataRight && !(hasDataPerm = SSCPermissionServiceHelper.checkHasDataPerm(iFormView.getFormShowParameter()))) {
            isCancelDataRight = true;
        }
        if (isCancelDataRight) {
            iFormView.getFormShowParameter().setCancelDataRight(true);
            if (withException.booleanValue()) {
                throw new KDBizException(SSCErrorInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrInfo());
            }
            iFormView.showConfirm(SSCErrorInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrInfo(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(SSCErrorInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrCode()));
            return isCancelDataRight;
        }
        return isCancelDataRight;
    }

    private static boolean checkHasDataPerm(FormShowParameter showParameter) {
        boolean exists;
        BillShowParameter billParam;
        String entityId;
        MainEntityType entityType;
        int dbType;
        FormConfig fc;
        String entityTypeId = SSCPermissionServiceHelper.getEntityTypeId(showParameter);
        String permItem = showParameter.getPermissionItemId();
        String appId = showParameter.getCheckRightAppId();
        long userId = RequestContext.get().getCurrUserId();
        String bizAppId = StringUtils.isBlank((String)appId) ? (StringUtils.isBlank((String)(fc = FormMetadataCache.getFormConfig((String)entityTypeId)).getBizAppNumber()) ? BizAppServiceHelp.getAppIdByFormNum((String)entityTypeId) : BizAppServiceHelp.getAppIdByAppNumber((String)fc.getBizAppNumber())) : AppMetadataCache.getAppInfo((String)appId).getId();
        Object pkId = null;
        if (showParameter instanceof BillShowParameter && (pkId = DbTypeConverter.safeConvert((int)(dbType = (entityType = EntityMetadataCache.getDataEntityType((String)(entityId = (billParam = (BillShowParameter)showParameter).getFormConfig().getEntityTypeId()))).getPrimaryKey().getDbType()), (Object)billParam.getPkId())) != null && !(exists = QueryServiceHelper.exists((String)entityTypeId, (Object)pkId))) {
            pkId = null;
        }
        boolean hasPerm = true;
        if (pkId != null) {
            QFilter[] qfilters = new QFilter[]{new QFilter("id", "=", pkId)};
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            hasPerm = permissionService.matchDataRule(userId, bizAppId, entityTypeId, permItem, qfilters);
            if (!hasPerm) {
                return hasPerm;
            }
            boolean specialDataRuleDisable = Boolean.parseBoolean(System.getProperty("specialDataRuleDisable.on", "false"));
            if (specialDataRuleDisable && !(hasPerm = SSCPermissionServiceHelper.matchSpecialDataRule(permItem, entityTypeId, bizAppId, pkId, permissionService))) {
                return hasPerm;
            }
        }
        return hasPerm;
    }

    private static String getEntityTypeId(FormShowParameter showParameter) {
        String formId;
        String entityTypeId = null;
        entityTypeId = showParameter instanceof ListShowParameter ? (StringUtils.isBlank((String)(formId = ((ListShowParameter)showParameter).getBillFormId())) ? showParameter.getFormId() : FormMetadataCache.getFormConfig((String)formId).getEntityTypeId()) : (!(showParameter instanceof BillShowParameter) && !(showParameter instanceof MobileFormShowParameter) ? showParameter.getFormId() : showParameter.getFormConfig().getEntityTypeId());
        return entityTypeId;
    }

    private static boolean matchSpecialDataRule(String permItem, String entityTypeId, String bizAppId, Object pkId, PermissionService permissionService) {
        QFilter specialDataPermFilter;
        StringBuilder sbNotMatchTips = new StringBuilder();
        String operationKey = "view";
        if ("4715a0df000000ac".equals(permItem)) {
            operationKey = "modify";
        }
        if ((specialDataPermFilter = permissionService.getOperationRuleFilter(bizAppId, entityTypeId, operationKey, sbNotMatchTips)) != null) {
            ArrayList<QFilter> allFilterList = new ArrayList<QFilter>();
            allFilterList.add(specialDataPermFilter);
            allFilterList.add(new QFilter("id", "=", pkId));
            return QueryServiceHelper.exists((String)entityTypeId, (QFilter[])allFilterList.toArray(new QFilter[0]));
        }
        return true;
    }

    public static String getNoPermTips(String entityName, String opName) {
        if (StringUtils.isEmpty((String)entityName) || StringUtils.isEmpty((String)opName)) {
            return ResManager.loadKDString((String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SWCPermissionServiceHelper_2", (String)"swc-hsbp-business", (Object[])new Object[0]);
        }
        return MessageFormat.format(ResManager.loadKDString((String)"\u65e0\u201c{0}\u201d\u7684\u201c{1}\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SWCPermissionServiceHelper_4", (String)"swc-hsbp-business", (Object[])new Object[0]), entityName, opName);
    }

    public static boolean checkRole(Map<String, String> roleMap, String itemKey, IFormView iFormView, String appId, String entityName) {
        if (roleMap.containsKey(itemKey)) {
            long userId = RequestContext.get().getCurrUserId();
            boolean superUser = SSCPermissionServiceHelper.isSuperUser();
            boolean hasPermByPermItemNum = SSCPermissionServiceHelper.hasPerm(userId, appId, entityName, roleMap.get(itemKey));
            if (superUser || hasPermByPermItemNum) {
                logger.info("checkRole.hasPermByPermItemNum");
            } else {
                iFormView.showErrorNotification(SSCPermissionServiceHelper.notPerError(entityName, roleMap.get(itemKey)));
                return false;
            }
        }
        return true;
    }

    public static String notPerError(String entityName, String perId) {
        String otherCaption = EntityMetadataCache.getDataEntityType((String)entityName).getDisplayName().getLocaleValue();
        String permissionName = PermItemHelper.getPermItemNameById((String)perId);
        return SSCPermissionServiceHelper.getNoPermTips(otherCaption, permissionName);
    }

    public static boolean checkPer(IFormView view, String entityName, String perId) {
        long userId = RequestContext.get().getCurrUserId();
        boolean superUser = SSCPermissionServiceHelper.isSuperUser();
        if (superUser) {
            return true;
        }
        return SSCPermissionServiceHelper.checkPer(view, userId, entityName, perId);
    }

    public static boolean checkPer(IFormView view, long userId, String entityName, String perId) {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = view.getFormShowParameter().getCheckRightAppId();
        if (StringUtils.isEmpty((String)bizAppId)) {
            bizAppId = view.getFormShowParameter().getAppId();
        }
        if (StringUtils.isEmpty((String)bizAppId)) {
            bizAppId = "hstc";
        }
        boolean hasPer = permissionService.checkPermission(userId, bizAppId, entityName, perId);
        logger.info("SSCPermissionServiceHelper.checkPer\uff0c bizAppId={},entityName={},perId={},hasPer={}", new Object[]{bizAppId, entityName, perId, hasPer});
        if (hasPer) {
            return true;
        }
        view.showErrorNotification(SSCPermissionServiceHelper.notPerError(entityName, perId));
        return false;
    }
}

