/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.ssc.hstc.business.repository.TaskRescanReasonRepository;
import kd.ssc.hstc.business.service.TaskBillChildService;
import kd.ssc.hstc.business.service.TaskStatechangeService;
import kd.ssc.hstc.common.enums.ApproveOriginEnum;

public class TaskApproveService {
    private static final Log LOG = LogFactory.getLog(TaskApproveService.class);
    private static final String COMMON_URL = "/images/pc/emotion/default_person_82_82.png";

    public static TaskApproveService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static String getOriginBillOp(Long taskBill, Long taskType, String operationType, boolean isSave) {
        LOG.info("getOriginBillOp operationType = {} , isSave = {}", (Object)operationType, (Object)isSave);
        String operationKey = null;
        if (isSave) {
            operationType = "7";
        }
        DynamicObjectCollection billOpConfigCollection = TaskBillChildService.getInstance().query(taskBill, taskType, "entryentitybillop.ssc_auditop,entryentitybillop.srcoperation_key");
        for (DynamicObject billOpConfig : billOpConfigCollection) {
            String sscOperation = billOpConfig.getString("entryentitybillop.ssc_auditop");
            if (sscOperation == null || !sscOperation.equals(operationType)) continue;
            operationKey = billOpConfig.getString("entryentitybillop.srcoperation_key");
            break;
        }
        return operationKey;
    }

    public static OperationResult saveKDCCBillData(Map<String, String> map, Long taskBillId, Long taskTypeId, String operation) {
        String origin = map.get("origin");
        if (origin == null || ApproveOriginEnum.LIST.getValue().equals(origin)) {
            return null;
        }
        String subPageId = map.get("subPageId");
        String appId = map.get("appId");
        if (StringUtils.isEmpty((CharSequence)subPageId) || StringUtils.isEmpty((CharSequence)appId)) {
            LOG.info("subPageId is null or appId is null,stop ex");
            return null;
        }
        String operationKey = TaskApproveService.getOriginBillOp(taskBillId, taskTypeId, operation, false);
        if (StringUtils.isEmpty((CharSequence)operationKey)) {
            LOG.info("approve config is null,no ex");
            return null;
        }
        LOG.info("approve config is {}", (Object)operationKey);
        try {
            HashMap<String, String> variable = new HashMap<String, String>(1);
            variable.put("ishasright", String.valueOf(true));
            Map resultMap = (Map)DispatchServiceHelper.invokeBOSService((String)appId, (String)FormService.class.getSimpleName(), (String)"invokeOperationFromService", (Object[])new Object[]{subPageId, operationKey, variable});
            String opResultStr = (String)resultMap.get("operationResult");
            Object opResultObj = DataEntitySerializer.deSerializerFromString((String)opResultStr, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
            OperationResult opResult = (OperationResult)opResultObj;
            return opResult;
        }
        catch (Exception e) {
            LOG.error("Error on invoking \"{}\" operation", (Object)operationKey, (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6279\u8c03\u7528\u64cd\u4f5c\u62a5\u9519\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5355\u636e\u914d\u7f6e", (String)"TaskApproveService_2", (String)"ssc-hstc-business", (Object[])new Object[0]));
        }
    }

    public String transformRescan(List<Long> withdrawalIDList) {
        QFilter idFilter = new QFilter("id", "in", withdrawalIDList);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection withdrawalcols = TaskRescanReasonRepository.getInstance().getData("id,name", filters, null);
        StringBuilder withdrawalStr = new StringBuilder();
        if (withdrawalcols == null || withdrawalcols.isEmpty()) {
            return withdrawalStr.toString();
        }
        withdrawalStr.append(((DynamicObject)withdrawalcols.get(0)).getString("name"));
        for (int i = 1; i < withdrawalcols.size(); ++i) {
            withdrawalStr.append(';').append(((DynamicObject)withdrawalcols.get(i)).getString("name"));
        }
        return withdrawalStr.toString();
    }

    public static List<Map<String, Object>> setPauseRecord(Long taskid, boolean isHist) {
        QFilter jobItem = new QFilter("jobid", "=", (Object)taskid);
        QFilter opItem = QFilter.of((String)"operation = ? or operation = ?", (Object[])new Object[]{"3", "4"});
        QFilter[] filterItems = new QFilter[]{jobItem, opItem};
        String entityName = isHist ? "task_statechangehis" : "task_statechange";
        String selectProperties = "id,jobid,newjobstate,oldjobstate,changetime,message,operation,operatorid.id,operatorid.useropenid,operatorid.name,operatorid.picturefield";
        ArrayList<Map<String, Object>> approvalRecordItems = new ArrayList<Map<String, Object>>();
        try (DataSet pauseRecordDataSet = TaskStatechangeService.getInstance().queryCollPauserecord(entityName, selectProperties, filterItems);){
            Iterator it = pauseRecordDataSet.iterator();
            SimpleDateFormat longformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("group", "approved");
                item.put("groupDecisionType", "approve");
                ArrayList childrenItems = new ArrayList();
                HashMap<String, Object> childrenItem = new HashMap<String, Object>();
                childrenItem.put("openId", row.get("operatorid.useropenid"));
                if (row.get("operatorid.id") != null) {
                    Map userAvatarPath = UserServiceHelper.getUserAvatarPath(Collections.singletonList(Long.parseLong(row.get("operatorid.id").toString())), (boolean)true);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)((String)userAvatarPath.get(row.get("operatorid.id"))))) {
                        childrenItem.put("avatar", userAvatarPath.get(row.get("operatorid.id")));
                    } else {
                        childrenItem.put("avatar", COMMON_URL);
                    }
                }
                childrenItem.put("userName", row.get("operatorid.name"));
                childrenItem.put("decisionType", "approve");
                String operation = "";
                if ("3".equals(row.get("operation"))) {
                    operation = String.format(ResManager.loadKDString((String)"%s\uff1a\u6682\u6302", (String)"TaskApproveService_0", (String)"ssc-hstc-business", (Object[])new Object[0]), "");
                } else if ("4".equals(row.get("operation"))) {
                    operation = String.format(ResManager.loadKDString((String)"%s\uff1a\u53d6\u6d88\u6682\u6302", (String)"TaskApproveService_1", (String)"ssc-hstc-business", (Object[])new Object[0]), "");
                }
                childrenItem.put("resultName", operation);
                childrenItem.put("time", longformat.format(row.get("changetime")));
                childrenItem.put("message", row.get("message"));
                childrenItems.add(childrenItem);
                item.put("children", childrenItems);
                approvalRecordItems.add(item);
            }
        }
        catch (Exception exc) {
            LOG.error("error in queryDataSet ", (Throwable)exc);
        }
        return approvalRecordItems;
    }

    private static class InstanceHolder {
        private static final TaskApproveService INSTANCE = new TaskApproveService();

        private InstanceHolder() {
        }
    }
}

