/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.service;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.hstc.business.repository.TaskbillChildRepository;

public class TaskBillChildService {
    private static final Log LOG = LogFactory.getLog(TaskBillChildService.class);

    public static TaskBillChildService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public DynamicObject queryOne(DynamicObject task, String selectProperties) {
        DynamicObject t;
        boolean isQuality = task.containsProperty("qualitysamplelibrary.id") && task.getLong("qualitysamplelibrary.id") != 0L;
        DynamicObject dynamicObject = t = isQuality ? this.queryTask(task.getLong("sourcetaskid")) : task;
        if (t == null) {
            LOG.error("task is null,sourcetaskid:{}", (Object)task.getLong("sourcetaskid"));
            return null;
        }
        long taskTypeId = t.getLong("tasktypeid.id");
        long billTypeId = t.getLong("billtype.id");
        return this.queryOne(billTypeId, taskTypeId, selectProperties);
    }

    private DynamicObject queryTask(long sourceTaskId) {
        QFilter[] filterTB = new QFilter("id", "=", (Object)sourceTaskId).toArray();
        return QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"billtype.id, tasktypeid.id", (QFilter[])filterTB);
    }

    public DynamicObject queryOne(long taskBillId, long taskTypeId, String selectProperties) {
        QFilter[] filterTB = new QFilter("id", "=", (Object)taskBillId).toArray();
        DynamicObjectCollection childPKCol = QueryServiceHelper.query((String)"task_taskbill", (String)"entryentity.childpkid childpkid", (QFilter[])filterTB);
        List childPKs = childPKCol.stream().map(c -> c.getLong("childpkid")).collect(Collectors.toList());
        QFilter[] filterTT = new QFilter[]{new QFilter("id", "in", childPKs), new QFilter("tasktype", "=", (Object)taskTypeId)};
        return TaskbillChildRepository.getInstance().queryTaskbillChildData(selectProperties, filterTT);
    }

    public DynamicObjectCollection query(long taskBillId, long taskTypeId, String selectProperties) {
        QFilter[] filterTB = new QFilter("id", "=", (Object)taskBillId).toArray();
        DynamicObjectCollection childPKCol = QueryServiceHelper.query((String)"task_taskbill", (String)"entryentity.childpkid childpkid", (QFilter[])filterTB);
        List childPKs = childPKCol.stream().map(c -> c.getLong("childpkid")).collect(Collectors.toList());
        QFilter[] filterTT = new QFilter[]{new QFilter("id", "in", childPKs), new QFilter("tasktype", "=", (Object)taskTypeId)};
        return TaskbillChildRepository.getInstance().queryCollTaskbillChildData(selectProperties, filterTT);
    }

    private static class InstanceHolder {
        private static final TaskBillChildService INSTANCE = new TaskBillChildService();

        private InstanceHolder() {
        }
    }
}

