/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.hstc.business.repository.TaskHistoryRepository;
import kd.ssc.hstc.business.repository.TaskRepository;
import kd.ssc.hstc.business.repository.TaskbillRepository;
import kd.ssc.hstc.business.servicehelper.BosUserServiceHelper;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.util.DateUtils;
import kd.ssc.hstc.util.ObjectUtils;
import kd.ssc.hstc.util.QFilterCommonUtil;

public class TaskService {
    private static final Log LOGGER = LogFactory.getLog(TaskService.class);
    private static final String ALGOKEY_GETDECISIONITEMID = "kd.ssc.hstc.business.service.WorkflowService.getDecisionItemId";
    private static final String ENTITY_DECISIONITEMRELATIONREALATION = "task_decisionitem_re";
    private static final String ALGOKEY_BEFOREAPPROVALVALIDATE = "kd.ssc.hstc.business.service.WorkflowService.beforeApprovalValidate";

    public static TaskService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public DynamicObject queryTaskData(long taskId, String selectProperties, boolean processTask) {
        if (processTask) {
            return TaskRepository.getInstance().queryTaskData(taskId, selectProperties);
        }
        return TaskHistoryRepository.getInstance().queryTaskHistoryData(taskId, selectProperties);
    }

    public DynamicObjectCollection queryTaskData(QFilter[] filters, String selectProperties, boolean processTask) {
        if (processTask) {
            return TaskRepository.getInstance().queryTaskData(selectProperties, filters, null);
        }
        return TaskHistoryRepository.getInstance().queryTaskHistoryData(selectProperties, filters, null);
    }

    public boolean isCancelState(Long taskId) {
        QFilter qFilter = new QFilter("sourcetaskid", "=", (Object)taskId);
        DynamicObject taskHistoryDy = TaskHistoryRepository.getInstance().queryTaskHistoryData("state", new QFilter[]{qFilter});
        return taskHistoryDy != null && StringUtils.equals((CharSequence)TaskStateEnum.CANCEL.getValue(), (CharSequence)taskHistoryDy.getString("state"));
    }

    public DynamicObject queryTaskDataForShowTaskApprove(Long taskId, boolean processTask) {
        String selectFields = "id, sscid, sscid.id, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, personid.id, imagenumber,billtype.id, billtype.isembed, billtype.bindbill.number, billtype.bindform.number, billtype.isstoredindb,bizdata_tag, innermsg, apprevalmessage, decisionitem, qualitysamplelibrary.id, reformperson.id,unpassreasondesc, pendingopinion,pendingopinions.fbasedataid as pendingopinions, rescanopinion";
        if (processTask) {
            selectFields = selectFields + ", approveop, unpassreasondata";
        }
        return this.queryTaskData(taskId, selectFields, processTask);
    }

    public DynamicObject queryTaskDataForRealBill(Long taskId, boolean processTask) {
        return TaskService.getInstance().queryTaskData(taskId, "procinstid,billtype.externalerp.number,billlongid,tasktypeid.id,tasktypeid.qualityjudge,billtype.id", processTask);
    }

    public String queryRealBillId(Long taskId, boolean processTask) {
        DynamicObject taskDy = this.queryTaskDataForRealBill(taskId, processTask);
        return this.queryRealBillId(taskDy);
    }

    public String queryRealBillId(DynamicObject taskDy) {
        Long realbillid = taskDy.getLong("billlongid");
        String qualityjudge = taskDy.getString("tasktypeid.qualityjudge");
        if (StringUtils.equals((CharSequence)qualityjudge, (CharSequence)"4")) {
            long billtypeid = taskDy.getLong("billtype.id");
            DynamicObject taskbillDy = TaskbillRepository.getInstance().queryTaskbillData(billtypeid, "bindbill.number,taskpool.realbillnumber");
            Long billlongid = taskDy.getLong("billlongid");
            String entityNumber = taskbillDy.getString("bindbill.number");
            String realbillnumber = taskbillDy.getString("taskpool.realbillnumber");
            LOGGER.info("realbillnumber value is :{}", (Object)realbillnumber);
            if (StringUtils.isNotEmpty((CharSequence)realbillnumber)) {
                DynamicProperty property = MetadataServiceHelper.getDataEntityType((String)entityNumber).getProperty(realbillnumber);
                DynamicObject billDy = QueryServiceHelper.queryOne((String)entityNumber, (String)realbillnumber, (QFilter[])new QFilter[]{QFilterCommonUtil.idFilter((Object)billlongid)});
                if (billDy != null && property instanceof BasedataProp) {
                    realbillid = billDy.getLong(realbillnumber);
                } else if (billDy != null && property instanceof LongProp) {
                    realbillid = billDy.getLong(realbillnumber);
                } else {
                    LOGGER.info("realbillnumber property is not BasedataProp or LongProp :{}", (Object)property.getClass().getSimpleName());
                }
            }
        }
        return String.valueOf(realbillid);
    }

    public DynamicObject[] queryTask(String selectProperties, QFilter[] filters) {
        LOGGER.info("TaskQueryService_getTask, selectProperties={}", (Object)selectProperties);
        return TaskRepository.getInstance().queryTaskData(selectProperties, filters);
    }

    public DynamicObject[] queryTaskHistory(String selectProperties, QFilter[] filters) {
        LOGGER.info("TaskQueryService_getTask, selectProperties={}", (Object)selectProperties);
        return TaskHistoryRepository.getInstance().queryTaskHistory(selectProperties, filters);
    }

    public DynamicObjectCollection queryCollTask(String selectProperties, QFilter[] filters, String orderBy) {
        LOGGER.info("TaskQueryService_getTask, selectProperties={}", (Object)selectProperties);
        return TaskRepository.getInstance().queryTaskData(selectProperties, filters, orderBy);
    }

    public DynamicObject queryTaskById(String selectProperties, long id, boolean processTask) {
        if (StringUtils.isEmpty((CharSequence)selectProperties)) {
            selectProperties = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, personid.id, imagenumber,billtype.id, billtype.isembed, billtype.bindbill.number, billtype.bindform.number, billtype.isstoredindb,bizdata_tag, innermsg, apprevalmessage, decisionitem, qualitysamplelibrary.id, reformperson.id,unpassreasondesc, pendingopinion, rescanopinion";
        }
        if (processTask) {
            selectProperties = selectProperties + ", approveop, unpassreasondata";
            return TaskRepository.getInstance().queryTaskData(id, selectProperties);
        }
        return TaskHistoryRepository.getInstance().queryTaskHistoryData(id, selectProperties);
    }

    public DynamicObject queryTaskHistory(long historyTaskId, String selectProperties) {
        if (StringUtils.isEmpty((CharSequence)selectProperties)) {
            selectProperties = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, personid.id, imagenumber,billtype.id, billtype.isembed, billtype.bindbill.number, billtype.bindform.number, billtype.isstoredindb,bizdata_tag, innermsg, apprevalmessage, decisionitem, qualitysamplelibrary.id, reformperson.id,unpassreasondesc, pendingopinion, rescanopinion";
        }
        QFilter idFilter = QFilterCommonUtil.sourceTaskIdFilter((Object)historyTaskId);
        return TaskHistoryRepository.getInstance().queryTaskHistoryData(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject getTaskById(String selectProperties, long id, boolean processTask) {
        if (StringUtils.isEmpty((CharSequence)selectProperties)) {
            selectProperties = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, personid.id, imagenumber,billtype.id, billtype.isembed, billtype.bindbill.number, billtype.bindform.number, billtype.isstoredindb,bizdata_tag, innermsg, apprevalmessage, decisionitem, qualitysamplelibrary.id, reformperson.id,unpassreasondesc, pendingopinion, rescanopinion";
        }
        String entityName = "task_taskhistory";
        if (processTask) {
            entityName = "task_task";
            selectProperties = selectProperties + ", approveop, unpassreasondata";
        }
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{idFilter});
    }

    public DynamicObject getTaskHistory(long taskId, String selectProperties) {
        if (StringUtils.isEmpty((CharSequence)selectProperties)) {
            selectProperties = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, personid.id, imagenumber,billtype.id, billtype.isembed, billtype.bindbill.number, billtype.bindform.number, billtype.isstoredindb,bizdata_tag, innermsg, apprevalmessage, decisionitem, qualitysamplelibrary.id, reformperson.id,unpassreasondesc, pendingopinion, rescanopinion";
        }
        String entityName = "task_taskhistory";
        QFilter idFilter = new QFilter("sourcetaskid", "=", (Object)taskId);
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{idFilter});
    }

    public QFilter getCommonQFilter(long sscId, long userId) {
        QFilter qFilter = new QFilter("personid", "=", (Object)userId);
        if (sscId != 0L) {
            qFilter.and(new QFilter("sscid", "=", (Object)sscId));
        }
        qFilter.and(new QFilter("qualitysamplelibrary", "=", (Object)0L));
        return qFilter;
    }

    public int countTaskWaitdeal(long sscId) {
        QFilter qFilter = this.getCommonQFilter(sscId, RequestContext.getOrCreate().getCurrUserId());
        qFilter.and(new QFilter("pooltype", "=", (Object)"1"));
        return TaskRepository.getInstance().countTask(new QFilter[]{qFilter});
    }

    public int countTaskOuttime(long sscId) {
        QFilter qFilter = this.getCommonQFilter(sscId, RequestContext.getOrCreate().getCurrUserId());
        qFilter.and(new QFilter("pooltype", "=", (Object)"1"));
        qFilter.and(new QFilter("expirestate", "=", (Object)"2"));
        return TaskRepository.getInstance().countTask(new QFilter[]{qFilter});
    }

    public int countTaskPending(long sscId) {
        QFilter qFilter = this.getCommonQFilter(sscId, RequestContext.getOrCreate().getCurrUserId());
        qFilter.and(new QFilter("pooltype", "=", (Object)"1"));
        qFilter.and(new QFilter("state", "=", (Object)TaskStateEnum.PAUSE.getValue()));
        return TaskRepository.getInstance().countTask(new QFilter[]{qFilter});
    }

    public int countTaskTodaydone(long sscId) {
        QFilter qFilter = this.getCommonQFilter(sscId, RequestContext.getOrCreate().getCurrUserId());
        qFilter.and(new QFilter("pooltype", "=", (Object)"2"));
        Date today = DateUtils.getTodayTruncate();
        Date tomorrow = DateUtils.addDay((Date)today, (int)1);
        QFilter timeFilter = new QFilter("completetime", ">=", (Object)today);
        timeFilter.and("completetime", "<", (Object)tomorrow);
        return TaskHistoryRepository.getInstance().countTaskHistory(new QFilter[]{qFilter, timeFilter});
    }

    public int countTaskLastdaydone(long sscId) {
        QFilter qFilter = this.getCommonQFilter(sscId, RequestContext.getOrCreate().getCurrUserId());
        qFilter.and(new QFilter("pooltype", "=", (Object)"2"));
        Date today = DateUtils.getTodayTruncate();
        Date lastday = DateUtils.addDay((Date)today, (int)-1);
        QFilter timeFilter = new QFilter("completetime", ">=", (Object)lastday);
        timeFilter.and("completetime", "<", (Object)today);
        return TaskHistoryRepository.getInstance().countTaskHistory(new QFilter[]{qFilter, timeFilter});
    }

    public DataSet queryTaskDataSet(String selectProperties, QFilter[] idFilters) {
        ORM orm = ORM.create();
        return orm.queryDataSet(ALGOKEY_BEFOREAPPROVALVALIDATE, "task_task", selectProperties, idFilters);
    }

    public DataSet queryTaskDecisionItemReDataSet(String selectProperties, QFilter[] idFilters) {
        ORM orm = ORM.create();
        return orm.queryDataSet(ALGOKEY_GETDECISIONITEMID, ENTITY_DECISIONITEMRELATIONREALATION, selectProperties, idFilters);
    }

    public Tuple<String, BigDecimal>[] queryCostTimeByBillType(QFilter filter, boolean ifShowForLeader) {
        List<Tuple<Long, BigDecimal>> costTimeList = TaskHistoryRepository.getInstance().queryCostTimeByBillType(new QFilter[]{filter}, ifShowForLeader);
        List<Long> billtypeIds = costTimeList.stream().map(data -> (Long)data.item1).collect(Collectors.toList());
        Map<Long, DynamicObject> billtypeMap = TaskbillRepository.getInstance().queryTaskbillDatas(billtypeIds, "id,name");
        Tuple[] tupleArr = new Tuple[costTimeList.size()];
        for (int i = 0; i < costTimeList.size(); ++i) {
            Tuple<Long, BigDecimal> tuple = costTimeList.get(i);
            DynamicObject billtype = billtypeMap.get(tuple.item1);
            if (billtype == null) continue;
            tupleArr[i] = Tuple.create((Object)billtype.getString("name"), (Object)tuple.item2);
        }
        return tupleArr;
    }

    public List<Tuple<DynamicObject, BigDecimal>> queryRankTaskAmount(QFilter[] filters, boolean ifOrderDesc, List<Long> userIdList) {
        Map<Long, DynamicObject> personInfoMap;
        ArrayList<Tuple<DynamicObject, BigDecimal>> nameAmountList = new ArrayList<Tuple<DynamicObject, BigDecimal>>(userIdList.size());
        List<Tuple<Long, BigDecimal>> idAmountList = TaskHistoryRepository.getInstance().queryRankTaskAmount(filters, ifOrderDesc);
        if (CollectionUtils.isNotEmpty(idAmountList)) {
            List<Long> personIds = idAmountList.stream().map(data -> (Long)data.item1).collect(Collectors.toList());
            personIds.addAll(userIdList);
            personInfoMap = BosUserServiceHelper.queryBosUserInfos(personIds, "name");
            for (Tuple<Long, BigDecimal> tuple : idAmountList) {
                Long personId = (Long)tuple.item1;
                DynamicObject personInfo = personInfoMap.get(personId);
                if (personInfo != null) {
                    nameAmountList.add((Tuple<DynamicObject, BigDecimal>)Tuple.create((Object)personInfo, (Object)tuple.item2));
                }
                personInfoMap.remove(personId);
            }
        } else {
            personInfoMap = BosUserServiceHelper.queryBosUserInfos(userIdList, "name");
        }
        for (DynamicObject personInfo : personInfoMap.values()) {
            nameAmountList.add((Tuple<DynamicObject, BigDecimal>)Tuple.create((Object)personInfo, (Object)BigDecimal.ZERO));
        }
        return nameAmountList;
    }

    public List<Tuple<DynamicObject, BigDecimal>> queryRankTaskEfficiency(QFilter[] filters, boolean ifOrderDesc, boolean ifShowForLeader, List<Long> userIdList) {
        ArrayList<Tuple<DynamicObject, BigDecimal>> nameEfficiencyList = new ArrayList<Tuple<DynamicObject, BigDecimal>>(userIdList.size());
        List<Tuple<Long, BigDecimal>> idEfficiencyList = TaskHistoryRepository.getInstance().queryRankTaskEfficiency(filters, ifOrderDesc, ifShowForLeader);
        if (CollectionUtils.isNotEmpty(idEfficiencyList)) {
            List<Long> personIds = idEfficiencyList.stream().map(data -> (Long)data.item1).collect(Collectors.toList());
            personIds.addAll(userIdList);
            Map<Long, DynamicObject> personInfoMap = BosUserServiceHelper.queryBosUserInfos(personIds, "name");
            for (Tuple<Long, BigDecimal> tuple : idEfficiencyList) {
                Long personId = (Long)tuple.item1;
                DynamicObject personInfo = personInfoMap.get(personId);
                if (personInfo != null) {
                    nameEfficiencyList.add((Tuple<DynamicObject, BigDecimal>)Tuple.create((Object)personInfo, (Object)tuple.item2));
                }
                personInfoMap.remove(personId);
            }
        }
        return nameEfficiencyList;
    }

    public boolean checkIfForCurrentPerson(Long taskId) {
        Map<Long, Boolean> resultMap = this.checkIfForCurrentPerson(Lists.newArrayList((Object[])new Long[]{taskId}));
        return resultMap == null || resultMap.isEmpty();
    }

    public Map<Long, Boolean> checkIfForCurrentPerson(Collection<Long> taskIds) {
        DynamicObject[] taskInfos;
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        long currentUserId = RequestContext.getOrCreate().getCurrUserId();
        QFilter qFilter = new QFilter("id", "in", taskIds);
        for (DynamicObject taskInfo : taskInfos = TaskRepository.getInstance().queryTaskData("id,personid", new QFilter[]{qFilter})) {
            long personid = ObjectUtils.getLongValOfObject((Object)taskInfo.get("personid"));
            if (personid == currentUserId) continue;
            resultMap.put(taskInfo.getLong("id"), Boolean.FALSE);
        }
        return resultMap;
    }

    public boolean opValidateTaskIsHandlingState(IFormView formView, List<Long> taskIds) {
        if (taskIds == null || taskIds.size() == 0) {
            return false;
        }
        DynamicObject[] tasks = this.queryTask("state", new QFilter[]{new QFilter("id", "in", taskIds), new QFilter("personid", "=", (Object)RequestContext.getOrCreate().getCurrUserId())});
        if (taskIds.size() != tasks.length) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u5df2\u53d8\u5316\uff0c\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c", (String)"TaskService_0", (String)"ssc-hstc-business", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject task : tasks) {
            String state = task.getString("state");
            if (state.equals(TaskStateEnum.TO_BE_AUDIT.getValue())) continue;
            TaskStateEnum taskStateEnum = TaskStateEnum.getTaskState((String)state);
            formView.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4efb\u52a1\u4e0d\u5141\u8bb8\u8be5\u64cd\u4f5c", (String)"TaskService_1", (String)"ssc-hstc-business", (Object[])new Object[0]), Optional.ofNullable(taskStateEnum).map(TaskStateEnum::getName).orElse("")));
            return false;
        }
        return true;
    }

    private static class InstanceHolder {
        private static final TaskService INSTANCE = new TaskService();

        private InstanceHolder() {
        }
    }
}

