/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.ssc.hstc.business.repository.TaskPendingReasonRepository;
import kd.ssc.hstc.business.service.TaskService;

public class WorkflowService {
    private static final Log LOG = LogFactory.getLog(WorkflowService.class);
    public static final Pattern REGEX_PATTERN = Pattern.compile("\"circulate\":\"(.*?)\"");
    private static final String FIELD_TASK = "id, billtype, tasktypeid,sscid";

    public static WorkflowService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public boolean isCloseCirculate(Long taskId, boolean isHisTask) {
        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)taskId);
        if (taskInfo != null && StringUtils.isNotBlank((CharSequence)taskInfo.getControl())) {
            Map map = (Map)SerializationUtils.fromJsonString((String)taskInfo.getControl(), Map.class);
            String circulate = (String)map.get("circulate");
            return !Boolean.parseBoolean(circulate);
        }
        if (taskInfo == null && isHisTask) {
            Matcher matcher;
            DynamicObject[] control = BusinessDataServiceHelper.load((String)"wf_hitaskinst", (String)"control", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
            String circulate = null;
            for (DynamicObject controlValue : control) {
                circulate = (String)controlValue.get("control");
            }
            String circulateResult = "false";
            if (StringUtils.isNotEmpty(circulate) && (matcher = REGEX_PATTERN.matcher(circulate)).find()) {
                circulateResult = matcher.group(1);
            }
            return "false".equals(circulateResult);
        }
        return true;
    }

    public void viewFlowchart(String pageId, Object billId) {
        WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)billId);
    }

    public Set<Long> getPendingIdBybilltypeAndTasktype() {
        HashSet<Long> set = new HashSet<Long>(16);
        String selectField = "id";
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection collection = TaskPendingReasonRepository.getInstance().getPendingReason(selectField, new QFilter[]{enableFilter});
        for (int i = 0; i < collection.size(); ++i) {
            set.add(((DynamicObject)collection.get(i)).getLong("id"));
        }
        return set;
    }

    public <T> String transformPending(List<T> withdrawalIDList) {
        QFilter idFilter = new QFilter("id", "in", withdrawalIDList);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection collection = TaskPendingReasonRepository.getInstance().getPendingReason("id,name", filters);
        StringBuilder withdrawalStr = new StringBuilder();
        if (collection == null || collection.isEmpty()) {
            return withdrawalStr.toString();
        }
        withdrawalStr.append(((DynamicObject)collection.get(0)).getString("name"));
        for (int i = 1; i < collection.size(); ++i) {
            withdrawalStr.append(';').append(((DynamicObject)collection.get(i)).getString("name"));
        }
        return withdrawalStr.toString();
    }

    public static List<Long> getDecisionItemId(List<Long> taskIds) {
        ArrayList<Long> ret = new ArrayList<Long>();
        if (taskIds == null || taskIds.size() == 0) {
            return ret;
        }
        Map<String, List<Long>> taskInfoMap = WorkflowService.getTaskBillInfo(taskIds);
        List<Long> billTypeList = taskInfoMap.get("billtype");
        List<Long> takTypeList = taskInfoMap.get("tasktypeid");
        List<Long> sscidList = taskInfoMap.get("sscid");
        QFilter billTypeFilter = new QFilter("billtypeid", "in", billTypeList);
        QFilter taskTypeFilter = new QFilter("tasktypeid", "in", takTypeList);
        QFilter sscidFilter = new QFilter("ssccenter", "in", sscidList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filter = billTypeFilter.and(taskTypeFilter).and(sscidFilter).and(enableFilter);
        try (DataSet dsDecision = TaskService.getInstance().queryTaskDecisionItemReDataSet("decisionitem", filter.toArray());){
            for (Row item : dsDecision) {
                Long decisionitem = item.getLong("decisionitem");
                if (ret.contains(decisionitem)) continue;
                ret.add(decisionitem);
            }
        }
        return ret;
    }

    public static Map<String, List<Long>> getTaskBillInfo(List<Long> taskIds) {
        HashMap<String, List<Long>> retMap = new HashMap<String, List<Long>>();
        if (taskIds.size() == 0) {
            return retMap;
        }
        QFilter idFilter = new QFilter("id", "in", taskIds);
        ArrayList<Long> billTypeList = new ArrayList<Long>();
        ArrayList<Long> taskTypeList = new ArrayList<Long>();
        ArrayList<Long> sscList = new ArrayList<Long>();
        try (DataSet dsTask = TaskService.getInstance().queryTaskDataSet(FIELD_TASK, new QFilter[]{idFilter});){
            Long billType = 0L;
            Long taskType = 0L;
            for (Row item : dsTask) {
                billType = item.getLong("billtype");
                taskType = item.getLong("tasktypeid");
                Long sscid = item.getLong("sscid");
                if (!billTypeList.contains(billType)) {
                    billTypeList.add(billType);
                }
                if (!taskTypeList.contains(taskType)) {
                    taskTypeList.add(taskType);
                }
                if (sscList.contains(sscid)) continue;
                sscList.add(sscid);
            }
        }
        retMap.put("billtype", billTypeList);
        retMap.put("tasktypeid", taskTypeList);
        retMap.put("sscid", sscList);
        return retMap;
    }

    public static String processDefaultOpinion(long taskId) {
        return WorkflowService.processDefaultOpinion(taskId, true);
    }

    public static String processDefaultOpinion(long taskId, boolean flag) {
        QFilter businessFilter;
        Map<String, List<Long>> billInfo = WorkflowService.getTaskBillInfo(Collections.singletonList(taskId));
        List<Long> sscIds = billInfo.get("sscid");
        if (kd.bos.orm.util.CollectionUtils.isEmpty(sscIds)) {
            return "";
        }
        long sscId = billInfo.get("sscid").get(0);
        String val = flag ? "0" : "1";
        QFilter commonFilter = new QFilter("isdisplay", "=", (Object)Boolean.TRUE).and("approvaloperation", "=", (Object)val);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"task_appropinions", (String)"opinions", (QFilter[])new QFilter[]{commonFilter, businessFilter = new QFilter("sscid", "=", (Object)sscId)});
        if (dy == null) {
            return "";
        }
        return dy.getString("opinions");
    }

    public static Map<String, ApprovalRecordItem> getLatestApprovalRecordMap(String billId) {
        HashMap<String, ApprovalRecordItem> latestApprovalRecordMap = new HashMap<String, ApprovalRecordItem>(8);
        List approvalRecordGroupList = WorkflowServiceHelper.getAllApprovalRecord((String)billId);
        if (CollectionUtils.isNotEmpty((Collection)approvalRecordGroupList)) {
            for (IApprovalRecordGroup approvalRecordGroup : approvalRecordGroupList) {
                List iApprovalRecordItemList = approvalRecordGroup.getChildren();
                WorkflowService.setIApprovalRecordItem(latestApprovalRecordMap, iApprovalRecordItemList);
            }
        }
        return latestApprovalRecordMap;
    }

    private static void setIApprovalRecordItem(Map<String, ApprovalRecordItem> latestApprovalRecordMap, List<IApprovalRecordItem> iApprovalRecordItemList) {
        if (CollectionUtils.isNotEmpty(iApprovalRecordItemList)) {
            for (IApprovalRecordItem iApprovalRecordItem : iApprovalRecordItemList) {
                String activityId = iApprovalRecordItem.getActivityId();
                ApprovalRecordItem oldItem = latestApprovalRecordMap.get(activityId);
                if (oldItem != null) {
                    String time1 = oldItem.getTime();
                    String time2 = iApprovalRecordItem.getTime();
                    if (time2.compareTo(time1) <= 0) continue;
                    latestApprovalRecordMap.put(activityId, (ApprovalRecordItem)iApprovalRecordItem);
                    continue;
                }
                latestApprovalRecordMap.put(activityId, (ApprovalRecordItem)iApprovalRecordItem);
            }
        }
    }

    private static class InstanceHolder {
        private static final WorkflowService INSTANCE = new WorkflowService();

        private InstanceHolder() {
        }
    }
}

