/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.servicehelper;

import com.google.common.collect.Maps;
import java.util.HashMap;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.DispatchServiceHelper;

public class HSTCServiceHelper {
    private static final String CLOUD_HR = "hr";
    private static final String CLOUD_ODC = "odc";
    private static final String CLOUD_HRMP = "hrmp";
    private static final String CLOUD_SWC = "swc";
    private static final String CLOUD_SSC = "ssc";
    private static final String CLOUD_SIHC = "sihc";
    private static final String ISHARESERVICE = "IShareService";
    private static final String GET_BUTTON_VIEW_BY_ACTIVITY_ID = "getButtonViewByActivityId";

    public static <T> T invokeHRService(String appId, String serviceName, String methodName, Object ... paras) {
        return HSTCServiceHelper.invokeBizService(CLOUD_HR, appId, serviceName, methodName, paras);
    }

    public static <T> T invokeSIHCService(String appId, String serviceName, String methodName, Object ... paras) {
        return HSTCServiceHelper.invokeBizService(CLOUD_SIHC, appId, serviceName, methodName, paras);
    }

    public static <T> T invokeODCService(String appId, String serviceName, String methodName, Object ... paras) {
        return HSTCServiceHelper.invokeBizService(CLOUD_ODC, appId, serviceName, methodName, paras);
    }

    public static <T> T invokeHRMPService(String appId, String serviceName, String methodName, Object ... paras) {
        return HSTCServiceHelper.invokeBizService(CLOUD_HRMP, appId, serviceName, methodName, paras);
    }

    public static <T> T invokeSWCService(String appId, String serviceName, String methodName, Object ... paras) {
        return HSTCServiceHelper.invokeBizService(CLOUD_SWC, appId, serviceName, methodName, paras);
    }

    public static <T> T invokeSSCService(String appId, String serviceName, String methodName, Object ... paras) {
        return HSTCServiceHelper.invokeBizService(CLOUD_SSC, appId, serviceName, methodName, paras);
    }

    public static <T> T invokeBizService(String cloudId, String appId, String serviceName, String methodName, Object ... paras) {
        return (T)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])paras);
    }

    public static <T> T invokeBizShareService(Long activityId, String activityNumber) {
        String formId = MetadataDao.getIdByNumber((String)activityNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        String appId = formMeta.getBizappId();
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String appNumber = appInfo.getNumber().toLowerCase();
        String cloudNumber = appInfo.getCloudNum().toLowerCase();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        paramMap.put("activityId", activityId);
        paramMap.put("activityNumber", activityNumber);
        return (T)DispatchServiceHelper.invokeBizService((String)cloudNumber, (String)appNumber, (String)ISHARESERVICE, (String)GET_BUTTON_VIEW_BY_ACTIVITY_ID, (Object[])new Object[]{paramMap});
    }

    public static <T> T invokeBizOperation(String pageNumber, String pageId, String opkey, OperateOption operateOption) {
        String formId = MetadataDao.getIdByNumber((String)pageNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        String appId = formMeta.getBizappId();
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String appNumber = appInfo.getNumber().toLowerCase();
        String cloudNumber = appInfo.getCloudNum().toLowerCase();
        return (T)DispatchServiceHelper.invokeBizService((String)cloudNumber, (String)appNumber, (String)ISHARESERVICE, (String)"invokeOperation", (Object[])new Object[]{pageId, opkey, operateOption});
    }
}

