/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.hstc.business.servicehelper.HSTCServiceHelper;

public class SSCServiceHelper {
    private static final String APPID_TASK = "task";
    private static final String APPID_HSTC = "hstc";
    private static final Log log = LogFactory.getLog(SSCServiceHelper.class);

    public static Map<String, Object> autoPendTask(Long taskId) {
        String reason = ResManager.loadKDString((String)"\u81ea\u52a8\u6682\u6302", (String)"SSCServiceHelper_0", (String)"ssc-hstc-business", (Object[])new Object[0]);
        ArrayList pendingOpinionList = Lists.newArrayList((Object[])new Long[]{1950795026489448448L});
        return SSCServiceHelper.pendTask(taskId, reason, pendingOpinionList);
    }

    public static Map<String, Object> pendTask(Long taskId, String reason, List<Long> pendingOpinionList) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)5);
        paramMap.put("taskId", taskId);
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        paramMap.put("currentPersonId", currUserId);
        paramMap.put("operatorId", currUserId);
        paramMap.put("reason", reason);
        paramMap.put("pendingOpinionList", pendingOpinionList);
        paramMap.put("origin", "2");
        long startTime = System.currentTimeMillis();
        Map resultMap = (Map)SSCServiceHelper.invokeSSCTaskService("ITaskService", "taskApproveByPend", paramMap);
        long endTime = System.currentTimeMillis();
        log.info("SSCServiceHelper pendTask\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
        return resultMap;
    }

    public static Map<String, Object> cancelPendTask(Long taskId) {
        return SSCServiceHelper.cancelPendTask(taskId, true);
    }

    public static Map<String, Object> cancelPendTask(Long taskId, boolean ifAutoCancel) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)4);
        paramMap.put("taskId", taskId);
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        paramMap.put("currentPersonId", currUserId);
        paramMap.put("operatorId", currUserId);
        paramMap.put("origin", "2");
        if (ifAutoCancel) {
            paramMap.put("cancelType", "autoCancel");
        }
        long startTime = System.currentTimeMillis();
        Map resultMap = (Map)SSCServiceHelper.invokeSSCTaskService("ITaskService", "taskApproveByCancelPend", paramMap);
        long endTime = System.currentTimeMillis();
        log.info("SSCServiceHelper cancelPendTask1\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
        return resultMap;
    }

    public static Map<String, Object> cancelPendTask(Long taskId, boolean ifAutoCancel, Map<String, Object> paramMap) {
        if (paramMap == null) {
            paramMap = Maps.newHashMapWithExpectedSize((int)4);
        }
        paramMap.put("taskId", taskId);
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        paramMap.put("currentPersonId", currUserId);
        paramMap.put("operatorId", currUserId);
        paramMap.put("origin", "1");
        if (ifAutoCancel) {
            paramMap.put("cancelType", "autoCancel");
        }
        long startTime = System.currentTimeMillis();
        Map resultMap = (Map)SSCServiceHelper.invokeSSCTaskService("ITaskService", "taskApproveByCancelPend", paramMap);
        long endTime = System.currentTimeMillis();
        log.info("SSCServiceHelper cancelPendTask2\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
        return resultMap;
    }

    public static Map<String, Object> taskApproveSubmit(Map<String, Object> paramMap) {
        long startTime = System.currentTimeMillis();
        Map map = (Map)SSCServiceHelper.invokeSSCTaskService("ITaskService", "taskApproveSubmit", paramMap);
        long endTime = System.currentTimeMillis();
        log.info("SSCServiceHelper taskApproveSubmit\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
        return map;
    }

    public static <T> T invokeSSCTaskService(String serviceName, String methodName, Object ... paras) {
        return HSTCServiceHelper.invokeSSCService(APPID_TASK, serviceName, methodName, paras);
    }

    public static <T> T invokeHSTCService(String serviceName, String methodName, Object ... paras) {
        return HSTCServiceHelper.invokeSSCService(APPID_HSTC, serviceName, methodName, paras);
    }
}

