/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.task;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.hstc.business.task.PermService;
import kd.ssc.hstc.business.task.ShareAuthService;

public class AppHomeService {
    public static AppHomeService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public Set<Long> getHRShareOrgsLeader(long userId) {
        HashSet<Long> allShareOrgSet = new HashSet<Long>();
        return allShareOrgSet;
    }

    public static boolean isOpenTeamleader(String orgId) {
        return PermService.getBooleanParam("usegrouptl", Long.parseLong(orgId), false);
    }

    public boolean ifShowLeaderHomePage(long userId) {
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)userId);
        if (isSuperUser) {
            return true;
        }
        Set<Long> shareOrgIds = ShareAuthService.getInstance().getHRShare("hstc_apphomeadmin", "hstc");
        if (shareOrgIds.size() > 0) {
            Set<Long> orgs = PermService.getOrgByUserAndRole(userId, "4AU3GIWF6WFW", "4AU6VRNLI2LU");
            boolean adminRole = shareOrgIds.retainAll(orgs);
            if (adminRole) {
                return true;
            }
            for (Long sid : shareOrgIds) {
                if (AppHomeService.isOpenTeamleader(String.valueOf(sid))) continue;
                return true;
            }
            return AppHomeService.isTeamleader(shareOrgIds, userId);
        }
        return false;
    }

    public static boolean isTeamleader(Collection<Long> orgIds, Long userId) {
        QFilter qFilter = new QFilter("createorg", "in", orgIds);
        qFilter.and("entryentity.userfield", "=", (Object)userId);
        qFilter.and("entryentity.teamleader", "=", (Object)Boolean.TRUE);
        DynamicObject[] groups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        return groups != null && groups.length != 0;
    }

    private static class InstanceHolder {
        private static final AppHomeService INSTANCE = new AppHomeService();

        private InstanceHolder() {
        }
    }
}

