/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.hstc.business.task.AppHomeService;

public class PermService {
    public static PermService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static boolean isAdminRole(Collection<Long> sscIds, Long userId, String ... roleId) {
        if (sscIds == null || sscIds.isEmpty() || roleId.length == 0) {
            return false;
        }
        Set<Long> orgs = PermService.getOrgByUserAndRole(userId, roleId);
        for (Long sscId : sscIds) {
            if (!AppHomeService.isOpenTeamleader(String.valueOf(sscId)) || PermissionServiceHelper.isSuperUser((long)userId)) {
                return true;
            }
            if (!orgs.contains(sscId)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdminRole(String sscId, Long userId, String ... roleId) {
        if (sscId == null || roleId.length == 0) {
            return false;
        }
        if (!AppHomeService.isOpenTeamleader(sscId) || PermissionServiceHelper.isSuperUser((long)userId)) {
            return true;
        }
        Set<Long> orgs = PermService.getOrgByUserAndRole(userId, roleId);
        return orgs.contains(Long.valueOf(sscId));
    }

    public static boolean getBooleanParam(String paramKey, long orgId, boolean defVal) {
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(orgId), Long.valueOf(0L));
        Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramKey);
        boolean result = defVal;
        if (null != params) {
            result = (Boolean)params;
        }
        return result;
    }

    public static Set<Long> getOrgByUserAndRole(Long userId, String ... roleId) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"perm_userrole", (String)"role,org,includesuborg", (QFilter[])new QFilter("user", "=", (Object)userId).and(new QFilter("role", "in", (Object)roleId)).toArray());
        if (collection == null || collection.isEmpty()) {
            return new HashSet<Long>();
        }
        HashSet<Long> resultSet = new HashSet<Long>(collection.size());
        ArrayList<Long> orgIncludeSubOrg = new ArrayList<Long>();
        for (DynamicObject obj : collection) {
            Long orgId = obj.getLong("org");
            resultSet.add(orgId);
            if (!obj.getBoolean("includesuborg")) continue;
            orgIncludeSubOrg.add(orgId);
        }
        List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgIncludeSubOrg, (boolean)false);
        resultSet.addAll(allSubordinateOrgs);
        return resultSet;
    }

    public static List<Long> getAllPermSSC(Long userId, String appKey, String entityName) {
        ArrayList<Long> sscList = new ArrayList<Long>(16);
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"12", (String)appKey, (String)entityName, (String)"47150e89000000ac", (boolean)true);
        QFilter qFilter = hasPermOrgs.hasAllOrgPerm() || PermissionServiceHelper.isSuperUser((long)userId) ? null : new QFilter("id", "in", (Object)hasPermOrgs.getHasPermOrgs());
        QFilter qFilter2 = new QFilter("fisscc", "=", (Object)Character.valueOf('1'));
        QFilter[] filters = new QFilter[]{qFilter, qFilter2};
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"getAllPermSSC", (String)"bos_org", (String)"id,name", (QFilter[])filters, null);){
            for (Row row : orgDataSet) {
                sscList.add(row.getLong(0));
            }
        }
        return sscList;
    }

    private static class InstanceHolder {
        private static final PermService INSTANCE = new PermService();

        private InstanceHolder() {
        }
    }
}

