/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.task;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.hstc.business.duty.DutyManageService;

public class ShareAuthService {
    private static final Log LOGGER = LogFactory.getLog(ShareAuthService.class);
    private static final long SHARE_ORG = 12L;

    public static ShareAuthService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public Set<Long> getHRShare(String entityName, String appId) {
        Set<Long> userHasPerShareOrg = this.getUserHasPerShareOrg(entityName, appId);
        Set<Long> orgSet = DutyManageService.getInstance().getOrgSet("3");
        HashSet<Long> resultSet = new HashSet<Long>(orgSet);
        resultSet.retainAll(userHasPerShareOrg);
        return resultSet;
    }

    public Set<Long> getUserHasPerShareOrg(String entityName, String appId) {
        if (StringUtils.isEmpty((CharSequence)appId)) {
            appId = "ssc";
        }
        List allShareOrgList = OrgUnitServiceHelper.getAllOrgByViewId((long)12L, (boolean)false);
        LOGGER.info("ShareAuthService_getUserHasPerOrgId_{}_{}", (Object)entityName, (Object)allShareOrgList.size());
        HashSet<Long> allShareOrgSet = new HashSet<Long>(allShareOrgList);
        if (allShareOrgList.isEmpty()) {
            return new HashSet<Long>();
        }
        HasPermOrgResult hasOrg = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)String.valueOf(12L), (String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)entityName, (String)"47150e89000000ac");
        if (hasOrg != null) {
            if (hasOrg.hasAllOrgPerm()) {
                LOGGER.info("ShareAuthService_hasAllOrgPerm");
                return allShareOrgSet;
            }
            List hasPermOrgList = hasOrg.getHasPermOrgs();
            if (hasPermOrgList != null && !hasPermOrgList.isEmpty()) {
                HashSet hasPermOrgSet = new HashSet(hasPermOrgList);
                HashSet<Long> resultSet = new HashSet<Long>(allShareOrgSet);
                resultSet.retainAll(hasPermOrgSet);
                return resultSet;
            }
        }
        return new HashSet<Long>();
    }

    public long getUserHasPerOrgId(String entityName, String appId) {
        Set<Long> userHasPerShareOrg = this.getUserHasPerShareOrg(entityName, appId);
        if (userHasPerShareOrg.isEmpty()) {
            return 0L;
        }
        long userOrgID = RequestContext.get().getOrgId();
        if (userHasPerShareOrg.contains(userOrgID)) {
            return userOrgID;
        }
        return userHasPerShareOrg.stream().min(Long::compareTo).orElse(0L);
    }

    private static class InstanceHolder {
        private static final ShareAuthService INSTANCE = new ShareAuthService();

        private InstanceHolder() {
        }
    }
}

