/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.hstc.business.repository.TaskRepository;
import kd.ssc.hstc.business.task.UserGroupService;
import kd.ssc.hstc.common.TaskPoolTypeEnum;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.util.DateUtils;
import kd.ssc.hstc.util.ObjectUtils;

public class TaskIndexDataService {
    private static final Log LOGGER = LogFactory.getLog(TaskIndexDataService.class);

    public static TaskIndexDataService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static Map<String, Long> getIndexData(Long sscid, String groupId, boolean isSysAdminAndAllRight) {
        HashMap<String, Long> dataMap = new HashMap<String, Long>();
        String entityName = "task_indexdata_update";
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscid);
        if (groupId != null && !"-1".equals(groupId)) {
            shareCenterFilter.and("usergroup.id", "=", (Object)Long.parseLong(groupId));
        } else if (!isSysAdminAndAllRight) {
            QFilter leaderGroupFilter = new QFilter("usergroup.id", "!=", (Object)0L);
            String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
            Set<Long> manageGroupSet = UserGroupService.getManageGroup(String.valueOf(sscid), currUserId);
            QFilter leaderGroupFilter2 = new QFilter("usergroup", "in", manageGroupSet);
            shareCenterFilter.and(leaderGroupFilter);
            shareCenterFilter.and(leaderGroupFilter2);
        }
        try {
            DataSet dSet = QueryServiceHelper.queryDataSet((String)"TaskIndexDataUtil.getIndexData()", (String)entityName, (String)"id,propname,propvalue,sscid,usergroup", (QFilter[])new QFilter[]{shareCenterFilter}, null);
            dSet = dSet.select(new String[]{"id", "propname", "propvalue"}).groupBy(new String[]{"propname"}).sum("propvalue").finish();
            dSet = dSet.select(new String[]{"propname", "propvalue"});
            for (Row row : dSet) {
                dataMap.put(row.getString("propname"), row.getLong("propvalue"));
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        return dataMap;
    }

    public static int getTaskNumAssignError(Long sscid, String groupId, boolean isSysAdminAndAllRight) {
        QFilter shareCenterFilter = TaskIndexDataService.getTaskQFilterForLeader(sscid, groupId, isSysAdminAndAllRight);
        QFilter waitassignFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        QFilter stateFilter = new QFilter("state", "=", (Object)TaskStateEnum.DIS_EXCEPTION.getValue());
        return TaskRepository.getInstance().countTask(new QFilter[]{shareCenterFilter, waitassignFilter, stateFilter});
    }

    public static int getTaskNumPending(Long sscid, String groupId, boolean isSysAdminAndAllRight) {
        QFilter shareCenterFilter = TaskIndexDataService.getTaskQFilterForLeader(sscid, groupId, isSysAdminAndAllRight);
        QFilter waitassignFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter stateFilter = new QFilter("state", "=", (Object)TaskStateEnum.PAUSE.getValue());
        return TaskRepository.getInstance().countTask(new QFilter[]{shareCenterFilter, waitassignFilter, stateFilter});
    }

    public static int getTaskNumWaitdeal(Long sscid, String groupId, boolean isSysAdminAndAllRight) {
        QFilter shareCenterFilter = TaskIndexDataService.getTaskQFilterForLeader(sscid, groupId, isSysAdminAndAllRight);
        QFilter waitassignFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter stateFilter = new QFilter("state", "=", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
        return TaskRepository.getInstance().countTask(new QFilter[]{shareCenterFilter, waitassignFilter, stateFilter});
    }

    public static QFilter getTaskQFilterForLeader(Long sscid, String groupId, boolean isSysAdminAndAllRight) {
        QFilter shareCenterFilter = new QFilter("sscid", "=", (Object)sscid);
        if (groupId != null && !"-1".equals(groupId)) {
            shareCenterFilter.and("usergroup", "=", (Object)Long.parseLong(groupId));
        } else if (!isSysAdminAndAllRight) {
            String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
            Set<Long> manageGroupSet = UserGroupService.getManageGroup(String.valueOf(sscid), currUserId);
            if (ObjectUtils.isEmpty(manageGroupSet)) {
                shareCenterFilter.and(new QFilter("usergroup", "!=", (Object)0L));
            } else {
                shareCenterFilter.and(new QFilter("usergroup", "in", manageGroupSet));
            }
        }
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)0L);
        shareCenterFilter.and(notQuaCheckTask);
        return shareCenterFilter;
    }

    public static Map<String, Integer> getSaleIndexData(Long userid, Long sscid) {
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        String entityName = "task_saleindexdata_update";
        QFilter shareCenterFilter = new QFilter("user.id", "=", (Object)userid);
        QFilter sscFilter = new QFilter("sscid", "=", (Object)sscid);
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"TaskIndexDataUtil.getIndexData()", (String)entityName, (String)"id,propname,propvalue,user", (QFilter[])new QFilter[]{shareCenterFilter, sscFilter}, null);){
            for (Row row : dSet) {
                dataMap.put(row.getString("propname"), row.getInteger("propvalue"));
            }
        }
        return dataMap;
    }

    public static DataSet getTaskNumDaily(Date startDate, Date endDate, Long userID, Long sscId, boolean isQuality) throws KDException {
        QFilter[] qFilters;
        startDate = DateUtils.truncateDate((Date)startDate);
        endDate = DateUtils.truncateDate((Date)DateUtils.addDay((Date)endDate, (int)1));
        QFilter timeFilter = new QFilter("date", ">=", (Object)startDate);
        timeFilter.and(new QFilter("date", "<", (Object)endDate));
        QFilter sscFilter = new QFilter("sscid", "=", (Object)sscId);
        QFilter isQuaFilter = isQuality ? new QFilter("isquality", "=", (Object)Character.valueOf('1')) : new QFilter("isquality", "=", (Object)Character.valueOf('0'));
        if (userID == null) {
            qFilters = new QFilter[]{timeFilter, isQuaFilter, sscFilter};
        } else {
            QFilter userFilter = new QFilter("user", "=", (Object)userID);
            qFilters = new QFilter[]{userFilter, timeFilter, isQuaFilter, sscFilter};
        }
        String algoKey = "TaskIndexDataUtil.getPersonTaskNumDaily()";
        String entityName = "task_saleindex_avgdaily";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,user,normalnum,expirenum,date", (QFilter[])qFilters, null);
    }

    public static QFilter getTaskefficiencyQFilter(Date startDate, Date endDate, Long sscid) {
        return TaskIndexDataService.getTaskHistoryQFilter(sscid, startDate, endDate);
    }

    public static QFilter getTaskHistoryQFilter(Long sscid, Date startDate, Date endDate) {
        startDate = DateUtils.truncateDate((Date)startDate);
        endDate = DateUtils.truncateDate((Date)DateUtils.addDay((Date)endDate, (int)1));
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscid);
        QFilter receivetimeFilter = new QFilter("completetime", ">=", (Object)startDate);
        receivetimeFilter.and(new QFilter("completetime", "<", (Object)endDate));
        shareCenterFilter.and(receivetimeFilter);
        QFilter pooltypeFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        shareCenterFilter.and(pooltypeFilter);
        QFilter ishandledFilter = new QFilter("ishandled", "=", (Object)Character.valueOf('0'));
        shareCenterFilter.and(ishandledFilter);
        QFilter notAutoProcess = new QFilter("autoprocess", "=", (Object)"0");
        shareCenterFilter.and(notAutoProcess);
        return shareCenterFilter;
    }

    public static QFilter getTaskHistoryQFilterNoTruncate(Long sscid, Date startDate, Date endDate) {
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscid);
        QFilter receivetimeFilter = new QFilter("completetime", ">=", (Object)startDate);
        receivetimeFilter.and(new QFilter("completetime", "<=", (Object)endDate));
        shareCenterFilter.and(receivetimeFilter);
        QFilter pooltypeFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        shareCenterFilter.and(pooltypeFilter);
        QFilter ishandledFilter = new QFilter("ishandled", "=", (Object)Character.valueOf('0'));
        shareCenterFilter.and(ishandledFilter);
        QFilter notAutoProcess = new QFilter("autoprocess", "=", (Object)"0");
        shareCenterFilter.and(notAutoProcess);
        return shareCenterFilter;
    }

    public static QFilter getTaskQFilter(Long sscid) {
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscid);
        QFilter notAutoProcess = new QFilter("autoprocess", "=", (Object)"0");
        shareCenterFilter.and(notAutoProcess);
        return shareCenterFilter;
    }

    public static QFilter getUserQFilter(Long sscid, long usergroupId, boolean isShowForLeader, boolean isSysAdminAndAllRight) {
        QFilter qFilterUser = null;
        if (usergroupId != -1L) {
            qFilterUser = new QFilter("usergroup", "=", (Object)usergroupId);
        } else if (isShowForLeader) {
            if (!isSysAdminAndAllRight) {
                qFilterUser = new QFilter("usergroup", "!=", (Object)0L);
                String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
                Set<Long> manageGroupSet = UserGroupService.getManageGroup(String.valueOf(sscid), currUserId);
                if (ObjectUtils.isEmpty(manageGroupSet)) {
                    qFilterUser.and(new QFilter("usergroup", "in", manageGroupSet));
                }
            }
        } else {
            qFilterUser = new QFilter("personid", "=", (Object)RequestContext.getOrCreate().getCurrUserId());
        }
        return qFilterUser;
    }

    public DataSet getTaskefficiencyDSet(QFilter qFilter, Long userId) {
        QFilter userFilter = new QFilter("personid.id", "=", (Object)userId);
        String selectFields = "personid.id as personid, pooltype, coefficient, costwaittime, firstcostwaittime, completetime";
        DataSet taskefficiencyDs = QueryServiceHelper.queryDataSet((String)"getTaskefficiencyDSet", (String)"task_taskhistory", (String)selectFields, (QFilter[])new QFilter[]{userFilter, qFilter}, null);
        if (taskefficiencyDs != null) {
            taskefficiencyDs = taskefficiencyDs.select(new String[]{"personid", "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "completetime", "(case when costwaittime is null or costwaittime = 0 then 0.02 else costwaittime end) as costwaittime"});
        }
        return taskefficiencyDs;
    }

    public DataSet getTaskefficiencyDSet(QFilter qFilter, Long sscid, Long usergroupId, boolean isSysAdminAndAllRight) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(4);
        qfList.add(qFilter);
        if (usergroupId != null && usergroupId != -1L) {
            QFilter groupFilter = new QFilter("usergroup.id", "=", (Object)usergroupId);
            qfList.add(groupFilter);
        } else if (!isSysAdminAndAllRight) {
            QFilter leaderGroupFilter = new QFilter("usergroup.id", "!=", (Object)0L);
            String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
            Set<Long> manageGroupSet = UserGroupService.getManageGroup(String.valueOf(sscid), currUserId);
            QFilter leaderGroupFilter2 = new QFilter("usergroup", "in", manageGroupSet);
            qfList.add(leaderGroupFilter);
            qfList.add(leaderGroupFilter2);
        }
        String selectFields = "personid.id as personid, pooltype, coefficient, costwaittime, firstcostwaittime, completetime";
        DataSet taskefficiencyDs = QueryServiceHelper.queryDataSet((String)"getTaskefficiencyDSet", (String)"task_taskhistory", (String)selectFields, (QFilter[])qfList.toArray(new QFilter[0]), null);
        if (taskefficiencyDs != null) {
            taskefficiencyDs = taskefficiencyDs.select(new String[]{"personid", "(case when coefficient = 0 then 1 else coefficient end) as coefficient", "completetime", "(case when firstcostwaittime is null or firstcostwaittime = 0 then 0.02 else firstcostwaittime end) as costwaittime"});
        }
        return taskefficiencyDs;
    }

    public static DataSet getTaskCountSet(Long sscid, Long userId) {
        String algoKey = "TaskIndexDataUtil.getTaskCountSet()";
        String entityName = "task_indexdata_update_ext";
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscid);
        shareCenterFilter.and("user.id", "=", (Object)userId);
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"user.id as personid,taskcount,taskamount,costwaittime,taskefficiency", (QFilter[])new QFilter[]{shareCenterFilter}, null).groupBy(new String[]{"personid"}).sum("taskcount").sum("taskamount").sum("costwaittime").finish();
        return ds.select(new String[]{"personid", "taskcount", "taskamount", "(taskamount/costwaittime) as taskefficiency"});
    }

    public static DataSet getTaskCountSet(Long sscid, String usergroupId, boolean isSysAdminAndAllRight) {
        String algoKey = "TaskIndexDataUtil.getTaskCountSet()";
        String entityName = "task_indexdata_update_ext";
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscid);
        if (usergroupId != null && !"-1".equals(usergroupId)) {
            shareCenterFilter.and("usergroup.id", "=", (Object)Long.parseLong(usergroupId));
        } else if (!isSysAdminAndAllRight) {
            QFilter leaderGroupFilter = new QFilter("usergroup.id", "!=", (Object)0L);
            String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
            Set<Long> manageGroupSet = UserGroupService.getManageGroup(String.valueOf(sscid), currUserId);
            QFilter leaderGroupFilter2 = new QFilter("usergroup", "in", manageGroupSet);
            shareCenterFilter.and(leaderGroupFilter);
            shareCenterFilter.and(leaderGroupFilter2);
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"user.id as personid,taskcount,taskamount,costwaittime,taskefficiency", (QFilter[])new QFilter[]{shareCenterFilter}, null).groupBy(new String[]{"personid"}).sum("taskcount").sum("taskamount").sum("costwaittime").finish();
        return ds.select(new String[]{"personid", "taskcount", "taskamount", "(taskamount/costwaittime) as taskefficiency"});
    }

    public static BigDecimal getBaseYMaxValue(BigDecimal currMaxValue) {
        BigDecimal baseParam = currMaxValue.floatValue() <= 1.0f ? new BigDecimal(1) : (currMaxValue.floatValue() <= 10.0f ? new BigDecimal(5) : (currMaxValue.floatValue() <= 20.0f ? new BigDecimal(10) : (currMaxValue.floatValue() <= 100.0f ? new BigDecimal("25.0") : (currMaxValue.floatValue() <= 500.0f ? new BigDecimal("50.0") : (currMaxValue.floatValue() <= 1000.0f ? new BigDecimal("100.0") : (currMaxValue.floatValue() <= 5000.0f ? new BigDecimal("500.0") : (currMaxValue.floatValue() <= 10000.0f ? new BigDecimal("1000.0") : (currMaxValue.floatValue() <= 50000.0f ? new BigDecimal("5000.0") : (currMaxValue.floatValue() <= 100000.0f ? new BigDecimal("10000.0") : new BigDecimal("50000.0"))))))))));
        return !currMaxValue.equals(BigDecimal.ZERO) && currMaxValue.remainder(baseParam).equals(BigDecimal.ZERO) ? currMaxValue : baseParam.multiply(new BigDecimal(currMaxValue.divide(baseParam, 2, 4).intValue() + 1));
    }

    public static int getBaseYMaxValue(int currMaxValue) {
        int baseParam = currMaxValue <= 20 ? 10 : (currMaxValue <= 100 ? 25 : (currMaxValue <= 500 ? 50 : (currMaxValue <= 1000 ? 100 : (currMaxValue <= 5000 ? 500 : (currMaxValue <= 10000 ? 1000 : (currMaxValue <= 50000 ? 5000 : (currMaxValue <= 100000 ? 10000 : 50000)))))));
        return currMaxValue != 0 && currMaxValue % baseParam == 0 ? currMaxValue : (Math.floorDiv(currMaxValue, baseParam) + 1) * baseParam;
    }

    private static class InstanceHolder {
        private static final TaskIndexDataService INSTANCE = new TaskIndexDataService();

        private InstanceHolder() {
        }
    }
}

