/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.task;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class UserGroupService {
    public static UserGroupService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static Set<Long> getManageGroup(String sscid, String userId) {
        DynamicObject[] userGroups;
        QFilter sscFilter = new QFilter("createorg", "=", (Object)Long.valueOf(sscid));
        HashSet<Long> manageSet = new HashSet<Long>(16);
        for (DynamicObject usergroup : userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,entryentity.teamleader,entryentity.userfield", (QFilter[])new QFilter[]{sscFilter})) {
            DynamicObjectCollection usergroupColl = usergroup.getDynamicObjectCollection("entryentity");
            Long userGroupID = usergroup.getLong("id");
            for (DynamicObject user : usergroupColl) {
                String userID = user.getString("userfield.id");
                boolean isLeader = user.getBoolean("teamleader");
                if (!isLeader || !userId.equals(userID)) continue;
                manageSet.add(userGroupID);
            }
        }
        return manageSet;
    }

    public static boolean isGroupLeader(String userId, String sscId) {
        Set<Long> manageGroup = UserGroupService.getManageGroup(sscId, userId);
        return !manageGroup.isEmpty();
    }

    public static Set<String> getManageSsc(Long userId) {
        DynamicObject[] userGroups;
        HashSet<String> manageSscSet = new HashSet<String>(16);
        QFilter filter1 = new QFilter("entryentity.teamleader", "=", (Object)"1");
        QFilter filter2 = new QFilter("entryentity.userfield.id", "=", (Object)userId);
        for (DynamicObject usergroup : userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,entryentity.teamleader,entryentity.userfield,createorg.id", (QFilter[])new QFilter[]{filter1, filter2})) {
            manageSscSet.add(usergroup.getString("createorg.id"));
        }
        return manageSscSet;
    }

    public static List<Long> getUsergroupIds(Long sscId, Long userId) {
        QFilter filter1 = new QFilter("createorg", "=", (Object)sscId);
        QFilter filter2 = new QFilter("entryentity.userfield.id", "=", (Object)userId);
        DynamicObject[] userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
        if (userGroups == null || userGroups.length == 0) {
            return null;
        }
        return Stream.of(userGroups).map(userGroup -> userGroup.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getGroupBosUsers(Set<Long> groupIdSet) {
        QFilter qFilter = new QFilter("id", "in", groupIdSet);
        DynamicObjectCollection userGroups = QueryServiceHelper.query((String)"task_usergroup", (String)"id,entryentity.userfield.id", (QFilter[])new QFilter[]{qFilter});
        if (userGroups == null || userGroups.size() == 0) {
            return new ArrayList<Long>();
        }
        return userGroups.stream().map(userGroup -> userGroup.getLong("entryentity.userfield.id")).collect(Collectors.toList());
    }

    public List<Long> getGroupBosUsers(Long sscid) {
        QFilter qFilter = new QFilter("createorg", "=", (Object)sscid);
        DynamicObjectCollection userGroups = QueryServiceHelper.query((String)"task_usergroup", (String)"id,entryentity.userfield.id", (QFilter[])new QFilter[]{qFilter});
        if (userGroups == null || userGroups.size() == 0) {
            return new ArrayList<Long>();
        }
        return userGroups.stream().map(userGroup -> userGroup.getLong("entryentity.userfield.id")).collect(Collectors.toList());
    }

    private static class InstanceHolder {
        private static final UserGroupService INSTANCE = new UserGroupService();

        private InstanceHolder() {
        }
    }
}

